/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.kgslab.svgeditor;

import cx.ath.kgslab.svgeditor.BasePanel;
import cx.ath.kgslab.svgeditor.items.Item;
import cx.ath.kgslab.svgeditor.items.Text;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.awt.image.VolatileImage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JOptionPane;

public class CanvasPanel
extends BasePanel
implements MouseListener,
MouseMotionListener,
KeyListener {
    List strokes = new ArrayList();
    boolean drawing = false;
    boolean selecting = false;
    boolean dragging = false;
    protected VolatileImage testArea = null;

    public CanvasPanel() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.setFocusable(true);
    }

    public void mouseClicked(MouseEvent e) {
        if (this.selecting) {
            this.item = null;
            ListIterator ite = this.strokes.listIterator(this.strokes.size());
            while (ite.hasPrevious()) {
                Item element = (Item)ite.previous();
                Shape shape = element.getShape();
                if (shape instanceof Line2D) {
                    if (!shape.intersects(e.getX() - 1, e.getY() - 1, 3.0, 3.0)) continue;
                    this.item = element;
                    break;
                }
                if (!shape.contains(e.getX(), e.getY())) continue;
                this.item = element;
                break;
            }
            this.update();
            this.repaint();
            this.grabFocus();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.dragging = false;
        if ((e.getButton() & 1) == 1) {
            if (this.clazz != null) {
                try {
                    this.item = null;
                    this.drawing = false;
                    this.createItem();
                    this.item.setX(e.getX());
                    this.item.setY(e.getY());
                    this.item.setCanvas(this);
                    this.strokes.add(this.item);
                    this.drawing = true;
                }
                catch (IllegalArgumentException e1) {
                    e1.printStackTrace();
                }
                catch (SecurityException e1) {
                    e1.printStackTrace();
                }
                catch (InstantiationException e1) {
                    e1.printStackTrace();
                }
                catch (IllegalAccessException e1) {
                    e1.printStackTrace();
                }
                catch (InvocationTargetException e1) {
                    e1.printStackTrace();
                }
                catch (NoSuchMethodException e1) {
                    e1.printStackTrace();
                }
            }
        } else if (this.drawing) {
            this.drawing = false;
            this.strokes.remove(this.item);
            this.item = null;
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.drawing && this.item != null) {
            if (this.item instanceof Text) {
                Text text = (Text)this.item;
                String string = JOptionPane.showInputDialog(this, (Object)"\u633f\u5165\u3059\u308b\u6587\u5b57\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044");
                if (string != null) {
                    text.setText(string);
                    this.update();
                    this.repaint();
                } else {
                    this.strokes.remove(this.item);
                }
            } else if (!this.dragging) {
                this.strokes.remove(this.item);
            }
            this.item = null;
            this.drawing = false;
            this.dragging = false;
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.dragging = true;
        if (this.item != null) {
            if (this.drawing) {
                this.item.form(e.getX(), e.getY());
            } else if (this.selecting) {
                this.item.move(e.getX(), e.getY());
            }
            this.update();
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (this.selecting && this.item != null && (e.getKeyCode() & 0x7F) == 127) {
            this.strokes.remove(this.item);
            this.item = null;
            this.update();
            this.repaint();
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void update() {
        if (this.buffer == null || this.buffer.validate(this.getGraphicsConfiguration()) == 2) {
            this.buffer = this.createVolatileImage(this.getWidth(), this.getHeight());
        }
        Graphics2D g = this.buffer.createGraphics();
        g.setPaint(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Iterator ite = this.strokes.iterator();
        while (ite.hasNext()) {
            Item element = (Item)ite.next();
            element.paint(g);
        }
        if (this.selecting && this.item != null) {
            this.item.selectingPaint(g);
        }
    }

    public List getStrokes() {
        return this.strokes;
    }

    public void setStrokes(List list) {
        this.strokes = list;
    }

    public boolean isSelecting() {
        return this.selecting;
    }

    public void setSelecting(boolean b) {
        this.selecting = b;
    }

    public VolatileImage getTestArea() {
        if (this.testArea == null || this.testArea.validate(this.getGraphicsConfiguration()) == 2) {
            this.testArea = this.createVolatileImage(this.getWidth(), this.getHeight());
        }
        return this.testArea;
    }
}

