/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.kgslab.svgeditor.items;

import cx.ath.kgslab.svgeditor.items.StrokeItem;
import java.awt.Shape;
import java.awt.geom.Line2D;

public class Line
extends StrokeItem {
    public static final String ELEMENT_NAME = "line";
    protected int x2 = 0;
    protected int y2 = 0;
    protected Line2D shape = new Line2D.Double(0.0, 0.0, 0.0, 0.0);

    public Shape getShape() {
        if (this.changed) {
            this.shape.setLine(this.x, this.y, this.x2 + this.x, this.y2 + this.y);
            this.changed = false;
        }
        return this.shape;
    }

    public String getSvgElement() {
        StringBuffer buf = new StringBuffer();
        buf.append("<").append(ELEMENT_NAME);
        buf.append(" x1='").append(this.x).append("'");
        buf.append(" y1='").append(this.y).append("'");
        buf.append(" x2='").append(this.x2 + this.x).append("'");
        buf.append(" y2='").append(this.y2 + this.y).append("'");
        buf.append(" stroke='").append(this.getColorString()).append("'");
        buf.append(" stroke-width='").append(this.lineWidth).append("'/>");
        return buf.toString();
    }

    public int getX2() {
        return this.x2;
    }

    public int getY2() {
        return this.y2;
    }

    public void setX2(int i) {
        this.x2 = i;
        this.changed = true;
    }

    public void setY2(int i) {
        this.y2 = i;
        this.changed = true;
    }

    public void form(int x, int y) {
        this.setX2(x - this.x);
        this.setY2(y - this.y);
    }

    public void initSample(int width, int height) {
        int x = width / 2;
        int y = height / 2;
        int n = y / 3 * 2;
        this.setX(x - n);
        this.setY(y - n);
        this.setX2(n * 2);
        this.setY2(n * 2);
    }
}

