/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.kgslab.svgeditor.items;

import cx.ath.kgslab.svgeditor.items.Item;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class Text
extends Item {
    public static final String ELEMENT_NAME = "text";
    private static final BufferedImage image = new BufferedImage(640, 480, 12);
    private String text = "";
    private String fontFamiry = "sans-serif";
    private int fontStyle = 0;
    private int fontSize = 10;
    private Font font = new Font(this.fontFamiry, this.fontStyle, this.fontSize);
    private Rectangle2D shape = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);

    public Shape getShape() {
        if (this.changed) {
            Graphics2D g = (Graphics2D)this.canvas.getTestArea().getGraphics();
            FontRenderContext context = g.getFontRenderContext();
            TextLayout layout = new TextLayout(this.text, this.font, context);
            layout.draw(g, this.x, this.y);
            Rectangle2D bounds = layout.getBounds();
            this.shape.setRect(bounds.getX() + (double)this.x, bounds.getY() + (double)this.y, bounds.getWidth(), bounds.getHeight());
            this.changed = false;
        }
        return this.shape;
    }

    public String getSvgElement() {
        StringBuffer buf = new StringBuffer();
        buf.append("<").append(ELEMENT_NAME);
        buf.append(" x='").append(this.x).append("'");
        buf.append(" y='").append(this.y).append("'");
        buf.append(" font-famiry='").append(this.fontFamiry).append("'");
        buf.append(" font-size='").append(this.fontSize).append("pt'");
        buf.append(" stroke='").append(this.getColorString()).append("' >");
        buf.append(this.text).append("</").append(ELEMENT_NAME).append('>');
        return buf.toString();
    }

    public void paint(Graphics2D g) {
        g.setColor(this.color);
        String fontFamiry = this.fontFamiry;
        if ("serif".equals(fontFamiry)) {
            fontFamiry = "Serif";
        } else if ("sans-serif".equals(fontFamiry)) {
            fontFamiry = "SansSerif";
        } else if ("monospace".equals(fontFamiry)) {
            fontFamiry = "Monospaced";
        }
        g.setFont(this.font);
        g.drawString(this.text, this.x, this.y);
    }

    public void selectingPaint(Graphics2D g) {
        g.setColor(Color.gray);
        g.setStroke(new BasicStroke(1.0f, 2, 0, 1.0f, new float[]{5.0f, 5.0f}, 0.0f));
        g.draw(this.getShape());
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
        this.changed = true;
    }

    public String getFontFamiry() {
        return this.fontFamiry;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontFamiry(String string) {
        this.fontFamiry = string;
        this.font = new Font(this.fontFamiry, this.fontStyle, this.fontSize);
        this.changed = true;
    }

    public void setFontSize(int i) {
        this.fontSize = i;
        this.font = new Font(this.fontFamiry, this.fontStyle, this.fontSize);
        this.changed = true;
    }

    public void setFontStyle(int i) {
        this.fontStyle = i;
        this.font = new Font(this.fontFamiry, this.fontStyle, this.fontSize);
        this.changed = true;
    }

    public void form(int x, int y) {
    }

    public void initSample(int width, int height) {
        int x = width / 2;
        int y = height / 2;
        int n = y / 3 * 2;
        this.setX(x - n);
        this.setY(y + n);
        this.setText("A");
    }
}

