/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.StringTokenizer;

public final class BlockList {
    public static final String ALL = "#all";
    public static final String EXTENSION = "extension";
    public static final String RESTRICTION = "restriction";
    public static final String SUBSTITUTION = "substitution";
    private boolean _all = false;
    private boolean _extension = false;
    private boolean _restriction = false;
    private boolean _substitution = false;

    public BlockList() {
    }

    public BlockList(String string) {
        if (string != null) {
            this.parseValues(string);
        }
    }

    public boolean hasAll() {
        return this._all;
    }

    public boolean hasExtension() {
        return this._extension;
    }

    public boolean hasRestriction() {
        return this._restriction;
    }

    public boolean hasSubstitution() {
        return this._substitution;
    }

    public String toString() {
        if (this._all) {
            return ALL;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this._extension) {
            stringBuffer.append(EXTENSION);
        }
        if (this._restriction) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(RESTRICTION);
        }
        if (this._substitution) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(RESTRICTION);
        }
        return stringBuffer.toString();
    }

    private void parseValues(String string) {
        if (ALL.equals(string)) {
            this._all = true;
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (EXTENSION.equals(string2)) {
                this._extension = true;
                continue;
            }
            if (RESTRICTION.equals(string2)) {
                this._restriction = true;
                continue;
            }
            if (SUBSTITUTION.equals(string2)) {
                this._substitution = true;
                continue;
            }
            String string3 = "invalid block list: " + string;
            throw new IllegalArgumentException(string3);
        }
    }
}

