/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationException;

public class BooleanValidator
implements TypeValidator {
    private boolean _useFixed = false;
    private boolean _fixed = false;

    public void clearFixed() {
        this._useFixed = false;
    }

    public void setFixed(boolean bl) {
        this._useFixed = true;
        this._fixed = bl;
    }

    public void setFixed(Boolean bl) {
        this._useFixed = true;
        this._fixed = bl;
    }

    public void validate(boolean bl) throws ValidationException {
        if (this._useFixed) {
            if (bl != this._fixed) {
                String string = bl + " is not equal to the fixed value of " + this._fixed;
                throw new ValidationException(string);
            }
            return;
        }
    }

    public void validate(Object object) throws ValidationException {
        if (object == null) {
            String string = "BooleanValidator cannot validate a null object.";
            throw new ValidationException(string);
        }
        boolean bl = false;
        try {
            bl = (Boolean)object;
        }
        catch (Exception exception) {
            String string = "Expecting a Boolean, received instead: ";
            string = string + object.getClass().getName();
            throw new ValidationException(string);
        }
        this.validate(bl);
    }
}

