/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jstl;

import java.util.List;
import java.util.Map;
import org.apache.taglibs.standard.lang.jstl.ELException;
import org.apache.taglibs.standard.lang.jstl.Expression;
import org.apache.taglibs.standard.lang.jstl.Logger;
import org.apache.taglibs.standard.lang.jstl.UnaryOperator;
import org.apache.taglibs.standard.lang.jstl.VariableResolver;

public class UnaryOperatorExpression
extends Expression {
    UnaryOperator mOperator;
    List mOperators;
    Expression mExpression;

    public String getExpressionString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        if (this.mOperator != null) {
            buf.append(this.mOperator.getOperatorSymbol());
            buf.append(" ");
        } else {
            int i = 0;
            while (i < this.mOperators.size()) {
                UnaryOperator operator = (UnaryOperator)this.mOperators.get(i);
                buf.append(operator.getOperatorSymbol());
                buf.append(" ");
                ++i;
            }
        }
        buf.append(this.mExpression.getExpressionString());
        buf.append(")");
        return buf.toString();
    }

    public List getOperators() {
        return this.mOperators;
    }

    public void setOperators(List pOperators) {
        this.mOperators = pOperators;
    }

    public Expression getExpression() {
        return this.mExpression;
    }

    public void setExpression(Expression pExpression) {
        this.mExpression = pExpression;
    }

    public UnaryOperator getOperator() {
        return this.mOperator;
    }

    public void setOperator(UnaryOperator pOperator) {
        this.mOperator = pOperator;
    }

    public UnaryOperatorExpression(UnaryOperator pOperator, List pOperators, Expression pExpression) {
        this.mOperator = pOperator;
        this.mOperators = pOperators;
        this.mExpression = pExpression;
    }

    public Object evaluate(Object pContext, VariableResolver pResolver, Map functions, String defaultPrefix, Logger pLogger) throws ELException {
        Object value = this.mExpression.evaluate(pContext, pResolver, functions, defaultPrefix, pLogger);
        if (this.mOperator != null) {
            value = this.mOperator.apply(value, pContext, pLogger);
        } else {
            int i = this.mOperators.size() - 1;
            while (i >= 0) {
                UnaryOperator operator = (UnaryOperator)this.mOperators.get(i);
                value = operator.apply(value, pContext, pLogger);
                --i;
            }
        }
        return value;
    }
}

