/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import javax.servlet.ServletContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.ui.context.Theme;
import org.springframework.ui.context.ThemeSource;
import org.springframework.ui.context.support.UiApplicationContextUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.support.ServletContextAwareProcessor;
import org.springframework.web.context.support.ServletContextResource;

public class XmlWebApplicationContext
extends AbstractXmlApplicationContext
implements ConfigurableWebApplicationContext {
    public static final String DEFAULT_CONFIG_LOCATION = "/WEB-INF/applicationContext.xml";
    public static final String DEFAULT_CONFIG_LOCATION_PREFIX = "/WEB-INF/";
    public static final String DEFAULT_CONFIG_LOCATION_SUFFIX = ".xml";
    private ServletContext servletContext;
    private String namespace = null;
    private String[] configLocations;
    private ThemeSource themeSource;
    static /* synthetic */ Class class$javax$servlet$ServletContext;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    protected String getNamespace() {
        return this.namespace;
    }

    public void setConfigLocations(String[] configLocations) {
        this.configLocations = configLocations;
    }

    protected String[] getConfigLocations() {
        return this.configLocations;
    }

    public void refresh() throws BeansException {
        if (this.namespace != null) {
            this.setDisplayName("XmlWebApplicationContext for namespace '" + this.namespace + "'");
            if (this.configLocations == null || this.configLocations.length == 0) {
                this.configLocations = new String[]{DEFAULT_CONFIG_LOCATION_PREFIX + this.namespace + DEFAULT_CONFIG_LOCATION_SUFFIX};
            }
        } else {
            this.setDisplayName("Root XmlWebApplicationContext");
            if (this.configLocations == null || this.configLocations.length == 0) {
                this.configLocations = new String[]{DEFAULT_CONFIG_LOCATION};
            }
        }
        super.refresh();
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new ServletContextAwareProcessor(this.servletContext));
        beanFactory.ignoreDependencyType(class$javax$servlet$ServletContext == null ? (class$javax$servlet$ServletContext = XmlWebApplicationContext.class$("javax.servlet.ServletContext")) : class$javax$servlet$ServletContext);
    }

    protected Resource getResourceByPath(String path) {
        return new ServletContextResource(this.servletContext, path);
    }

    protected void onRefresh() {
        this.themeSource = UiApplicationContextUtils.initThemeSource((ApplicationContext)this);
    }

    public Theme getTheme(String themeName) {
        return this.themeSource.getTheme(themeName);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString() + "; ");
        sb.append("config locations=[" + StringUtils.arrayToCommaDelimitedString((Object[])this.configLocations) + "]; ");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

