/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;

public class UserCredentialsDataSourceAdapter
implements DataSource,
InitializingBean {
    private DataSource targetDataSource;
    private String username = "";
    private String password = "";
    private final ThreadLocal threadBoundCredentials = new ThreadLocal();

    public void setTargetDataSource(DataSource targetDataSource) {
        this.targetDataSource = targetDataSource;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void afterPropertiesSet() {
        if (this.targetDataSource == null) {
            throw new IllegalArgumentException("targetDataSource is required");
        }
    }

    public void setCredentialsForCurrentThread(String username, String password) {
        this.threadBoundCredentials.set(new String[]{username, password});
    }

    public void removeCredentialsFromCurrentThread() {
        this.threadBoundCredentials.set(null);
    }

    public final Connection getConnection() throws SQLException {
        String[] threadCredentials = (String[])this.threadBoundCredentials.get();
        if (threadCredentials != null) {
            return this.doGetConnection(threadCredentials[0], threadCredentials[1]);
        }
        return this.doGetConnection(this.username, this.password);
    }

    protected Connection doGetConnection(String username, String password) throws SQLException {
        if (!"".equals(username)) {
            return this.targetDataSource.getConnection(username, password);
        }
        return this.targetDataSource.getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.targetDataSource.getConnection(username, password);
    }

    public int getLoginTimeout() throws SQLException {
        return this.targetDataSource.getLoginTimeout();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.targetDataSource.setLoginTimeout(seconds);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.targetDataSource.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.targetDataSource.setLogWriter(out);
    }
}

