/*
 * $Id: LoginFilter.java,v 1.1 2004/06/23 07:05:16 mashu Exp $
 */
package cx.ath.kgslab.wiki.login;

import java.io.IOException;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import cx.ath.kgslab.webutil.ReplaceRequestWrapper;


/**
 * OCtB^
 * @author VM
 * @version 1.0
 */
public class LoginFilter implements Filter {
  /** DOCUMENT ME! */
  List patterns = null;

  /** DOCUMENT ME! */
  String loginPage = "/form/login/login.jsp";

  /**
   * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
   */
  public void init(FilterConfig config) throws ServletException {
    String param = config.getInitParameter("patterns");
    StringTokenizer tokens = new StringTokenizer(param, " \t\n");

    patterns = new ArrayList(tokens.countTokens());
    while (tokens.hasMoreTokens()) {
      String token = tokens.nextToken().trim();

      patterns.add(token);
    }

    String page = config.getInitParameter("loginPage");

    if ((page != null) && (page.length() > 0)) {
      loginPage = page;
    }
  }

  /**
   * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest, javax.servlet.ServletResponse, javax.servlet.FilterChain)
   */
  public void doFilter(ServletRequest request,
    ServletResponse response, FilterChain chain)
        throws IOException, ServletException {
    HttpServletRequest req = (HttpServletRequest)request;
    HttpServletResponse res = (HttpServletResponse)response;
    HttpSession session = req.getSession();

    if (loginCheck(req, session)) {
      Object obj = session.getAttribute("filtered_params");

      if (obj != null) {
        request = new ReplaceRequestWrapper(req, (Map)obj);
        session.setAttribute("filtered_params", null);
      }

      chain.doFilter(request, response);
    } else {
      session.setAttribute("filtered_action",
        req.getRequestURI().substring(req.getContextPath().length()));
      Map map = req.getParameterMap();
      Iterator ite = map.keySet().iterator();
      Map newMap = new HashMap(map.size());

      while (ite.hasNext()) {
        String key = (String)ite.next();
        Object value = map.get(key);

        newMap.put(key, value);
      }

      session.setAttribute("filtered_params", newMap);
      res.sendRedirect(req.getContextPath() + loginPage);
    }
  }

  /**
   * @param req
   * @return
   */
  private boolean loginCheck(HttpServletRequest req,
    HttpSession session) {
    String userId = req.getParameter("userid");
    String password = req.getParameter("password");

    if ((userId != null) && (password != null)) {
      // TODO `FbN
      session.setAttribute("login_info", userId);
    } else {
      if (patternCheck(req)) {
        if (session.getAttribute("login_info") == null) {
          return false;
        }
      }
    }

    return true;
  }

  /**
   * @param req
   * @return
   */
  private boolean patternCheck(HttpServletRequest req) {
    Iterator ite = patterns.iterator();
    boolean result = false;

    while (ite.hasNext() && !result) {
      String pattern = (String)ite.next();
      StringTokenizer tokens = new StringTokenizer(pattern, "&");

      boolean check = true;

      while (tokens.hasMoreTokens() && check) {
        String token = tokens.nextToken();
        int idx;

        check = tokenCheck(req, token, check);
      }

      if (check) {
        result = true;
      }
    }

    return result;
  }

  /**
   * DOCUMENT ME!
   *
   * @param req DOCUMENT ME!
   * @param token DOCUMENT ME!
   * @param check DOCUMENT ME!
   *
   * @return DOCUMENT ME!
   */
  private boolean tokenCheck(HttpServletRequest req, String token,
    boolean check) {
    int idx = token.indexOf('=');

    if (idx > 0) {
      check = checkRequestParam(req, token, idx, check);
    } else {
      check = checkRequestURI(req, token, check);
    }

    return check;
  }

  /**
   * DOCUMENT ME!
   *
   * @param req DOCUMENT ME!
   * @param token DOCUMENT ME!
   * @param check DOCUMENT ME!
   *
   * @return DOCUMENT ME!
   */
  private boolean checkRequestURI(HttpServletRequest req,
    String token, boolean check) {
    String uri = req.getRequestURI();
    int idx = uri.lastIndexOf('/');

    if (idx >= 0) {
      uri = uri.substring(idx + 1);
    }

    if (!uri.equals(token)) {
      check = false;
    }

    return check;
  }

  /**
   * DOCUMENT ME!
   *
   * @param req DOCUMENT ME!
   * @param token DOCUMENT ME!
   * @param idx DOCUMENT ME!
   * @param check DOCUMENT ME!
   *
   * @return DOCUMENT ME!
   */
  private boolean checkRequestParam(HttpServletRequest req,
    String token, int idx, boolean check) {
    String name = token.substring(0, idx);
    String value = token.substring(idx + 1);
    boolean not = name.endsWith("!");

    if (not) {
      name = name.substring(0, name.length() - 1);
    }

    String param = req.getParameter(name);

    boolean equal = param.equals(value);

    if (not ? equal : (!equal)) {
      check = false;
    }

    return check;
  }

  /**
   * @see javax.servlet.Filter#destroy()
   */
  public void destroy() {
    // TODO ꂽ\bhEX^u
  }
}
