/*
 * $Id: MemberInfo.java,v 1.1 2004/06/23 07:07:46 mashu Exp $
 */
package cx.ath.kgslab.lsmembers;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import cx.ath.kgslab.lsmembers.xml.Charactor;
import cx.ath.kgslab.lsmembers.xml.Job;
import cx.ath.kgslab.lsmembers.xml.Jobs;
import cx.ath.kgslab.lsmembers.xml.Skill;
import cx.ath.kgslab.lsmembers.xml.Skills;


/**
 * o
 *
 * @author VM
 * @version 1.0 
 */
public class MemberInfo implements Serializable {
  /** 푰:q[ */
  public static final int RACE_HUME = 0;

  /** 푰:Go[ */
  public static final int RACE_ELVAAN = 1;

  /** 푰:^^ */
  public static final int RACE_TARUTARU = 2;

  /** 푰:~X */
  public static final int RACE_MITHRA = 3;

  /** 푰:KJ */
  public static final int RACE_GALKA = 4;

  /** :j */
  public static final int GENDER_MALE = 0;

  /** : */
  public static final int GENDER_FEMALE = 1;

  /** tFCX^Cv:1A */
  public static final int FACE_1A = 0x0;

  /** tFCX^Cv:1B */
  public static final int FACE_1B = 0x1;

  /** tFCX^Cv:2A */
  public static final int FACE_2A = 0x2;

  /** tFCX^Cv:2B */
  public static final int FACE_2B = 0x3;

  /** tFCX^Cv:3A */
  public static final int FACE_3A = 0x4;

  /** tFCX^Cv:3B */
  public static final int FACE_3B = 0x5;

  /** tFCX^Cv:4A */
  public static final int FACE_4A = 0x6;

  /** tFCX^Cv:4B */
  public static final int FACE_4B = 0x7;

  /** tFCX^Cv:5A */
  public static final int FACE_5A = 0x8;

  /** tFCX^Cv:5B */
  public static final int FACE_5B = 0x9;

  /** tFCX^Cv:6A */
  public static final int FACE_6A = 0xa;

  /** tFCX^Cv:6B */
  public static final int FACE_6B = 0xb;

  /** tFCX^Cv:7A */
  public static final int FACE_7A = 0xc;

  /** tFCX^Cv:7B */
  public static final int FACE_7B = 0xd;

  /** tFCX^Cv:8A */
  public static final int FACE_8A = 0xe;

  /** tFCX^Cv:8B */
  public static final int FACE_8B = 0xf;

  /** :ThA */
  public static final int REALM_SAND_ORIA = 0;

  /** :oXgD[N */
  public static final int REALM_BASTOK = 1;

  /** :EB_X */
  public static final int REALM_WINDRUST = 2;

  /** Wu:m */
  public static final int JOB_WAR = 0x0;

  /** Wu:N */
  public static final int JOB_MNK = 0x1;

  /** Wu:t */
  public static final int JOB_WHM = 0x2;

  /** Wu:t */
  public static final int JOB_BLM = 0x3;

  /** Wu:Ԗt */
  public static final int JOB_RDM = 0x4;

  /** Wu:V[t */
  public static final int JOB_THF = 0x5;

  /** Wu:iCg */
  public static final int JOB_PLD = 0x6;

  /** Wu:ÍRm */
  public static final int JOB_DRK = 0x7;

  /** Wu:l */
  public static final int JOB_RNG = 0x8;

  /** Wu:Vl */
  public static final int JOB_BRD = 0x9;

  /** Wu:bg */
  public static final int JOB_BST = 0xa;

  /** Wu:Rm */
  public static final int JOB_DRG = 0xb;

  /** Wu:m */
  public static final int JOB_SMN = 0xc;

  /** Wu:E */
  public static final int JOB_NIN = 0xd;

  /** Wu: */
  public static final int JOB_SAM = 0xe;

  /** YXL:b */
  public static final int MANSKILL_SMITHERY = 0x0;

  /** YXL:ٖD */
  public static final int MANSKILL_CLOTHING = 0x1;

  /** YXL:Bp */
  public static final int MANSKILL_ALCHEMY = 0x2;

  /** YXL:؍H */
  public static final int MANSKILL_CARPENTRY = 0x3;

  /** YXL: */
  public static final int MANSKILL_CHASING = 0x4;

  /** YXL:v׍H */
  public static final int MANSKILL_SKINWORK = 0x5;

  /** YXL:׍H */
  public static final int MANSKILL_BONEWORK = 0x6;

  /** YXL:ނ */
  public static final int MANSKILL_FISHING = 0x7;

  /** YXL: */
  public static final int MANSKILL_COOKING = 0x8;

  /** tFCXACR̃t@C */
  static final String[][][] FACE_ICONS =
    new String[][][] {
      {
        {
          "hm1a.png",
          "hm1b.png",
          "hm2a.png",
          "hm2b.png",
          "hm3a.png",
          "hm3b.png",
          "hm4a.png",
          "hm4b.png",
          "hm5a.png",
          "hm5b.png",
          "hm6a.png",
          "hm6b.png",
          "hm7a.png",
          "hm7b.png",
          "hm8a.png",
          "hm8b.png",
        },
        {
          "hf1a.png",
          "hf1b.png",
          "hf2a.png",
          "hf2b.png",
          "hf3a.png",
          "hf3b.png",
          "hf4a.png",
          "hf4b.png",
          "hf5a.png",
          "hf5b.png",
          "hf6a.png",
          "hf6b.png",
          "hf7a.png",
          "hf7b.png",
          "hf8a.png",
          "hf8b.png",
        },
      },
      {
        {
          "em1a.png",
          "em1b.png",
          "em2a.png",
          "em2b.png",
          "em3a.png",
          "em3b.png",
          "em4a.png",
          "em4b.png",
          "em5a.png",
          "em5b.png",
          "em6a.png",
          "em6b.png",
          "em7a.png",
          "em7b.png",
          "em8a.png",
          "em8b.png",
        },
        {
          "ef1a.png",
          "ef1b.png",
          "ef2a.png",
          "ef2b.png",
          "ef3a.png",
          "ef3b.png",
          "ef4a.png",
          "ef4b.png",
          "ef5a.png",
          "ef5b.png",
          "ef6a.png",
          "ef6b.png",
          "ef7a.png",
          "ef7b.png",
          "ef8a.png",
          "ef8b.png",
        },
      },
      {
        {
          "tm1a.png",
          "tm1b.png",
          "tm2a.png",
          "tm2b.png",
          "tm3a.png",
          "tm3b.png",
          "tm4a.png",
          "tm4b.png",
          "tm5a.png",
          "tm5b.png",
          "tm6a.png",
          "tm6b.png",
          "tm7a.png",
          "tm7b.png",
          "tm8a.png",
          "tm8b.png",
        },
        {
          "tf1a.png",
          "tf1b.png",
          "tf2a.png",
          "tf2b.png",
          "tf3a.png",
          "tf3b.png",
          "tf4a.png",
          "tf4b.png",
          "tf5a.png",
          "tf5b.png",
          "tf6a.png",
          "tf6b.png",
          "tf7a.png",
          "tf7b.png",
          "tf8a.png",
          "tf8b.png",
        },
      },
      {
        {
          "mf1a.png",
          "mf1b.png",
          "mf2a.png",
          "mf2b.png",
          "mf3a.png",
          "mf3b.png",
          "mf4a.png",
          "mf4b.png",
          "mf5a.png",
          "mf5b.png",
          "mf6a.png",
          "mf6b.png",
          "mf7a.png",
          "mf7b.png",
          "mf8a.png",
          "mf8b.png",
        },
        {
          "mf1a.png",
          "mf1b.png",
          "mf2a.png",
          "mf2b.png",
          "mf3a.png",
          "mf3b.png",
          "mf4a.png",
          "mf4b.png",
          "mf5a.png",
          "mf5b.png",
          "mf6a.png",
          "mf6b.png",
          "mf7a.png",
          "mf7b.png",
          "mf8a.png",
          "mf8b.png",
        },
      },
      {
        {
          "gm1a.png",
          "gm1b.png",
          "gm2a.png",
          "gm2b.png",
          "gm3a.png",
          "gm3b.png",
          "gm4a.png",
          "gm4b.png",
          "gm5a.png",
          "gm5b.png",
          "gm6a.png",
          "gm6b.png",
          "gm7a.png",
          "gm7b.png",
          "gm8a.png",
          "gm8b.png",
        },
        {
          "gm1a.png",
          "gm1b.png",
          "gm2a.png",
          "gm2b.png",
          "gm3a.png",
          "gm3b.png",
          "gm4a.png",
          "gm4b.png",
          "gm5a.png",
          "gm5b.png",
          "gm6a.png",
          "gm6b.png",
          "gm7a.png",
          "gm7b.png",
          "gm8a.png",
          "gm8b.png",
        },
      },
    };

  /** ACR̃t@C */
  static final String[] REALM_ICONS =
    new String[] {
      "snd.png",
      "bas.png",
      "win.png",
    };

  /** 푰 */
  static final String[] RACE_NAMES =
    new String[] {
      "q[",
      "Go[",
      "^^",
      "~X",
      "KJ",
    };

  /** 푰 */
  static final String[] RACES =
    new String[] {
      "hum",
      "elv",
      "tar",
      "mit",
      "gal",
    };

  /** ʖ */
  static final String[] GENDER_NAMES = new String[] {
      "",
      "",
    };

  /**  */
  static final String[] GENDERS = new String[] {
      "male",
      "female",
    };

  /**  */
  static final String[] REALM_NAMES =
    new String[] {
      "ThA",
      "oXgD[N",
      "EB_X",
    };

  /**  */
  static final String[] REALMS =
    new String[] {
      "snd",
      "bas",
      "win",
    };

  /** Wu */
  static final String[] JOB_NAMES =
    new String[] {
      "",
      "",
      "",
      "",
      "",
      "V",
      "i",
      "",
      "",
      "",
      "b",
      "",
      "",
      "E",
      "",
    };

  /** Wu */
  static final String[] JOBS =
    new String[] {
      "war",
      "mnk",
      "whm",
      "blm",
      "rdm",
      "thf",
      "pld",
      "drk",
      "rng",
      "brd",
      "bst",
      "drg",
      "smn",
      "nin",
      "sam",
    };

  /** YXL */
  static final String[] SKILLS =
    new String[] {
      "smithery",
      "clothing",
      "alchemy",
      "carpentry",
      "chasing",
      "skinwork",
      "bonework",
      "fishing",
      "cooking",
    };

  /** ԍ */
  private int no = 0;

  /** ̍ */
  private String title = "";

  /** O */
  private String name = "";

  /** pX[h */
  private String password = "";

  /** 푰 */
  private int race = RACE_HUME;

  /**  */
  private int gender = GENDER_MALE;

  /** tFCX^Cv */
  private int faceType = FACE_1A;

  /**  */
  private int realm = REALM_SAND_ORIA;

  /** CWu */
  private int mainJob = JOB_WAR;

  /** T|[gWu */
  private int supportJob = JOB_MNK;

  /** Wux */
  private int[] jobLevel = new int[JOBS.length];

  /** YXLx */
  private int[] manSkill = new int[SKILLS.length];

  /** ~bVN */
  private int rank = 1;

  /** Rg */
  private String comment = "";

  /**
   * RXgN^
   *
   */
  public MemberInfo() {
    for (int i = 0; i < jobLevel.length; i++) {
      jobLevel[i] = 1;
    }

    for (int i = 0; i < manSkill.length; i++) {
      manSkill[i] = 0;
    }
  }

  /**
   * RXgN^
   *
   * @param charactor
   */
  public MemberInfo(Charactor charactor) {
    this.setComment(charactor.getComment());
    this.setFaceType(charactor.getFace());
    int gender = this.getGenderIdx(charactor.getGender());

    this.setGender(gender);
    int mainJob = this.getJobIdx(charactor.getJobs().getMainjob());

    this.setMainJob(mainJob);
    int suppJob = this.getJobIdx(charactor.getJobs().getSupportjob());

    this.setSupportJob(suppJob);
    this.setName(charactor.getName());
    this.setNo(charactor.getNo());
    this.setPassword(charactor.getPassword());
    int race = this.getRaceIdx(charactor.getRace());

    this.setRace(race);
    this.setRank(charactor.getRank());
    int realm = this.getRealmIdx(charactor.getRealm());

    this.setRealm(realm);
    this.setTitle(charactor.getTitle());

    for (int i = 0; i < JOBS.length; i++) {
      jobLevel[i] = charactor.getJobs().getJob()[i].getContent();
    }

    for (int i = 0; i < SKILLS.length; i++) {
      manSkill[i] = charactor.getSkills().getSkill()[i].getContent();
    }
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public int getFaceType() {
    return faceType;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public int getGender() {
    return gender;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public int[] getJobLevel() {
    return jobLevel;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public int getMainJob() {
    return mainJob;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public int[] getManSkill() {
    return manSkill;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public String getName() {
    return name;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public String getPassword() {
    return password;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public int getRace() {
    return race;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public int getRank() {
    return rank;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public int getRealm() {
    return realm;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public int getSupportJob() {
    return supportJob;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public String getTitle() {
    return title;
  }

  /**
   * DOCUMENT ME!
   *
   * @param i
   */
  public void setFaceType(int i) {
    faceType = i;
  }

  /**
   * DOCUMENT ME!
   *
   * @param i
   */
  public void setGender(int i) {
    gender = i;
  }

  /**
   * DOCUMENT ME!
   *
   * @param is
   */
  public void setJobLevel(int[] is) {
    jobLevel = is;
  }

  /**
   * DOCUMENT ME!
   *
   * @param i
   */
  public void setMainJob(int i) {
    mainJob = i;
  }

  /**
   * DOCUMENT ME!
   *
   * @param is
   */
  public void setManSkill(int[] is) {
    manSkill = is;
  }

  /**
   * DOCUMENT ME!
   *
   * @param string
   */
  public void setName(String string) {
    name = string;
  }

  /**
   * DOCUMENT ME!
   *
   * @param string
   */
  public void setPassword(String string) {
    password = string;
  }

  /**
   * DOCUMENT ME!
   *
   * @param i
   */
  public void setRace(int i) {
    race = i;
  }

  /**
   * DOCUMENT ME!
   *
   * @param i
   */
  public void setRank(int i) {
    rank = i;
  }

  /**
   * DOCUMENT ME!
   *
   * @param i
   */
  public void setRealm(int i) {
    realm = i;
  }

  /**
   * DOCUMENT ME!
   *
   * @param i
   */
  public void setSupportJob(int i) {
    supportJob = i;
  }

  /**
   * DOCUMENT ME!
   *
   * @param string
   */
  public void setTitle(String string) {
    title = string;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public String getComment() {
    return comment;
  }

  /**
   * DOCUMENT ME!
   *
   * @param string
   */
  public void setComment(String string) {
    comment = string;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public int getNo() {
    return no;
  }

  /**
   * DOCUMENT ME!
   *
   * @param i
   */
  public void setNo(int i) {
    no = i;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public String getFaceIcon() {
    String icon =
      FACE_ICONS[this.getRace()][this.getGender()][this.getFaceType()];

    return icon;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public String getRealmIcon() {
    String icon = REALM_ICONS[this.getRealm()];

    return icon;
  }

  /** DOCUMENT ME! */
  static final MessageFormat JOB_FORMAT =
    new MessageFormat("{0}{1} / {2}{3}");

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public String getJob() {
    int midx = this.getMainJob();
    int sidx = this.getSupportJob();
    int main = this.getJobLevel()[midx];
    int supp = this.getJobLevel()[sidx];

    if (supp > (main / 2)) {
      supp = main / 2;
    }

    if (supp == 0) {
      supp = 1;
    }

    return JOB_FORMAT.format(new Object[] {
        JOB_NAMES[midx],
        new Integer(main),
        JOB_NAMES[sidx],
        new Integer(supp),
      });
  }

  /**
   * DOCUMENT ME!
   *
   * @param race
   *
   * @return
   */
  public int getRaceIdx(String race) {
    return getIndex(RACES, race);
  }

  /**
   * DOCUMENT ME!
   *
   * @param realm
   *
   * @return
   */
  public int getRealmIdx(String realm) {
    return getIndex(REALMS, realm);
  }

  /**
   * DOCUMENT ME!
   *
   * @param gender
   *
   * @return
   */
  public int getGenderIdx(String gender) {
    return getIndex(GENDERS, gender);
  }

  /**
   * DOCUMENT ME!
   *
   * @param job
   *
   * @return
   */
  public int getJobIdx(String job) {
    return getIndex(JOBS, job);
  }

  /**
   * DOCUMENT ME!
   *
   * @param skill
   *
   * @return
   */
  public int getSkillIdx(String skill) {
    return getIndex(SKILLS, skill);
  }

  /**
   * DOCUMENT ME!
   *
   * @param array DOCUMENT ME!
   * @param str DOCUMENT ME!
   *
   * @return DOCUMENT ME!
   */
  private int getIndex(String[] array, String str) {
    int idx = 0;

    for (; idx < array.length; idx++) {
      if (array[idx].equals(str)) {
        break;
      }
    }

    return (idx >= array.length) ? 0 : idx;
  }

  /** DOCUMENT ME! */
  static final ArrayList JOB_NAMES_LIST =
    new ArrayList(Arrays.asList(JOB_NAMES));

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public List getJobName() {
    return JOB_NAMES_LIST;
  }

  /** DOCUMENT ME! */
  static final ArrayList JOB_CLASS_LIST =
    new ArrayList(Arrays.asList(
        new Integer[] {
          new Integer(JOB_WAR),
          new Integer(JOB_MNK),
          new Integer(JOB_WHM),
          new Integer(JOB_BLM),
          new Integer(JOB_RDM),
          new Integer(JOB_THF),
          new Integer(JOB_PLD),
          new Integer(JOB_DRK),
          new Integer(JOB_RNG),
          new Integer(JOB_BRD),
          new Integer(JOB_BST),
          new Integer(JOB_DRG),
          new Integer(JOB_SMN),
          new Integer(JOB_NIN),
          new Integer(JOB_SAM),
        }));

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public List getJobClass() {
    return JOB_CLASS_LIST;
  }

  /** DOCUMENT ME! */
  static final ArrayList REALM_NAMES_LIST =
    new ArrayList(Arrays.asList(REALM_NAMES));

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public List getRealmName() {
    return REALM_NAMES_LIST;
  }

  /** DOCUMENT ME! */
  static final ArrayList REALM_VALUE_LIST =
    new ArrayList(Arrays.asList(
        new Integer[] {
          new Integer(REALM_SAND_ORIA),
          new Integer(REALM_BASTOK),
          new Integer(REALM_WINDRUST),
        }));

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public List getRealmValue() {
    return REALM_VALUE_LIST;
  }

  /** DOCUMENT ME! */
  static final ArrayList GENDER_NAMES_LIST =
    new ArrayList(Arrays.asList(GENDER_NAMES));

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public List getGenderName() {
    return GENDER_NAMES_LIST;
  }

  /** DOCUMENT ME! */
  static final ArrayList GENDER_VALUE_LIST =
    new ArrayList(Arrays.asList(
        new Integer[] {
          new Integer(GENDER_MALE),
          new Integer(GENDER_FEMALE),
        }));

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public List getGenderValue() {
    return GENDER_VALUE_LIST;
  }

  /** DOCUMENT ME! */
  static final ArrayList RACE_NAMES_LIST =
    new ArrayList(Arrays.asList(RACE_NAMES));

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public List getRaceName() {
    return RACE_NAMES_LIST;
  }

  /** DOCUMENT ME! */
  static final ArrayList RACE_VALUE_LIST =
    new ArrayList(Arrays.asList(
        new Integer[] {
          new Integer(RACE_HUME),
          new Integer(RACE_ELVAAN),
          new Integer(RACE_TARUTARU),
          new Integer(RACE_MITHRA),
          new Integer(RACE_GALKA),
        }));

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public List getRaceValue() {
    return RACE_VALUE_LIST;
  }

  /** DOCUMENT ME! */
  static final ArrayList FACE_NAMES_LIST =
    new ArrayList(Arrays.asList(
        new String[] {
          "1A",
          "1B",
          "2A",
          "2B",
          "3A",
          "3B",
          "4A",
          "4B",
          "5A",
          "5B",
          "6A",
          "6B",
          "7A",
          "7B",
          "8A",
          "8B",
        }));

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public List getFaceName() {
    return FACE_NAMES_LIST;
  }

  /** DOCUMENT ME! */
  static final ArrayList FACE_VALUE_LIST =
    new ArrayList(Arrays.asList(
        new Integer[] {
          new Integer(FACE_1A),
          new Integer(FACE_1B),
          new Integer(FACE_2A),
          new Integer(FACE_2B),
          new Integer(FACE_3A),
          new Integer(FACE_3B),
          new Integer(FACE_4A),
          new Integer(FACE_4B),
          new Integer(FACE_5A),
          new Integer(FACE_5B),
          new Integer(FACE_6A),
          new Integer(FACE_6B),
          new Integer(FACE_7A),
          new Integer(FACE_7B),
          new Integer(FACE_8A),
          new Integer(FACE_8B),
        }));

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public List getFaceValue() {
    return FACE_VALUE_LIST;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public Charactor toCharactor() {
    Charactor charactor = new Charactor();

    charactor.setComment(this.getComment());
    charactor.setFace(this.getFaceType());
    charactor.setGender(MemberInfo.GENDERS[this.getGender()]);
    Jobs jobs = new Jobs();

    jobs.setMainjob(MemberInfo.JOBS[this.getMainJob()]);
    jobs.setSupportjob(MemberInfo.JOBS[this.getSupportJob()]);
    charactor.setName(this.getName());
    charactor.setNo(this.getNo());
    charactor.setPassword(this.getPassword());
    charactor.setRace(MemberInfo.RACES[this.getRace()]);
    charactor.setRank(this.getRank());
    charactor.setRealm(MemberInfo.REALMS[this.getRealm()]);
    charactor.setTitle(this.getTitle());

    for (int i = 0; i < JOBS.length; i++) {
      Job job = new Job();

      job.setClassValue(JOBS[i]);
      job.setContent(jobLevel[i]);
      jobs.addJob(job);
    }

    charactor.setJobs(jobs);

    Skills skills = new Skills();

    for (int i = 0; i < SKILLS.length; i++) {
      Skill skill = new Skill();

      skill.setClassValue(SKILLS[i]);
      skill.setContent(manSkill[i]);
      skills.addSkill(skill);
    }

    charactor.setSkills(skills);

    return charactor;
  }
}
