package cx.ath.kgslab.lsmembers.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;


/**
 * <b>Skills</b> is generated from LsMembers.rng by Relaxer.
 * This class is derived from:
 *
 * <!-- for programmer
 * <element name="skills">
 *   <oneOrMore>
 *     <ref name="skill"/>
 *   </oneOrMore>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="skills"&gt;
 *   &lt;oneOrMore&gt;
 *     &lt;ref name="skill"/&gt;
 *   &lt;/oneOrMore&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version LsMembers.rng (Sun Oct 26 02:34:09 JST 2003)
 * @author  Relaxer 1.0rc3 (http://www.relaxer.org)
 */
public class Skills implements java.io.Serializable, Cloneable,
  IRNSContainer, IRContentClassHandler, IRNode {
  /** DOCUMENT ME! */
  private RNSContext rNSContext_ =
    new RNSContext(this,
      "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0");

  // List<Skill>

  /** DOCUMENT ME! */
  private java.util.List skill_ = new java.util.ArrayList();

  /** DOCUMENT ME! */
  private StringBuffer saxBuffer_;

  /** DOCUMENT ME! */
  private IRNode parentRNode_;

  /**
   * Creates a <code>Skills</code>.
   *
   */
  public Skills() {
  }

  /**
   * Creates a <code>Skills</code>.
   *
   * @param source
   */
  public Skills(Skills source) {
    setup(source);
  }

  /**
   * Creates a <code>Skills</code> by the Stack <code>stack</code>
   * that contains Elements.
   * This constructor is supposed to be used internally
   * by the Relaxer system.
   *
   * @param stack
   */
  public Skills(RStack stack) {
    setup(stack);
  }

  /**
   * Creates a <code>Skills</code> by the Document <code>doc</code>.
   *
   * @param doc
   */
  public Skills(Document doc) {
    setup(doc.getDocumentElement());
  }

  /**
   * Creates a <code>Skills</code> by the Element <code>element</code>.
   *
   * @param element
   */
  public Skills(Element element) {
    setup(element);
  }

  /**
   * Creates a <code>Skills</code> by the File <code>file</code>.
   *
   * @param file
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Skills(File file)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(file);
  }

  /**
   * Creates a <code>Skills</code>
   * by the String representation of URI <code>uri</code>.
   *
   * @param uri
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Skills(String uri)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(uri);
  }

  /**
   * Creates a <code>Skills</code> by the URL <code>url</code>.
   *
   * @param url
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Skills(URL url)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(url);
  }

  /**
   * Creates a <code>Skills</code> by the InputStream <code>in</code>.
   *
   * @param in
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Skills(InputStream in)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(in);
  }

  /**
   * Creates a <code>Skills</code> by the InputSource <code>is</code>.
   *
   * @param is
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Skills(InputSource is)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(is);
  }

  /**
   * Creates a <code>Skills</code> by the Reader <code>reader</code>.
   *
   * @param reader
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Skills(Reader reader)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(reader);
  }

  /**
   * Initializes the <code>Skills</code> by the Skills <code>source</code>.
   *
   * @param source
   */
  public void setup(Skills source) {
    int size;

    this.skill_.clear();
    size = source.skill_.size();
    for (int i = 0; i < size; i++) {
      addSkill((Skill)source.getSkill(i).clone());
    }
  }

  /**
   * Initializes the <code>Skills</code> by the Document <code>doc</code>.
   *
   * @param doc
   */
  public void setup(Document doc) {
    setup(doc.getDocumentElement());
  }

  /**
   * Initializes the <code>Skills</code> by the Element <code>element</code>.
   *
   * @param element
   */
  public void setup(Element element) {
    init(element);
  }

  /**
   * Initializes the <code>Skills</code> by the Stack <code>stack</code>
   * that contains Elements.
   * This constructor is supposed to be used internally
   * by the Relaxer system.
   *
   * @param stack
   */
  public void setup(RStack stack) {
    init(stack.popElement());
  }

  /**
   * @param element
   */
  private void init(Element element) {
    RStack stack = new RStack(element);

    rNSContext_.declareNamespace(element);
    skill_.clear();
    while (true) {
      if (Skill.isMatch(stack)) {
        addSkill(new Skill(stack));
      } else {
        break;
      }
    }
  }

  /**
   * @return Object
   */
  public Object clone() {
    return (new Skills(this));
  }

  /**
   * Creates a DOM representation of the object.
   * Result is appended to the Node <code>parent</code>.
   *
   * @param parent
   */
  public void makeElement(Node parent) {
    Document doc;

    if (parent instanceof Document) {
      doc = (Document)parent;
    } else {
      doc = parent.getOwnerDocument();
    }

    Element element =
      doc.createElementNS("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
        "skills");

    rNSContext_.setupNamespace(element);
    int size;

    size = this.skill_.size();
    for (int i = 0; i < size; i++) {
      Skill value = (Skill)this.skill_.get(i);

      value.makeElement(element);
    }

    parent.appendChild(element);
  }

  /**
   * Initializes the <code>Skills</code> by the File <code>file</code>.
   *
   * @param file
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(File file)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(file.toURL());
  }

  /**
   * Initializes the <code>Skills</code>
   * by the String representation of URI <code>uri</code>.
   *
   * @param uri
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(String uri)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>Skills</code> by the URL <code>url</code>.
   *
   * @param url
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(URL url)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>Skills</code> by the InputStream <code>in</code>.
   *
   * @param in
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(InputStream in)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>Skills</code> by the InputSource <code>is</code>.
   *
   * @param is
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(InputSource is)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>Skills</code> by the Reader <code>reader</code>.
   *
   * @param reader
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(Reader reader)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Creates a DOM document representation of the object.
   *
   * @exception ParserConfigurationException
   * @return Document
   */
  public Document makeDocument() throws ParserConfigurationException {
    Document doc = UJAXP.makeDocument();

    makeElement(doc);

    return (doc);
  }

  /**
   * Gets the RNSContext property <b>RNSContext</b>.
   *
   * @return RNSContext
   */
  public final RNSContext rGetRNSContext() {
    return (rNSContext_);
  }

  /**
   * Sets the RNSContext property <b>RNSContext</b>.
   *
   * @param rNSContext
   */
  public final void rSetRNSContext(RNSContext rNSContext) {
    this.rNSContext_ = rNSContext;
  }

  /**
   * Gets the Skill property <b>skill</b>.
   *
   * @return Skill[]
   */
  public final Skill[] getSkill() {
    Skill[] array = new Skill[skill_.size()];

    return ((Skill[])skill_.toArray(array));
  }

  /**
   * Sets the Skill property <b>skill</b>.
   *
   * @param skill
   */
  public final void setSkill(Skill[] skill) {
    this.skill_.clear();
    for (int i = 0; i < skill.length; i++) {
      addSkill(skill[i]);
    }

    for (int i = 0; i < skill.length; i++) {
      skill[i].rSetParentRNode(this);
    }
  }

  /**
   * Sets the Skill property <b>skill</b>.
   *
   * @param skill
   */
  public final void setSkill(Skill skill) {
    this.skill_.clear();
    addSkill(skill);
    if (skill != null) {
      skill.rSetParentRNode(this);
    }
  }

  /**
   * Adds the Skill property <b>skill</b>.
   *
   * @param skill
   */
  public final void addSkill(Skill skill) {
    this.skill_.add(skill);
    if (skill != null) {
      skill.rSetParentRNode(this);
    }
  }

  /**
   * Adds the Skill property <b>skill</b>.
   *
   * @param skill
   */
  public final void addSkill(Skill[] skill) {
    for (int i = 0; i < skill.length; i++) {
      addSkill(skill[i]);
    }

    for (int i = 0; i < skill.length; i++) {
      skill[i].rSetParentRNode(this);
    }
  }

  /**
   * Gets number of the Skill property <b>skill</b>.
   *
   * @return int
   */
  public final int sizeSkill() {
    return (skill_.size());
  }

  /**
   * Gets the Skill property <b>skill</b> by index.
   *
   * @param index
   * @return Skill
   */
  public final Skill getSkill(int index) {
    return ((Skill)skill_.get(index));
  }

  /**
   * Sets the Skill property <b>skill</b> by index.
   *
   * @param index
   * @param skill
   */
  public final void setSkill(int index, Skill skill) {
    this.skill_.set(index, skill);
    if (skill != null) {
      skill.rSetParentRNode(this);
    }
  }

  /**
   * Adds the Skill property <b>skill</b> by index.
   *
   * @param index
   * @param skill
   */
  public final void addSkill(int index, Skill skill) {
    this.skill_.add(index, skill);
    if (skill != null) {
      skill.rSetParentRNode(this);
    }
  }

  /**
   * Remove the Skill property <b>skill</b> by index.
   *
   * @param index
   */
  public final void removeSkill(int index) {
    this.skill_.remove(index);
  }

  /**
   * Remove the Skill property <b>skill</b> by object.
   *
   * @param skill
   */
  public final void removeSkill(Skill skill) {
    this.skill_.remove(skill);
  }

  /**
   * Clear the Skill property <b>skill</b>.
   *
   */
  public final void clearSkill() {
    this.skill_.clear();
  }

  /**
   * Makes an XML text representation.
   *
   * @return String
   */
  public String makeTextDocument() {
    StringBuffer buffer = new StringBuffer();

    makeTextElement(buffer);

    return (new String(buffer));
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextElement(StringBuffer buffer) {
    int size;
    String prefix =
      rNSContext_.getPrefixByUri(
        "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0");

    buffer.append("<");
    URelaxer.makeQName(prefix, "skills", buffer);
    rNSContext_.makeNSMappings(buffer);
    buffer.append(">");
    size = this.skill_.size();
    for (int i = 0; i < size; i++) {
      Skill value = (Skill)this.skill_.get(i);

      value.makeTextElement(buffer);
    }

    buffer.append("</");
    URelaxer.makeQName(prefix, "skills", buffer);
    buffer.append(">");
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   * @exception IOException
   */
  public void makeTextElement(Writer buffer) throws IOException {
    int size;
    String prefix =
      rNSContext_.getPrefixByUri(
        "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0");

    buffer.write("<");
    URelaxer.makeQName(prefix, "skills", buffer);
    rNSContext_.makeNSMappings(buffer);
    buffer.write(">");
    size = this.skill_.size();
    for (int i = 0; i < size; i++) {
      Skill value = (Skill)this.skill_.get(i);

      value.makeTextElement(buffer);
    }

    buffer.write("</");
    URelaxer.makeQName(prefix, "skills", buffer);
    buffer.write(">");
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextElement(PrintWriter buffer) {
    int size;
    String prefix =
      rNSContext_.getPrefixByUri(
        "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0");

    buffer.print("<");
    URelaxer.makeQName(prefix, "skills", buffer);
    rNSContext_.makeNSMappings(buffer);
    buffer.print(">");
    size = this.skill_.size();
    for (int i = 0; i < size; i++) {
      Skill value = (Skill)this.skill_.get(i);

      value.makeTextElement(buffer);
    }

    buffer.print("</");
    URelaxer.makeQName(prefix, "skills", buffer);
    buffer.print(">");
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextAttribute(StringBuffer buffer) {
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   * @exception IOException
   */
  public void makeTextAttribute(Writer buffer) throws IOException {
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextAttribute(PrintWriter buffer) {
  }

  /**
   * Returns a String representation of this object.
   * While this method informs as XML format representaion,
   *  it's purpose is just information, not making
   * a rigid XML documentation.
   *
   * @return String
   */
  public String toString() {
    try {
      return (makeTextDocument());
    } catch (Exception e) {
      return (super.toString());
    }
  }

  /**
   * Generates SAX events for ContentHandler.
   *
   * @param handler
   * @exception SAXException
   */
  public void makeDocument(ContentHandler handler)
        throws SAXException {
    handler.startDocument();
    makeElement(handler);
    handler.endDocument();
  }

  /**
   * Generates SAX events for ContentHandler.
   *
   * @param handler
   * @exception SAXException
   */
  public void makeElement(ContentHandler handler) throws SAXException {
    rNSContext_.startNSMappings(handler);
    String prefix =
      rNSContext_.getPrefixByUri(
        "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0");
    int size;
    String string;
    String slotQName;
    AttributesImpl attrs = new AttributesImpl();
    String qName = URelaxer.getQName(prefix, "skills");

    handler.startElement("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
      "skills", qName, attrs);
    size = this.skill_.size();
    for (int i = 0; i < size; i++) {
      Skill value = (Skill)this.skill_.get(i);

      value.makeElement(handler);
    }

    handler.endElement("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
      "skills", qName);
    rNSContext_.endNSMappings(handler);
  }

  /**
   * Generates SAX events for ContentHandler.
   *
   * @param attrs
   * @exception SAXException
   */
  public void makeAttribute(AttributesImpl attrs) throws SAXException {
  }

  /**
   * Event handler for InitElement during object construction.
   *
   * @param attrs
   */
  public void initElement(Attributes attrs) {
    String string;
  }

  /**
   * Event handler for declarePrefixMapping during object construction.
   *
   * @param prefix
   * @param uri
   */
  public void declarePrefixMapping(String prefix, String uri) {
    rNSContext_.declareNamespace(prefix, uri);
  }

  /**
   * Event handler for startElement during object construction.
   *
   * @param namespaceURI
   * @param localName
   * @param qName
   * @param attrs
   * @return IRContentClassHandler
   */
  public IRContentClassHandler startElement(String namespaceURI,
    String localName, String qName, Attributes attrs) {
    if ("skill".equals(localName)
        && "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0".equals(
          namespaceURI)) {
      Skill ref = new Skill();

      ref.initElement(attrs);
      addSkill(ref);

      return (ref);
    }

    return (this);
  }

  /**
   * Event handler for endElement during object construction.
   *
   * @param namespaceURI
   * @param localName
   * @param qName
   * @return IRContentClassHandler
   */
  public IRContentClassHandler endElement(String namespaceURI,
    String localName, String qName) {
    String string;

    return ((IRContentClassHandler)rGetParentRNode());
  }

  /**
   * Event handler for characters during object construction.
   *
   * @param ch
   * @param start
   * @param length
   */
  public void characters(char[] ch, int start, int length) {
    if (saxBuffer_ != null) {
      saxBuffer_.append(ch, start, length);
    }
  }

  /**
   * Event handler for processngInstruction during object construction.
   *
   * @param target
   * @param value
   */
  public void processingInstruction(String target, String value) {
  }

  /**
   * Gets the IRNode property <b>parentRNode</b>.
   *
   * @return IRNode
   */
  public final IRNode rGetParentRNode() {
    return (parentRNode_);
  }

  /**
   * Sets the IRNode property <b>parentRNode</b>.
   *
   * @param parentRNode
   */
  public final void rSetParentRNode(IRNode parentRNode) {
    this.parentRNode_ = parentRNode;
  }

  /**
   * Gets child RNodes.
   *
   * @return IRNode[]
   */
  public IRNode[] rGetRNodes() {
    java.util.List classNodes = new java.util.ArrayList();

    classNodes.addAll(skill_);
    IRNode[] nodes = new IRNode[classNodes.size()];

    return ((IRNode[])classNodes.toArray(nodes));
  }

  /**
   * Tests if a Element <code>element</code> is valid
   * for the <code>Skills</code>.
   *
   * @param element
   * @return boolean
   */
  public static boolean isMatch(Element element) {
    if (!URelaxer2.isTargetElement(element,
          "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0", "skills")) {
      return (false);
    }

    RStack target = new RStack(element);
    boolean $match$ = false;
    Element child;

    if (!Skill.isMatchHungry(target)) {
      return (false);
    }

    $match$ = true;
    while (true) {
      if (!Skill.isMatchHungry(target)) {
        break;
      }

      $match$ = true;
    }

    if (!target.isEmptyElement()) {
      return (false);
    }

    return (true);
  }

  /**
   * Tests if elements contained in a Stack <code>stack</code>
   * is valid for the <code>Skills</code>.
   * This mehtod is supposed to be used internally
   * by the Relaxer system.
   *
   * @param stack
   * @return boolean
   */
  public static boolean isMatch(RStack stack) {
    Element element = stack.peekElement();

    if (element == null) {
      return (false);
    }

    return (isMatch(element));
  }

  /**
   * Tests if elements contained in a Stack <code>stack</code>
   * is valid for the <code>Skills</code>.
   * This method consumes the stack contents during matching operation.
   * This mehtod is supposed to be used internally
   * by the Relaxer system.
   *
   * @param stack
   * @return boolean
   */
  public static boolean isMatchHungry(RStack stack) {
    Element element = stack.peekElement();

    if (element == null) {
      return (false);
    }

    if (isMatch(element)) {
      stack.popElement();

      return (true);
    } else {
      return (false);
    }
  }
}
