/*
 * $Id: SearchManager.java,v 1.1 2004/06/23 07:13:39 mashu Exp $
 */
package cx.ath.kgslab.wiki.search;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;

import cx.ath.kgslab.util.DateUtils;
import cx.ath.kgslab.wiki.AbstractPageManager;
import cx.ath.kgslab.wiki.JaJaWikiConfig;
import cx.ath.kgslab.wiki.PageManager;
import cx.ath.kgslab.wiki.exception.PageReadException;
import cx.ath.kgslab.wiki.pages.Page;
import cx.ath.kgslab.wiki.search.struts.form.SearchResult;


/**
 * ǗNX.
 * <br>
 * CfbNX쐬As̏sNXB
 *
 * @author VM
 * @version 4.0 
 *
 * @since JaJaWiki 2.5
 */
public class SearchManager implements ApplicationContextAware,
  InitializingBean {
  /**
   * CfbNXi[tH_
   */
  public static final String INDEX = "WEB-INF/index";

  /**
   * CfbNXi[tH_ Real Path
   */
  private String indexDir = "";

  /**
   * y[W}l[W
   */
  private PageManager pageManager = null;

  /**
   * senHomefBNg
   */
  private String senHome = "";

  /**
   * JaJaWikiݒ
   */
  private JaJaWikiConfig config = null;

  /**
   * AvP[VReLXg
   */
  private ApplicationContext context = null;

  /**
   * RXgN^
   */
  public SearchManager() {
  }

  /**
   * 
   * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
   */
  public void afterPropertiesSet() throws Exception {
    pageManager = (PageManager)context.getBean("pageManager");
    if (context instanceof WebApplicationContext) {
      initialize((WebApplicationContext)context);
    } else {
      // X^hAAv̏ꍇ
      initialize(config.getRoot());
    }

//    if ((senHome != null) && (senHome.length() > 0)) {
//      SenUtils.setSenHome(senHome);
//    }

    createIndex();
  }

  /**
   * 
   *
   * @param root
   */
  private void initialize(String root) {
    indexDir = new File(root, SearchManager.INDEX).toString();
  }

  /**
   * 
   *
   * @param context
   */
  public void initialize(WebApplicationContext context) {
    indexDir =
      context.getServletContext().getRealPath(SearchManager.INDEX);
  }

  /**
   * CfbNX쐬
   *
   * @param page Ώۂ̃y[W
   *
   * @throws IOException
   */
  public void addIndex(Page page) throws IOException {
    File dir = new File(indexDir);
    boolean create = false;

    if (!dir.exists()) {
      create = true;
      dir.mkdirs();
    } else {
      // ÂCfbNX폜
      IndexReader reader = IndexReader.open(dir);

      reader.delete(new Term("fullpath",
          AbstractPageManager.concatPath(page.getPath(),
            page.getTitle())));
      reader.close();
    }

    // CfbNXǉ
    IndexWriter writer =
      new IndexWriter(dir, getAnalyzer(), create);

    writer.addDocument(createDocument(page));

    writer.optimize();
    writer.close();
  }

  /**
   * CfbNX쐬
   *
   * @throws IOException
   * @throws PageReadException
   */
  public void createIndex() throws IOException, PageReadException {
    File dir = new File(indexDir);

    if (!dir.exists()) {
      dir.mkdirs();
    }

    IndexWriter writer =
      new IndexWriter(dir, getAnalyzer(), true);
    List pages = this.pageManager.getPageList();
    Iterator itarator = pages.iterator();

    while (itarator.hasNext()) {
      writer.addDocument(createDocument((Page)itarator.next()));
    }

    writer.optimize();
    writer.close();
  }

  /**
   * LucenephLg쐬
   *
   * @param page Ώۂ̃y[W
   *
   * @return hLg
   */
  private Document createDocument(Page page) {
    Document doc = new Document();

    doc.add(Field.Keyword("title", page.getTitle()));

    if (page.getPath() != null) {
      doc.add(Field.Keyword("path", page.getPath()));
    } else {
      doc.add(Field.Keyword("path", ""));
    }

    doc.add(Field.Keyword("fullpath",
        AbstractPageManager.concatPath(page.getPath(), page.getTitle())));

    doc.add(Field.Keyword("modified",
        DateUtils.formatISODateTime(page.getLastModified())));

    doc.add(Field.Text("charset", config.getPageEncode()));
    doc.add(Field.Text("contents", page.getContent()));

    return doc;
  }

  /**
   * 
   *
   * @param keyWord L[[h
   *
   * @return ʃXg
   *
   * @throws IOException
   * @throws ParseException
   */
  public List search(String keyWord)
        throws IOException, ParseException {
    IndexReader reader = IndexReader.open(indexDir);
    Searcher searcher = new IndexSearcher(reader);

    Query query = QueryParser.parse(keyWord, "contents", getAnalyzer());

    Hits hits = searcher.search(query);
    List result = new ArrayList(hits.length());
    List test = new ArrayList(hits.length());

    for (int i = 0; i < hits.length(); i++) {
      Document doc = hits.doc(i);
      String title = doc.get("title");
      String path = doc.get("path");
      String fullpath = doc.get("fullpath");

      if (!test.contains(fullpath)) {
        result.add(new SearchResult(title.intern(), path.intern(),
            hits.score(i)));
        test.add(fullpath);
      }
    }

    searcher.close();

    return result;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public PageManager getPageManager() {
    return pageManager;
  }

  /**
   * DOCUMENT ME!
   *
   * @param manager
   */
  public void setPageManager(PageManager manager) {
    pageManager = manager;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public String getSenHome() {
    return senHome;
  }

  /**
   * DOCUMENT ME!
   *
   * @param string
   */
  public void setSenHome(String string) {
    senHome = string;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public ApplicationContext getApplicationContext() {
    return context;
  }

  /**
   * DOCUMENT ME!
   *
   * @param context
   */
  public void setApplicationContext(ApplicationContext context) {
    this.context = context;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public JaJaWikiConfig getConfig() {
    return config;
  }

  /**
   * DOCUMENT ME!
   *
   * @param config
   */
  public void setConfig(JaJaWikiConfig config) {
    this.config = config;
  }
  /**
   * \͊̎擾
   * @return AiCU
   */
	protected Analyzer getAnalyzer() {
		return new JapaneseAnalyzer();
	}

}
