/*
 * $Id: AbstractPageManager.java,v 1.1 2004/06/23 06:36:13 mashu Exp $
 */
package cx.ath.kgslab.wiki;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

import java.net.URLEncoder;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

import cx.ath.kgslab.wiki.exception.AttachFileOutputException;
import cx.ath.kgslab.wiki.exception.AttachFileOverwriteException;
import cx.ath.kgslab.wiki.exception.AttachFileTooLargeException;
import cx.ath.kgslab.wiki.exception.PageAlreadyExistsException;
import cx.ath.kgslab.wiki.exception.PageNotFoundException;
import cx.ath.kgslab.wiki.exception.PageReadException;
import cx.ath.kgslab.wiki.exception.PageWriteException;
import cx.ath.kgslab.wiki.exception.PathNotFoundException;
import cx.ath.kgslab.wiki.pages.Page;
import cx.ath.kgslab.wiki.struts.form.AttachFile;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

import org.apache.struts.upload.FormFile;

import org.springframework.beans.factory.InitializingBean;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;


/**
 * y[WǗNX.
 * <br>
 * y[W̓ǂݏALbVAbN𓝈IɈNX́A X[p[NXB
 * <br>
 * bNALbV̓ftHgA ̃NXɎB
 * y[W̓ǂݏ́At@CADBȂǕ̑Ώۂz肵Ă̂ŁA
 * ł͎TuNXŎB
 *
 * @author VM
 * @version 3.0 $Revision: 1.1 $
 *
 * @since JaJaWiki 2.0
 */
public abstract class AbstractPageManager
      implements ApplicationContextAware, InitializingBean,
        PageManager {
  /** DOCUMENT ME! */
  private List pageChangeListeners = new ArrayList(5);

  /**
   * AvP[VReLXg
   */
  protected ApplicationContext context = null;

  /**
   * JaJaWikiݒ
   */
  protected JaJaWikiConfig config = null;

  /**
   * LbV}l[W
   */
  private CacheManager cacheManager = null;

  /**
   * AvP[VReLXg̐ݒ
   *
   * @param context AvP[VReLXg
   */
  public void setApplicationContext(ApplicationContext context) {
    this.context = context;
  }

  /**
   * 
   * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
   */
  public final void afterPropertiesSet() throws Exception {
    try {
      Cache cache =
        new Cache("Pages", config.getCacheSize(), false, false, 0, 0);

      cacheManager.addCache(cache);
    } catch (CacheException e) {
      throw new Error(e);
    }

    init();
  }

  /**
   * 
   *
   * @throws Error
   */
  public void init() throws Exception {
  }

  /**
   * y[W
   *
   * @param name Ώۃy[W
   *
   * @return y[W
   */
  protected abstract Page readPage(String name)
        throws PageReadException;

  /**
   * y[Wo
   *
   * @param page y[W
   */
  protected abstract void writePage(Page page)
        throws PageWriteException;

  /**
   * y[W̗LmF
   *
   * @param path y[WpX
   * @param name Ώۃy[W
   *
   * @return true:Yy[W false:Yy[WȂ
   *
   * @throws PageReadException
   */
  public final boolean existsPage(String path, String name)
        throws PageReadException {
    return existsPage(concatPath(path, name));
  }

  /**
   * Wikiy[WobNAbvB
   *
   * @see cx.ath.kgslab.wiki.PageManager#backupPages()
   */
  public final void backupPages()
        throws PageReadException, PageWriteException {
    File path = config.getBackupPath();

    backupPages(path);
  }

  /**
   * y[W폜
   *
   * @param name Ώۃy[W
   */
  protected abstract void removePage(String name)
        throws PageWriteException;

  /**
   * y[W擾
   *
   * @param name y[W
   *
   * @return y[WɊ蓖Ăꂽy[W
   *
   * @throws PageReadException
   *
   * @see java.util.Map#get(java.lang.Object)
   */
  public final synchronized Page getPage(String name)
        throws PageReadException {
    Cache cache = cacheManager.getCache("Pages");
    Page result = null;

    try {
      Element element = cache.get(name);

      if (element != null) {
        result = (Page)element.getValue();
      }
    } catch (CacheException e) {
      throw new PageReadException("LbV̗O", e);
    }

    if (result == null) {
      result = readPage(name);
    }

    return result;
  }

  /**
   * y[Wǉ/XV
   *
   * @param page y[W
   *
   * @throws PageWriteException
   *
   * @see java.util.Map#put(java.lang.Object, java.lang.Object)
   */
  public final synchronized void putPage(Page page)
        throws PageWriteException {
    putPage(page, true);
  }

  /**
   * y[Wǉ/XV
   *
   * @param page y[W
   * @param modified y[WeɍXVstO
   *
   * @throws PageWriteException
   *
   * @see java.util.Map#put(java.lang.Object, java.lang.Object)
   */
  public final synchronized void putPage(Page page, boolean modified)
        throws PageWriteException {
    if (modified) {
      page.setLastModified(new Date());
      firePageChanged();
    }

    Cache cache = cacheManager.getCache("Pages");

    cache.put(new Element(getFullPath(page), page));

    writePage(page);
  }

  /**
   * y[W폜
   *
   * @param name y[W
   *
   * @throws PageWriteException
   */
  public final synchronized void deletePage(String name)
        throws PageWriteException {
    try {
      deletePage(getPage(name));
    } catch (PageReadException e) {
      throw new PageWriteException(e);
    }
  }

  /**
   * y[W폜
   *
   * @param page y[W
   *
   * @throws PageWriteException
   */
  public final synchronized void deletePage(Page page)
        throws PageWriteException {
    try {
      String path = page.getPath();

      if ((path != null) && (path.length() > 0)) {
        if (existsPage(path)) {
          Page parent = getPage(path);

          parent.removeChild(page.getTitle());

          putPage(parent, false);
        }
      }

      deletePath(page);
      firePageChanged();
    } catch (PageReadException e) {
      throw new PageWriteException(e);
    } catch (AttachFileOutputException e) {
      throw new PageWriteException(e);
    }
  }

  /**
   * y[Wz̃y[Wƍ폜B
   *
   * @param page Ώۂ̃y[W
   *
   * @throws PageWriteException
   * @throws PageReadException
   * @throws AttachFileOutputException
   */
  private void deletePath(Page page)
        throws PageWriteException, PageReadException, 
          AttachFileOutputException {
    String name = getFullPath(page);

    //System.out.println("deletePath : " + name);
    Set set = page.getChild();

    if (set != null) {
      Iterator ite = set.iterator();

      while (ite.hasNext()) {
        String childName = (String)ite.next();

        //System.out.println("deletePath : childName : " + childName);
        Page child = getPage(concatPath(name, childName));

        if (child != null) {
          deletePath(child);
        }
      }
    }

    Cache cache = cacheManager.getCache("Pages");

    cache.remove(name);
    removePage(name);
    removeFile(name);
  }

  /**
   * y[WύX
   *
   * @param srcName ύXOy[W
   * @param dstName ύXy[W
   *
   * @throws PageReadException
   * @throws PageWriteException
   * @throws PageNotFoundException
   * @throws PageAlreadyExistsException
   * @throws PathNotFoundException
   */
  public final synchronized void renamePage(String srcName,
    String dstName)
        throws PageReadException, PageWriteException, 
          PageNotFoundException, PageAlreadyExistsException, 
          PathNotFoundException {
    Page src = null;

    if (existsPage(srcName)) {
      src = getPage(srcName);
    } else {
      throw new PageNotFoundException();
    }

    if (existsPage(dstName)) {
      throw new PageAlreadyExistsException();
    }

    Page dst = new Page();

    AbstractPageManager.parsePagePath(dstName, dst);

    {
      String srcPath = src.getPath();

      if ((srcPath != null) && (srcPath.length() > 0)
          && !".".equals(srcPath)) {
        if (existsPage(srcPath)) {
          Page parent = getPage(srcPath);

          parent.removeChild(src.getTitle());
          putPage(parent, false);
        }
      }

      String dstPath = dst.getPath();

      if ((dstPath != null) && (dstPath.length() > 0)
          && !".".equals(dstPath)) {
        if (existsPage(dstPath)) {
          Page parent = getPage(dstPath);

          parent.addChild(src.getTitle());
          putPage(parent, false);
        } else {
          throw new PathNotFoundException();
        }
      }

      changePath(src, srcName, dstPath, dst.getTitle());
    }

    firePageChanged();
  }

  /**
   * y[WpXƃy[WύXB
   *
   * @param src y[W
   * @param srcPath y[W}l[W
   * @param dstPath y[WpX
   * @param dstTitle y[W
   *
   * @throws PageReadException
   * @throws PageWriteException
   */
  private void changePath(Page src, String srcPath, String dstPath,
    String dstTitle) throws PageReadException, PageWriteException {
    Iterator ite = src.getChild().iterator();

    while (ite.hasNext()) {
      String childPath =
        AbstractPageManager.concatPath(srcPath, (String)ite.next());

      //      System.out.println("childPath : " + childPath);
      Page child = getPage(childPath);

      changePath(child, childPath,
        AbstractPageManager.concatPath(dstPath, src.getTitle()),
        child.getTitle());
    }

    deletePage(src);
    src.setPath(dstPath);
    src.setTitle(dstTitle);
    putPage(src);
  }

  /**
   * y[WɃt@CYt
   *
   * @param page y[W
   * @param fileName t@C
   * @param uploadFile t@C̓e
   * @param overwrite I[oChtO
   *
   * @throws AttachFileOutputException
   */
  public final synchronized void attachFile(String page,
    String fileName, FormFile uploadFile, boolean overwrite)
        throws AttachFileOutputException {
    try {
      File dir = new File(config.getUploadPath(), encodePath(page));

      if (!dir.exists()) {
        dir.mkdirs();
      }

      if ((fileName == null) || (fileName.length() <= 0)) {
        fileName = uploadFile.getFileName();
      }

      File file = new File(dir, fileName);

      if (!overwrite && file.exists()) {
        // ㏑ȂƂႤ́H
        throw new AttachFileOverwriteException();
      }

      if (uploadFile.getFileSize() < 10485760) {
        InputStream stream = uploadFile.getInputStream();
        int bytesRead = 0;
        byte[] buffer = new byte[8192];
        FileOutputStream fos = new FileOutputStream(file);
        try {
					while ((bytesRead = stream.read(buffer, 0, 8192)) != -1) {
						fos.write(buffer, 0, bytesRead);
					}
        } finally {
					fos.close();
					stream.close();
        }


      } else {
        // t@CłI
        throw new AttachFileTooLargeException();
      }
    } catch (UnsupportedEncodingException e) {
      throw new AttachFileOutputException(e);
    } catch (FileNotFoundException e) {
      throw new AttachFileOutputException(e);
    } catch (IOException e) {
      throw new AttachFileOutputException(e);
    }
  }

  /**
   * y[WɓYtꂽt@C폜
   *
   * @param page y[W
   * @param files t@C
   *
   * @throws AttachFileOutputException
   */
  public void removeFile(String page, String[] files)
        throws AttachFileOutputException {
    if (files != null) {
      try {
        File dir = new File(config.getUploadPath(), encodePath(page));

        for (int idx = 0; idx < files.length; idx++) {
          File file = new File(dir, files[idx]);

          file.delete();
        }
      } catch (UnsupportedEncodingException e) {
        throw new AttachFileOutputException(e);
      }
    }
  }

  /**
   * y[WɓYtꂽt@C̏擾
   *
   * @param page y[W
   *
   * @return Ytt@C̔z
   *
   * @throws AttachFileOutputException
   */
  public AttachFile[] getAttachFiles(String page)
        throws AttachFileOutputException {
    try {
      File dir = new File(config.getUploadPath(), encodePath(page));
      File[] files = dir.listFiles();
      AttachFile[] attachFiles = null;

      if ((files != null) && (files.length > 0)) {
        attachFiles = new AttachFile[files.length];

        for (int idx = 0; idx < files.length; idx++) {
          attachFiles[idx] = new AttachFile(files[idx]);
        }
      } else {
        attachFiles = new AttachFile[0];
      }

      return attachFiles;
    } catch (UnsupportedEncodingException e) {
      throw new AttachFileOutputException(e);
    }
  }

  /**
   * y[WɓYtꂽt@CSč폜
   *
   * @param page y[W
   *
   * @throws AttachFileOutputException
   */
  public void removeFile(String page)
        throws AttachFileOutputException {
    try {
      File dir = new File(config.getUploadPath(), encodePath(page));

      removeFile(page, dir.list());
    } catch (UnsupportedEncodingException e) {
      throw new AttachFileOutputException(e);
    }
  }

  /**
   * }X^[pX[hݒ肳Ă邩
   *
   * @return true:}X^[pX[hp
   */
  public final boolean useMasterPassword() {
    return (config.getMasterPassword() != null)
    && (config.getMasterPassword().length() > 0);
  }

  /**
   * w̃y[W̃pX[h`FbNB
   *
   * @param page y[W
   * @param password pX[h
   *
   * @return true:pX[hOK
   *
   * @throws PageReadException
   */
  public final boolean checkPassword(String page, String password)
        throws PageReadException {
    return checkPassword(getPage(page), password);
  }

  /**
   * w̃y[W̃pX[h`FbNB
   *
   * @param page y[W
   * @param password pX[h
   *
   * @return true:pX[hOK
   */
  public final boolean checkPassword(Page page, String password) {
    if (useMasterPassword()
        && config.getMasterPassword().equals(password)) {
      return true;
    }

    String pagePassword = (String)page.getPassword();

    if ((pagePassword != null) && (pagePassword.length() > 0)
        && pagePassword.equals(password)) {
      return true;
    }

    return false;
  }

  /**
   * w̃y[W̃pX[h`FbNB
   *
   * @param page y[W
   * @param password pX[h
   *
   * @return true:pX[hOK
   */
  public final boolean checkLockPassword(Page page, String password) {
    if (page.getLocked()) {
      // y[WbNĂꍇ
      if (!checkPassword(page, password)) {
        return false;
      }
    }

    return true;
  }

  /**
   * y[WURLEncodeA%菜ƂŁA
   * ASCIĨ͈͓t@C𐶐B
   *
   * @param text GR[hΏە
   * @param buf i[StringBuffer
   *
   * @return i[StringBuffer
   *
   * @throws UnsupportedEncodingException
   */
  public StringBuffer encode(String text, StringBuffer buf)
        throws UnsupportedEncodingException {
    if (text != null) {
      text = text.trim();
      String converted =
        URLEncoder.encode(text, config.getPageEncode());
      StringTokenizer tokens = new StringTokenizer(converted, "%");

      while (tokens.hasMoreTokens()) {
        buf.append(tokens.nextToken());
      }
    }

    return buf;
  }

  /**
   * PathURLEncodeA%菜ƂŁA
   * ASCIĨ͈͓t@C𐶐B
   *
   * @param path GR[hΏە
   * @param buf i[StringBuffer
   *
   * @return i[StringBuffer
   *
   * @throws UnsupportedEncodingException
   */
  public StringBuffer encodePath(String path, StringBuffer buf)
        throws UnsupportedEncodingException {
    if (path != null) {
      path = path.trim();
      StringTokenizer tokens = new StringTokenizer(path, "/");

      while (tokens.hasMoreTokens()) {
        encode(tokens.nextToken(), buf);

        if (tokens.hasMoreTokens()) {
          buf.append('/');
        }
      }
    }

    return buf;
  }

  /**
   * y[WURLEncodeA%菜ƂŁA
   * ASCIĨ͈͓t@C𐶐B
   *
   * @param text GR[hΏە
   *
   * @return ʕ
   *
   * @throws UnsupportedEncodingException
   */
  public String encode(String text)
        throws UnsupportedEncodingException {
    StringBuffer buf = new StringBuffer();

    return encode(text, buf).toString();
  }

  /**
   * PathURLEncodeA%菜ƂŁA
   * ASCIĨ͈͓t@C𐶐B
   *
   * @param path GR[hΏە
   *
   * @return ʕ
   *
   * @throws UnsupportedEncodingException
   */
  public String encodePath(String path)
        throws UnsupportedEncodingException {
    StringBuffer buf = new StringBuffer();

    return encodePath(path, buf).toString();
  }

  /**
   * PathURLEncodeA%菜ƂŁA
   * ASCIĨ͈͓t@C𐶐B
   *
   * @param path y[WpX
   * @param page y[W
   *
   * @return ʕ
   *
   * @throws UnsupportedEncodingException
   */
  public String encodePath(String path, String page)
        throws UnsupportedEncodingException {
    StringBuffer buf = new StringBuffer();

    if ((path != null) && (path.length() > 0)) {
      encodePath(path, buf);
      buf.append('/');
    }

    encodePath(page, buf);

    return buf.toString();
  }

  /**
   * pX̌
   * <br> y[WpXƃy[W
   *
   * @param path y[WpX
   * @param name y[W
   *
   * @return ʕ
   */
  public static String concatPath(String path, String name) {
    //System.out.println("concatPath ( " + path + ", " + name + " )");
    String page = name;

    if (path != null) {
      if (path.startsWith("/")) {
        path = path.substring(1);
      }

      path = path.trim();

      if (path.length() > 0) {
        page = path + (path.endsWith("/") ? "" : "/") + name.trim();
      }
    }

    //    System.out.println("concatPath : " + page);
    return page;
  }

  /**
   * y[W̃tpX̎擾
   * <br> y[WpXƃy[WAtpX𐶐B
   *
   * @param page y[W
   *
   * @return y[WpX
   */
  protected String getFullPath(Page page) {
    if (page != null) {
      String name = page.getTitle();
      String path = page.getPath();

      return concatPath(path, name);
    } else {
      return null;
    }
  }

  /**
   * y[WpX̉ߏ
   * <br> y[W̃tpXAy[WAy[WpX𒊏oB
   *
   * @param page y[WpX
   * @param info y[W
   */
  public static void parsePagePath(String page, Page info) {
    int idx = page.lastIndexOf('/');

    if (idx > 0) {
      String path = page.substring(0, idx);
      String title = page.substring(idx + 1);

      info.setPath(path);
      info.setTitle(title);
    } else {
      info.setPath("");
      info.setTitle(page);
    }
  }

  /**
   * y[WpX̉ߏ
   * <br> y[WpX"..""."y[W̃pXɁAۂ̃pXɕϊB
   *
   * @param path y[WpX
   * @param thisPath y[WpX
   *
   * @return 
   */
  public static String parsePath(String path, String thisPath) {
    //        System.out.println("parsePath " + path + ":" + thisPath + ":" + thisPage);
    if ((path != null) && (path.length() > 0)) {
      if (path.startsWith("./")) {
        path = thisPath + path.substring(1);
      } else if (".".equals(path)) {
        path = thisPath;
      } else if (path.startsWith("../")) {
        while (path.startsWith("../")) {
          int idx = path.indexOf("/");

          path = path.substring(idx + 1);
          if ((thisPath != null) && (thisPath.length() > 0)) {
            idx = thisPath.lastIndexOf('/');
            if (idx >= 0) {
              thisPath = thisPath.substring(0, idx);
            } else {
              thisPath = "";
            }
          }
        }

        path = concatPath(thisPath, path);
      } else if ("..".equals(path)) {
        path = thisPath;
      }
    }

    return path;
  }

  /**
   * JaJaWikiݒ
   *
   * @return JaJaWikiݒ
   */
  public JaJaWikiConfig getConfig() {
    return config;
  }

  /**
   * JaJaWikiݒ
   *
   * @param config JaJaWikiݒ
   */
  public void setConfig(JaJaWikiConfig config) {
    this.config = config;
  }

  /**
   * LbV}l[W̎擾
   *
   * @return LbV}l[W
   */
  public CacheManager getCacheManager() {
    return cacheManager;
  }

  /**
   * LbV}l[W̐ݒ
   *
   * @param manager LbV}l[W
   */
  public void setCacheManager(CacheManager manager) {
    cacheManager = manager;
  }

  /* ( Javadoc)
   * @see cx.ath.kgslab.wiki.PageManager#addPageChangeListener(cx.ath.kgslab.wiki.PageChangeListener)
   */
  public void addPageChangeListener(PageChangeListener listener) {
    pageChangeListeners.add(listener);
  }

  /**
   * DOCUMENT ME!
   */
  protected void firePageChanged() {
    Iterator ite = pageChangeListeners.iterator();

    while (ite.hasNext()) {
      PageChangeListener listener = (PageChangeListener)ite.next();

      listener.modified();
    }
  }
}
