/*
 * $Id: ConvertHtml.java,v 1.1 2004/06/23 06:36:13 mashu Exp $
 */
package cx.ath.kgslab.wiki;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;

import java.net.URLEncoder;

import java.util.HashMap;
import java.util.Locale;

import cx.ath.kgslab.webutil.UserAgentUtil;
import cx.ath.kgslab.wiki.exception.PageReadException;
import cx.ath.kgslab.wiki.pages.Page;
import cx.ath.kgslab.wiki.parser.Parser;
import cx.ath.kgslab.wiki.parser.element.Body;
import cx.ath.kgslab.wiki.plugin.NestPlugin;
import cx.ath.kgslab.wiki.plugin.Plugin;
import cx.ath.kgslab.wiki.plugin.exception.PluginException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.apache.oro.text.perl.Perl5Util;
import org.apache.oro.text.regex.MatchResult;

import org.springframework.beans.BeansException;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;


/**
 * JaJaWikiHTMLҏWNX
 *
 * @author VM
 * @version 3.0 
 *
 * @since JaJaWiki 1.0
 */
public class ConvertHtml implements ApplicationContextAware {
  /** DOCUMENT ME! */
  Log log = LogFactory.getLog(this.getClass());

  /**
   * PȒu[
   */
  private static final String[] TRANSFORM_RULE =
    new String[] {
      "s#'''([^']*)'''#<em>$1</em>#g", // Α
      "s#''([^']*)''#<b>$1</b>#g", // 
      "s#%%%([^%]*)%%%#<ins>$1</ins>#g", // 
      "s#%%([^%]*)%%#<del>$1</del>#g", // 
      "s#&br;#<br />#g", // s
      "s#&brc;#<br style=\"clear:both\" />#g", // s
      "s#&hr;#<hr />#g", // ؂
      "s#&hrc;#<hr style=\"clear:both\" />#g", // ؂
      "s/&yen;/\\\\/g", // ~}[N(obNXbV)̃GXP[vB
    };

  /** DOCUMENT ME! */
  private static String RULE_SEP = "#";

  /**
   * NEߕϊo[
   */
  private static final String LINK_RULE =
    "#(&(\\w+)(?:\\((.*)\\))?(?:{(.*)})?;)" // vOC
    + "|(?:\\(\\((.*)\\)\\))" // 
    + "|(?:\\[\\[(?:([^\\]]+)>)?((?:https?|ftp|news)://[!~*'\\(\\);\\/?:\\@&=+\\$,%#\\w.-]+)\\]\\])" // URLN(uPbg)
    + "|((?:https?|ftp|news)://[!~*'\\(\\);\\/?:\\@&=+\\$,%#\\w.-]+)" // URLN(uPbgȂ)
    + "|(?:\\[\\[(?:([^\\]]+)>)?(?:mailto:)?([\\w.-]+@[\\w-]+\\.[\\w.-]+)\\]\\])" // mailto N(uPbg)
    + "|(?:mailto:)?([\\w.-]+@[\\w-]+\\.[\\w.-]+)" // mailto N(uPbgȂ)
    + "|(?:\\[\\[(?:([^\\]]+)>)?([^\\]]+)\\]\\])" // uPbgl[ N
    + "|((?:[A-Z][a-z]+){2,})" // Wikil[ N
    ;

  /**
   * Aliasϊp Nϊo[
   */
  private static final String LINK_RULE2 =
    "#(&(\\w+)(?:\\((\\w*)\\))?(?:{(.*)})?;)" // vOC
    + "|((?:https?|ftp|news)://[!~*'\\(\\);\\/?:\\@&=+\\$,%#\\w.-]+)" // URLN(uPbgȂ)
    + "|(?:mailto:)?([\\w.-]+@[\\w-]+\\.[\\w.-]+)" // mailto N(uPbgȂ)
    + "|((?:[A-Z][a-z]+){2,})" // Wikil[ N
    + "#";

  /**
   * ReLXgpX
   */
  private String contextPath = "";

  /**
   * y[W
   */
  private String page = "";

  /**
   * InterWikiName`ێnbV}bv
   */
  private InterWikiNames interWikiNames;

  /**
   * InterWikiName`ێnbV}bv
   */
  private Keywords keywords;

  /**
   * Bodyvf
   */
  private Body body = null;

  /**
   * AvP[VReLXg
   */
  private ApplicationContext context = null;

  /**
   * JaJaWikiݒ
   */
  private JaJaWikiConfig config = null;

  /**
   * y[W}l[W
   */
  private PageManager pageManager = null;

  /**
   * P[
   */
  private Locale locale = Locale.getDefault();

  /** DOCUMENT ME! */
  private int userAgent = UserAgentUtil.UA_Mozilla;

  /** DOCUMENT ME! */
  private SessionUtil sessionUtil = null;

  /**
   * RXgN^
   */
  public ConvertHtml() {
  }

  /**
   * WikiHTML֕ϊB
   *
   * @param page Wiki
   *
   * @return WikiHTMLւ̕ϊ
   *
   * @throws IOException
   */
  public String convert(Page page) throws IOException {
    String result =
      convert(AbstractPageManager.concatPath(page.getPath(),
          page.getTitle()), page.getContent());

    page.setConvertedPage(result);

    return result;
  }

  /**
   * WikiHTML֕ϊB
   *
   * @param page Wiki
   * @param content Wiki
   *
   * @return WikiHTMLւ̕ϊ
   *
   * @throws IOException
   */
  public String convert(String page, String content)
        throws IOException {
    this.setPage(page);

    return convert(content);
  }

  /**
   * WikiHTML֕ϊB
   *
   * @param content Wiki
   *
   * @return WikiHTMLւ̕ϊ
   *
   * @throws IOException
   */
  public String convert(String content) throws IOException {
    LineNumberReader reader =
      new LineNumberReader(new StringReader(content));

    Parser parser = new Parser();

    body = parser.parse(reader);

    String result = convertInline(body.toString());

    return result;
  }

  /**
   * CCvfHTMLɕϊB
   *
   * @param src ubNvfϊς݂Wiki
   *
   * @return WikiHTMLւ̕ϊ
   */
  public String convertInline(String src)
        throws UnsupportedEncodingException {
    String temp = replace(src);
    String result = transform(temp);

    return result;
  }

  /**
   * K\ɂA\/HTMLϊ
   *
   * @param src Ώە
   *
   * @return 
   */
  public String transform(String src)
        throws UnsupportedEncodingException {
    StringBuffer result = new StringBuffer();
    StringBuffer footer = new StringBuffer();
    int footid = 1;

    Perl5Util util = new Perl5Util();
    String temp = src;

    while (util.match("m#<pre[^>]*>#s", temp)) {
      String temp1 = util.preMatch();
      String temp2 = util.group(0);

      temp = util.postMatch();

      if (util.match("m#</pre>#s", temp)) {
        temp2 = temp2 + util.preMatch() + util.group(0);
        temp = util.postMatch();
      }

      // NEߏ
      footid = makeLink(result, footer, footid, util, temp1);
      result.append(temp2);
    }

    footid = makeLink(result, footer, footid, util, temp);

    // tb^̒ǉ
    String footerText = footer.toString();

    if ((footerText != null) && (footerText.length() > 0)) {
      result.append("\n<hr class=\"note_hr\"/>\n<div id=\"note\">")
            .append(footerText).append("</div>");
    }

    return result.toString();
  }

  /**
   * NE ϊ
   *
   * @param result ϊʂ߂XgOobt@
   * @param footer ߕ߂XgOobt@
   * @param footid ߂̔ԍ
   * @param perl Perl5Util̃CX^X
   * @param src Ώە
   *
   * @return ߂̔ԍ
   */
  private int makeLink(StringBuffer result, StringBuffer footer,
    int footid, Perl5Util perl, String src)
        throws UnsupportedEncodingException {
    // NEߏ
    String rule = makeRule();

    while (perl.match(rule, src)) {
      src = perl.postMatch();

      String temp = "";

      // 
      String note = perl.group(5);

      if ((note != null) && (note.length() > 0)) {
        temp = processNote(note, footer, footid);
        footid++;
      } else {
        temp = transform(perl);
      }

      result.append(perl.preMatch()).append(temp);
    }

    result.append(src);

    return footid;
  }

  /**
   * @return
   */
  private String makeRule() {
    if (keywords != null) {
      keywords.parseKeywords();
      if ((keywords.getRule() != null)
          && (keywords.getRule().length() > 0)) {
        return LINK_RULE + "|(" + keywords.getRule() + ")" + RULE_SEP;
      }
    }

    return LINK_RULE + RULE_SEP;
  }

  /**
   * K\ɂ\oʂAHTML\ɕϊ鏈
   *
   * @param match K\ o
   *
   * @return 
   */
  private String transform(MatchResult match)
        throws UnsupportedEncodingException {
    String result = "";

    // vOC
    String name = match.group(2);

    // url N
    String url = match.group(7);
    String url2 = match.group(8);

    // mail N
    String mailto = match.group(10);
    String mailto2 = match.group(11);

    // BlacketName N
    String bname = match.group(13);

    // WikiName N
    String wname = match.group(14);

    // Keyword N
    String keyword = match.group(15);

    if ((name != null) && (name.length() > 0)) {
      String params = match.group(3);
      String text = match.group(4);

      result = processPlugin(name, params, text, match.group(1));
    } else if ((url != null) && (url.length() > 0)) {
      String alias = match.group(6);

      result = processLinkURL(alias, url);
    } else if ((url2 != null) && (url2.length() > 0)) {
      result = processLinkURL(url2);
    } else if ((mailto != null) && (mailto.length() > 0)) {
      String alias = match.group(9);

      result = processLinkMail(alias, mailto);
    } else if ((mailto2 != null) && (mailto2.length() > 0)) {
      result = processLinkMail(null, mailto2);
    } else if ((bname != null) && (bname.length() > 0)) {
      String alias = match.group(12);

      result = processLinkBraketName(alias, bname);
    } else if ((wname != null) && (wname.length() > 0)) {
      result = processLinkBraketName(null, wname);
    } else if ((keyword != null) && (keyword.length() > 0)) {
      if (keywords != null) {
        HashMap kwmap = keywords.getKeywords();

        if (kwmap.containsKey(keyword)) {
          Keyword kw = (Keyword)kwmap.get(keyword);

          if (kw.isUri()) {
            result = processLinkURL(keyword, kw.getLink());
          } else {
            result = processLinkBraketName(keyword, kw.getLink());
          }
        } else {
          result = keyword;
        }
      } else {
        result = keyword;
      }
    }

    return result;
  }

  /**
   * K\ɂA\/HTMLϊ(GCAXp)
   *
   * @param src Ώە
   *
   * @return 
   */
  private String transformAlias(String src) {
    StringBuffer result = new StringBuffer();
    StringBuffer footer = new StringBuffer();
    int footid = 1;

    Perl5Util util = new Perl5Util();
    String temp = src;

    while (util.match("m#<pre[^>]*>#s", temp)) {
      String temp1 = util.preMatch();
      String temp2 = util.group(0);

      temp = util.postMatch();

      if (util.match("m#</pre>#s", temp)) {
        temp2 = temp2 + util.preMatch() + util.group(0);
        temp = util.postMatch();
      }

      // NEߏ
      footid = makeAlias(result, footer, footid, util, temp1);
      result.append(temp2);
    }

    footid = makeAlias(result, footer, footid, util, temp);

    // tb^̒ǉ
    String footerText = footer.toString();

    if ((footerText != null) && (footerText.length() > 0)) {
      result.append("\n<hr class=\"note_hr\"/>\n<div id=\"note\">")
            .append(footerText).append("</div>");
    }

    return result.toString();
  }

  /**
   * NE ϊ(GCAXp)
   *
   * @param result ϊʂ߂XgOobt@
   * @param footer ߕ߂XgOobt@
   * @param footid ߂̔ԍ
   * @param perl Perl5Util̃CX^X
   * @param src Ώە
   *
   * @return ߂̔ԍ
   */
  private int makeAlias(StringBuffer result, StringBuffer footer,
    int footid, Perl5Util perl, String src) {
    // NEߏ
    while (perl.match(LINK_RULE2, src)) {
      src = perl.postMatch();

      String temp = "";

      temp = transformAlias(perl);

      result.append(perl.preMatch()).append(temp);
    }

    result.append(src);

    return footid;
  }

  /**
   * K\ɂ\oʂAHTML\ɕϊ鏈(GCAXp)
   *
   * @param match K\ o
   *
   * @return 
   */
  private String transformAlias(MatchResult match) {
    String result = "";

    // vOC
    String name = match.group(2);

    // url N
    String url = match.group(5);

    // mail N
    String mailto = match.group(6);

    // WikiName N
    String wname = match.group(7);

    if ((name != null) && (name.length() > 0)) {
      String params = match.group(3);
      String text = match.group(4);

      result = processPlugin(name, params, text, match.group(1));
    } else if ((url != null) && (url.length() > 0)) {
      if (isImage(url)) {
        result = processLinkURL(url);
      } else {
        result = url;
      }
    } else if ((mailto != null) && (mailto.length() > 0)) {
      result = mailto;
    } else if ((wname != null) && (wname.length() > 0)) {
      result = wname;
    }

    return result;
  }

  /**
   * PȒuɂϊ
   *
   * @param src ϊ
   *
   * @return 
   */
  private String replace(String src) {
    Perl5Util util = new Perl5Util();
    StringBuffer result = new StringBuffer();
    String temp = src;

    while (util.match("m#<pre[^>]*>#s", temp)) {
      String temp1 = util.preMatch();
      String temp2 = util.group(0);

      temp = util.postMatch();

      if (util.match("m#</pre>#s", temp)) {
        temp2 = temp2 + util.preMatch() + util.group(0);
        temp = util.postMatch();
      }

      for (int i = 0; i < TRANSFORM_RULE.length; i++) {
        temp1 = util.substitute(TRANSFORM_RULE[i], temp1);
      }

      result.append(temp1);
      result.append(temp2);
    }

    for (int i = 0; i < TRANSFORM_RULE.length; i++) {
      temp = util.substitute(TRANSFORM_RULE[i], temp);
    }

    result.append(temp);

    return result.toString();
  }

  /**
   * vOC
   *
   * @param name vOC
   * @param params vOCɓn
   * @param text vOCΏۂƂ镶
   * @param pluginString Wikiy[WɋLqĂAvOC
   *
   * @return ʕ
   */
  public String processPlugin(String name, String params,
    String text, String pluginString) {
    String result = text;
    Plugin plugin = null;
    String[] ignore = new String[] {
        "lt",
        "gt",
        "amp",
      };

    for (int i = 0; i < ignore.length; i++) {
      if (ignore[i].equalsIgnoreCase(name)) {
        return pluginString;
      }
    }

    try {
      try {
        plugin = (Plugin)context.getBean(Plugin.PREFIX + name);
      } catch (BeansException e) {
        throw new PluginException(context.getMessage(
            "plugin.cantuse", new Object[] {
              name
            }, locale), e);
      }

      if (plugin != null) {
        plugin.setPage(this.page);

        plugin.setApplicationContext(this.context);
        plugin.setContextPath(this.contextPath);
        plugin.setParams(params);
        plugin.setText(text);
        plugin.setUserAgent(this.userAgent);
        plugin.setSessionUtil(this.sessionUtil);

        if (plugin instanceof NestPlugin) {
          NestPlugin plugin2 = (NestPlugin)plugin;

          plugin2.setConverter(this);
        }

        result = plugin.toHTML();
      } else {
        result = pluginString;
      }
    } catch (PluginException ex) {
      if (log.isDebugEnabled()) {
        log.debug(ex.getMessage(), ex);
      }

      result =
        "<span class=\"errormsg\">" + pluginString + " error:"
        + ex.getMessage() + "</span>";
    } catch (Exception ex) {
      if (log.isErrorEnabled()) {
        log.error(context.getMessage(
            "exception.plugin.unknownexception", null, locale), ex);
      }

      result =
        "<span class=\"errormsg\">" + pluginString + " error:"
        + context.getMessage("exception.plugin.unknownexception",
          null, locale) + "(" + ex.getMessage() + ")</span>";
    }

    return result;
  }

  /**
   * URLN(uPbgl[̏ꍇ)
   *
   * @param alias NΏە
   * @param link NURL
   *
   * @return ϕ
   */
  public String processLinkURL(String alias, String link)
        throws UnsupportedEncodingException {
    //    System.out.println("processLinkURL(<<" + alias + ">>, <<" + link + ">>)");
    StringBuffer result = new StringBuffer();

    if ((alias == null) || (alias.length() <= 0)) {
      alias = link;
    } else {
      alias = transformAlias(alias);
    }

    //		result.append("<a href=\"").append(URLEncoder.encode(link, config.getUrlEncode())).append("\">")
    //					.append(alias).append("</a>");
    result.append("<a href=\"").append(encodeURL(link)).append("\">")
          .append(alias).append("</a>");

    return result.toString();
  }

  /**
   * URLN(URLLꍇ)
   *
   * @param link NURL
   *
   * @return ϕ
   */
  public String processLinkURL(String link) {
    //    System.out.println("processLinkURL(<<" + link + ">>)");
    StringBuffer result = new StringBuffer();

    if (isImage(link)) {
      result.append("<img src=\"").append(encodeURL(link)).append("\" alt=\"Image\" />");
    } else {
      result.append("<a href=\"").append(encodeURL(link)).append("\">")
            .append(link).append("</a>");
    }

    return result.toString();
  }

  /**
   * N񂪉摜t@CwĂ̂ǂ`FbNB
   *
   * @param link N
   *
   * @return true:摜t@C false:ȊO
   */
  protected boolean isImage(String link) {
    //    System.out.println("isImage(<<" + link + ">>)");
    boolean result = false;
    String[] imgExt = config.getImgExt();

    for (int idx = 0; idx < imgExt.length; idx++) {
      if (link.endsWith(imgExt[idx])) {
        result = true;

        break;
      }
    }

    return result;
  }

  /**
   * mail N
   *
   * @param alias NΏە
   * @param mailto [AhX
   *
   * @return ϕ
   */
  public String processLinkMail(String alias, String mailto) {
    //    System.out.println("processLinkMail(<<" + alias + ">>, <<" + mailto + ">>)");
    StringBuffer result = new StringBuffer();

    if ((alias == null) || (alias.length() <= 0)) {
      alias = mailto;
    } else {
      alias = transformAlias(alias);
    }

    result.append("<a href=\"mailto:").append(mailto).append("\">")
          .append(alias).append("</a>");

    return result.toString();
  }

  /**
   * uPbgl[ N
   *
   * @param alias NΏە
   * @param bname uPbgl[
   *
   * @return ϕ
   */
  public String processLinkBraketName(String alias, String bname)
        throws UnsupportedEncodingException {
    {
      int idx;

      if ((idx = bname.indexOf(":")) > 0) {
        String iname = bname.substring(0, idx);

        bname = bname.substring(idx + 1, bname.length());

        return processLinkInterWikiName(alias, iname, bname);
      }
    }

    StringBuffer result = new StringBuffer();

    if ((alias == null) || (alias.length() <= 0)) {
      alias = bname;
    } else {
      alias = transformAlias(alias);
    }

    String name = bname;
    int idx = bname.lastIndexOf('/');

    String path = AbstractPageManager.parsePath(name, this.page);

    boolean exists = false;

    try {
      exists = pageManager.existsPage(path);
    } catch (PageReadException e) {
    }

    if (exists) {
      String url =
        encodeURL(contextPath + "/view.do?page="
          + URLEncoder.encode(path, config.getUrlEncode()));

      result.append("<a href=\"").append(url).append("\">")
            .append(alias).append("</a>");
    } else {
      String url =
        encodeURL(contextPath + "/edit.do?page="
          + URLEncoder.encode(path, config.getUrlEncode()));

      result.append(alias).append("<a href=\"").append(url).append("\">?</a>");
    }

    return result.toString();
  }

  /**
   * InterWikil[ N
   *
   * @param alias NΏە
   * @param iname InterWikil[
   * @param bname uPbgl[
   *
   * @return ϕ
   *
   * @throws RuntimeException
   */
  public String processLinkInterWikiName(String alias, String iname,
    String bname) {
    StringBuffer result = new StringBuffer();

    if ((alias == null) || (alias.length() <= 0)) {
      alias = iname + ":" + bname;
    } else {
      alias = transformAlias(alias);
    }

    HashMap map = interWikiNames.parseInterWikiName();

    if (map.containsKey(iname)) {
      InterWikiName iwname = (InterWikiName)map.get(iname);

      try {
        bname = URLEncoder.encode(bname, iwname.getEnc());
        String url = encodeURL(iwname.getUrl() + bname);

        result.append("<a href=\"").append(url).append("\">")
              .append(alias).append("</a>");

        return result.toString();
      } catch (UnsupportedEncodingException uex) {
        //        throw new RuntimeException("URLGR[fBO[" + iwname.getEnc()
        //          + "]gpł܂B", uex);
      }
    }

    String url =
      encodeURL(contextPath + "/edit.do?page="
        + config.getInterWikiPageName());

    result.append(alias).append("<a href=\"").append(url).append("\">!</a>");

    return result.toString();
  }

  /**
   * ߏ
   *
   * @param note ߑΏە
   * @param footer tb^o͐
   * @param id ߘA
   *
   * @return
   */
  public String processNote(String note, StringBuffer footer, int id) {
    StringBuffer result = new StringBuffer();

    String url = encodeURL("#notetext_" + id);

    result.append("<a id=\"notefoot_").append(id).append("\" href=\"")
          .append(url).append("\" class=\"note_super\">*").append(id)
          .append("</a>");

    url = encodeURL("#notefoot_" + id);
    footer.append("<a id=\"notetext_").append(id).append("\" href=\"")
          .append(url).append("\" class=\"note_super\">*").append(id)
          .append("</a><span class=\"small\">").append(note).append("</span><br />\n");

    return result.toString();
  }

  /**
   * y[W擾
   *
   * @return page y[W
   */
  public String getPage() {
    return page;
  }

  /**
   * y[Wݒ
   *
   * @param page y[W
   */
  public void setPage(String page) {
    this.page = page;
  }

  /**
   * T[ubgpX擾
   *
   * @return servletPath T[ubgpX
   */
  public String getServletPath() {
    return contextPath;
  }

  /**
   * {fBvf擾
   *
   * @return body {fBvf
   */
  public Body getBody() {
    return body;
  }

  //  /**
  //   * T[ubgReLXg̎擾
  //   *
  //   * @return T[ubgReLXg
  //   */
  //  public ServletContext getContext() {
  //    return context;
  //  }

  /**
   * DOCUMENT ME!
   *
   * @return DOCUMENT ME!
   */
  public ApplicationContext getApplicationContext() {
    return this.context;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public String getContextPath() {
    return contextPath;
  }

  /**
   * DOCUMENT ME!
   *
   * @param context
   */
  public void setApplicationContext(ApplicationContext context) {
    this.context = context;
  }

  /**
   * DOCUMENT ME!
   *
   * @param string
   */
  public void setContextPath(String string) {
    contextPath = string;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public JaJaWikiConfig getConfig() {
    return config;
  }

  /**
   * DOCUMENT ME!
   *
   * @param config
   */
  public void setConfig(JaJaWikiConfig config) {
    this.config = config;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public PageManager getPageManager() {
    return pageManager;
  }

  /**
   * DOCUMENT ME!
   *
   * @param manager
   */
  public void setPageManager(PageManager manager) {
    pageManager = manager;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public InterWikiNames getInterWikiNames() {
    return interWikiNames;
  }

  /**
   * DOCUMENT ME!
   *
   * @param names
   */
  public void setInterWikiNames(InterWikiNames names) {
    interWikiNames = names;
  }

  /**
   * DOCUMENT ME!
   *
   * @param locale
   */
  public void setLocale(Locale locale) {
    this.locale = locale;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public Locale getLocale() {
    return locale;
  }

  /**
   * @return
   */
  public int getUserAgent() {
    return userAgent;
  }

  /**
   * @param i
   */
  public void setUserAgent(int i) {
    userAgent = i;
  }

  /**
   * @return
   */
  public SessionUtil getSessionUtil() {
    return sessionUtil;
  }

  /**
   * @param util
   */
  public void setSessionUtil(SessionUtil util) {
    sessionUtil = util;
  }

  /**
   * @param url
   * @return
   */
  public String encodeRedirectURL(String url) {
    if (sessionUtil != null) {
      return sessionUtil.encodeRedirectURL(url);
    } else {
      return url;
    }
  }

  /**
   * @param url
   * @return
   */
  public String encodeURL(String url) {
    if (sessionUtil != null) {
      return sessionUtil.encodeURL(url);
    } else {
      return url;
    }
  }

  /**
   * @return
   */
  public Keywords getKeywords() {
    return keywords;
  }

  /**
   * @param keywords
   */
  public void setKeywords(Keywords keywords) {
    this.keywords = keywords;
  }
}
