/*
 * $Id: PageManager.java,v 1.1 2004/06/23 06:36:13 mashu Exp $
 */
package cx.ath.kgslab.wiki;

import java.io.File;
import java.io.UnsupportedEncodingException;

import java.util.List;

import cx.ath.kgslab.wiki.exception.AttachFileOutputException;
import cx.ath.kgslab.wiki.exception.PageAlreadyExistsException;
import cx.ath.kgslab.wiki.exception.PageNotFoundException;
import cx.ath.kgslab.wiki.exception.PageReadException;
import cx.ath.kgslab.wiki.exception.PageWriteException;
import cx.ath.kgslab.wiki.exception.PathNotFoundException;
import cx.ath.kgslab.wiki.pages.Page;
import cx.ath.kgslab.wiki.struts.form.AttachFile;

import org.apache.struts.upload.FormFile;


/**
 * y[WǗNX̃C^tF[X.
 *
 * @author VM
 * @version 1.0 
 *
 * @since JaJaWiki 4.0
 */
public interface PageManager {
  /**
   * y[W̗LmF
   *
   * @param name Ώۃy[W
   *
   * @return true:Yy[W false:Yy[WȂ
   */
  public boolean existsPage(String name) throws PageReadException;

  /**
   * y[W̗LmF
   *
   * @param path y[WpX
   * @param name Ώۃy[W
   *
   * @return true:Yy[W false:Yy[WȂ
   *
   * @throws PageReadException
   */
  public boolean existsPage(String path, String name)
        throws PageReadException;

  /**
   * y[WobNAbv
   */
  public void backupPages()
        throws PageReadException, PageWriteException;

  /**
   * y[WobNAbv
   * @param path obNAbvt@C̏o͐
   */
  public void backupPages(File path)
        throws PageReadException, PageWriteException;

  /**
   * ŋߍXVꂽy[W̃Xg擾B
   *
   * @param count 
   *
   * @return XVy[W̃Xg
   */
  public List getModifiedPageList(int count) throws PageReadException;

  /**
   * Sy[W̃Xg擾B
   *
   * @return Sy[W̃Xg
   */
  public List getPageList() throws PageReadException;

  /**
   * y[W擾
   *
   * @param name y[W
   *
   * @return y[WɊ蓖Ăꂽy[W
   *
   * @throws PageReadException
   *
   * @see java.util.Map#get(java.lang.Object)
   */
  public Page getPage(String name) throws PageReadException;

  /**
   * y[Wǉ/XV
   *
   * @param page y[W
   *
   * @throws PageWriteException
   *
   * @see java.util.Map#put(java.lang.Object, java.lang.Object)
   */
  public void putPage(Page page) throws PageWriteException;

  /**
   * y[Wǉ/XV
   *
   * @param page y[W
   * @param modified y[WeɍXVstO
   *
   * @throws PageWriteException
   *
   * @see java.util.Map#put(java.lang.Object, java.lang.Object)
   */
  public void putPage(Page page, boolean modified)
        throws PageWriteException;

  /**
   * y[W폜
   *
   * @param name y[W
   *
   * @throws PageWriteException
   */
  public void deletePage(String name) throws PageWriteException;

  /**
   * y[W폜
   *
   * @param page y[W
   *
   * @throws PageWriteException
   */
  public void deletePage(Page page) throws PageWriteException;

  /**
   * y[WύX
   *
   * @param srcName ύXOy[W
   * @param dstName ύXy[W
   *
   * @throws PageReadException
   * @throws PageWriteException
   * @throws PageNotFoundException
   * @throws PageAlreadyExistsException
   * @throws PathNotFoundException
   */
  public void renamePage(String srcName, String dstName)
        throws PageReadException, PageWriteException, 
          PageNotFoundException, PageAlreadyExistsException, 
          PathNotFoundException;

  /**
   * y[WɃt@CYt
   *
   * @param page y[W
   * @param fileName t@C
   * @param uploadFile t@C̓e
   * @param overwrite I[oChtO
   *
   * @throws AttachFileOutputException
   */
  public void attachFile(String page, String fileName,
    FormFile uploadFile, boolean overwrite)
        throws AttachFileOutputException;

  /**
   * y[WɓYtꂽt@C폜
   *
   * @param page y[W
   * @param files t@C
   *
   * @throws AttachFileOutputException
   */
  public void removeFile(String page, String[] files)
        throws AttachFileOutputException;

  /**
   * y[WɓYtꂽt@C̏擾
   *
   * @param page y[W
   *
   * @return Ytt@C̔z
   *
   * @throws AttachFileOutputException
   */
  public AttachFile[] getAttachFiles(String page)
        throws AttachFileOutputException;

  /**
   * y[WɓYtꂽt@CSč폜
   *
   * @param page y[W
   *
   * @throws AttachFileOutputException
   */
  public void removeFile(String page)
        throws AttachFileOutputException;

  /**
   * }X^[pX[hݒ肳Ă邩
   *
   * @return
   */
  public boolean useMasterPassword();

  /**
   * w̃y[W̃pX[h`FbNB
   *
   * @param page
   * @param password
   *
   * @return true:pX[hOK
   *
   * @throws PageReadException
   */
  public boolean checkPassword(String page, String password)
        throws PageReadException;

  /**
   * w̃y[W̃pX[h`FbNB
   *
   * @param page
   * @param password
   *
   * @return true:pX[hOK
   */
  public boolean checkPassword(Page page, String password);

  /**
   * w̃y[W̃pX[h`FbNB
   *
   * @param page
   * @param password
   *
   * @return true:pX[hOK
   */
  public boolean checkLockPassword(Page page, String password);

  /**
   * y[WURLEncodeA%菜ƂŁA ASCIĨ͈͓t@C𐶐B
   *
   * @param text GR[hΏە
   * @param buf i[StringBuffer
   *
   * @return i[StringBuffer
   *
   * @throws UnsupportedEncodingException
   */
  public StringBuffer encode(String text, StringBuffer buf)
        throws UnsupportedEncodingException;

  /**
   * PathURLEncodeA%菜ƂŁA ASCIĨ͈͓t@C𐶐B
   *
   * @param path GR[hΏە
   * @param buf i[StringBuffer
   *
   * @return i[StringBuffer
   *
   * @throws UnsupportedEncodingException
   */
  public StringBuffer encodePath(String path, StringBuffer buf)
        throws UnsupportedEncodingException;

  /**
   * y[WURLEncodeA%菜ƂŁA ASCIĨ͈͓t@C𐶐B
   *
   * @param text GR[hΏە
   *
   * @return ʕ
   *
   * @throws UnsupportedEncodingException
   */
  public String encode(String text)
        throws UnsupportedEncodingException;

  /**
   * PathURLEncodeA%菜ƂŁA ASCIĨ͈͓t@C𐶐B
   *
   * @param path GR[hΏە
   *
   * @return ʕ
   *
   * @throws UnsupportedEncodingException
   */
  public String encodePath(String path)
        throws UnsupportedEncodingException;

  /**
   * PathURLEncodeA%菜ƂŁA ASCIĨ͈͓t@C𐶐B
   *
   * @param path y[WpX
   * @param page y[W
   *
   * @return ʕ
   *
   * @throws UnsupportedEncodingException
   */
  public String encodePath(String path, String page)
        throws UnsupportedEncodingException;

  /**
   * JaJaWikiݒ
   *
   * @return JaJaWikiݒ
   */
  public JaJaWikiConfig getConfig();

  /**
   * JaJaWikiݒ
   *
   * @param config JaJaWikiݒ
   */
  public void setConfig(JaJaWikiConfig config);

  /**
   * DOCUMENT ME!
   *
   * @param listener DOCUMENT ME!
   */
  public void addPageChangeListener(PageChangeListener listener);
}
