/*
 * $Id: FilePageManager.java,v 1.1 2004/06/23 06:36:14 mashu Exp $
 */
package cx.ath.kgslab.wiki.pageman;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

import java.nio.channels.FileLock;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.GZIPOutputStream;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import cx.ath.kgslab.wiki.AbstractPageManager;
import cx.ath.kgslab.wiki.exception.PageReadException;
import cx.ath.kgslab.wiki.exception.PageWriteException;
import cx.ath.kgslab.wiki.pages.Page;

import org.apache.commons.compress.tar.TarEntry;
import org.apache.commons.compress.tar.TarOutputStream;

import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;

import org.springframework.web.context.WebApplicationContext;

import org.xml.sax.SAXException;


/**
 * y[WǗNX t@C. <br/> y[Wt@CǗꍇɎgpB(ftHg)
 *
 * @author VM
 * @version 3.0 
 *
 * @since JaJaWiki 2.0
 */
public class FilePageManager extends AbstractPageManager {
  /** Wikif[^̃pX */
  private static final String WIKI_DATA_PATH = "WEB-INF/wiki";

  /** Wikif[^̊gq */
  private static final String WIKI_DATA_EXT = ".xml";

  /** Wikiy[Wi[pX */
  private File wikiPath = null;

  /**
   * 
   */
  public void init() {
    if ((context != null) && context instanceof WebApplicationContext) {
      // WebAv̏ꍇ
      initialize((WebApplicationContext)context);
    } else {
      // X^hAAv̏ꍇ
      initialize(config.getRoot());
    }
  }

  /**
   * 
   *
   * @param context 擾T[ubg
   *
   * @see cx.ath.kgslab.wiki.PageManager#init(javax.servlet.Servlet)
   */
  public void initialize(WebApplicationContext context) {
    wikiPath =
      new File(context.getServletContext().getRealPath(WIKI_DATA_PATH));

    if (!wikiPath.exists()) {
      wikiPath.mkdirs();
    }
  }

  /**
   * 
   *
   * @param root 擾T[ubg
   *
   * @see cx.ath.kgslab.wiki.PageManager#init(javax.servlet.Servlet)
   */
  public void initialize(String root) {
    wikiPath = new File(root, WIKI_DATA_PATH);

    if (!wikiPath.exists()) {
      wikiPath.mkdirs();
    }
  }

  /**
   * y[Wt@CǂݍށB
   *
   * @param name y[W
   *
   * @return Page y[W
   *
   * @throws PageReadException
   *
   * @see cx.ath.kgslab.wiki.PageManager#getPage(java.lang.String)
   */
  public Page readPage(String name) throws PageReadException {
    try {
      File file = getFile(name);

      return readPage(file);
    } catch (UnsupportedEncodingException e) {
      throw new PageReadException("URLGR[fBO[" + config
        + "]gpł܂B", e);
    }
  }

  /**
   * y[Wt@CǂݍށB
   *
   * @param file y[Wt@C
   *
   * @return Page y[W
   *
   * @throws PageReadException
   */
  public Page readPage(File file) throws PageReadException {
    String encode = config.getPageEncode();

    try {
      SAXParserFactory factory = SAXParserFactory.newInstance();

      factory.setNamespaceAware(true);

      SAXParser parser = factory.newSAXParser();

      FileInputStream fis = new FileInputStream(file);
      Reader reader = new InputStreamReader(fis, encode);

      Page result = Page.unmarshal(reader);

      return result;
    } catch (FileNotFoundException e) {
      return null;
    } catch (MarshalException e) {
      throw new PageReadException(e);
    } catch (ValidationException e) {
      throw new PageReadException(e);
    } catch (SAXException e) {
      throw new PageReadException(e);
    } catch (ParserConfigurationException e) {
      throw new PageReadException(e);
    } catch (UnsupportedEncodingException e) {
      throw new PageReadException("URLGR[fBO[" + encode
        + "]gpł܂B", e);
    }
  }

  /**
   * y[Wt@Cɏo͂B
   *
   * @param page y[W
   *
   * @throws PageWriteException
   *
   * @see cx.ath.kgslab.wiki.PageManager#putPage(cx.ath.kgslab.wiki.pages.Page)
   */
  public void writePage(Page page) throws PageWriteException {
    FileOutputStream fos = null;
    Writer writer = null;
    FileLock fileLock = null;
    String encode = config.getPageEncode();

    try {
      String path = getFullPath(page);
      File file = getFile(path);

      fos = new FileOutputStream(file);
      fileLock = fos.getChannel().lock();
      writer = new OutputStreamWriter(fos, encode);

      Marshaller m = new Marshaller(writer);

      m.setEncoding(encode);
      m.marshal(page);
    } catch (FileNotFoundException e) {
      //e.printStackTrace();
      throw new PageWriteException(e);
    } catch (MarshalException e) {
      //e.printStackTrace();
      throw new PageWriteException(e);
    } catch (ValidationException e) {
      //e.printStackTrace();
      throw new PageWriteException(e);
    } catch (UnsupportedEncodingException e) {
      throw new PageWriteException("URLGR[fBO[" + encode
        + "]gpł܂B", e);
    } catch (IOException e) {
      //e.printStackTrace();
      throw new PageWriteException(e);
    } finally {
      try {
        if (writer != null) {
          writer.flush();
          writer.close();
        }

        if (fileLock != null) {
          fileLock.release();
        }
      } catch (IOException e) {
        e.printStackTrace();
        throw new PageWriteException(e);
      }
    }
  }

  /**
   * y[W/pXFileIuWFNg擾B
   *
   * @param name y[W
   *
   * @return File y[Wi[t@C
   *
   * @throws UnsupportedEncodingException
   */
  protected File getFile(String name)
        throws UnsupportedEncodingException {
    StringBuffer buf =
      new StringBuffer((name.length() * 3) + WIKI_DATA_EXT.length());

    if (name.indexOf('/') >= 0) {
      StringTokenizer tokens = new StringTokenizer(name, "/");
      boolean first = true;

      while (tokens.hasMoreTokens()) {
        if (!first) {
          buf.append('/');
        } else {
          first = false;
        }

        buf = encode(tokens.nextToken(), buf);
      }

      String dir = buf.toString();
      int idx = dir.lastIndexOf('/');

      if (idx > 0) {
        dir = dir.substring(0, idx);

        File path = new File(wikiPath, dir);

        if (!path.exists()) {
          path.mkdirs();
        }
      }
    } else {
      buf = encode(name, buf);
    }

    buf.append(WIKI_DATA_EXT);

    File file = new File(wikiPath, buf.toString());

    return file;
  }

  /**
   * y[W݂̑mFB
   *
   * @param name Ώۃy[W
   *
   * @return true:Yy[W false:Yy[WȂ
   *
   * @throws PageReadException
   *
   * @see cx.ath.kgslab.wiki.PageManager#existPage(java.lang.String)
   */
  public boolean existsPage(String name) throws PageReadException {
    try {
      return getFile(name).exists();
    } catch (UnsupportedEncodingException e) {
      throw new PageReadException("URLGR[fBO["
        + config.getPageEncode() + "]gpł܂B", e);
    }
  }

  /**
   * Wikiy[WobNAbvB
   *
   * @param path DOCUMENT ME!
   */
  public void backupPages(File path) {
    File backupFile =
      new File(path,
        config.getBackupfilePrefix()
        + config.getBackupDateFormat().format(new Date())
        + config.getBackupfileSuffix());

    try {
      TarOutputStream archive =
        new TarOutputStream(new GZIPOutputStream(
            new FileOutputStream(backupFile)));

      archive.setLongFileMode(TarOutputStream.LONGFILE_GNU);

      //System.out.println("WikiPath" + wikiPath.toString());
      //System.out.println("UploadPath" + config.getUploadPath());
      archive(archive, wikiPath, "WEB-INF", true);
      archive(archive, config.getUploadPath(),
        config.getUploadPath().getName(), false);

      archive.finish();
      archive.close();
    } catch (FileNotFoundException e) {
      e.printStackTrace();
    } catch (IOException e) {
      e.printStackTrace();
    }
  }

  /**
   * wfBNgȉ̃t@CAA[JCuɉB
   *
   * @param archive A[JCu
   * @param path fBNg
   * @param name Gg
   *
   * @throws InvalidHeaderException
   * @throws IOException
   */
  private void archive(TarOutputStream archive, File path,
    String dir, boolean wiki) throws IOException {
    List files = getAllFiles(path, wiki);
    Iterator ite = files.iterator();

    while (ite.hasNext()) {
      File temp = (File)ite.next();
      String name = temp.toString();

      name = name.substring(name.indexOf(dir) - 1);

      if (temp.exists()) {
        TarEntry ent = new TarEntry(name);

        ent.setSize(temp.length());
        ent.setModTime(temp.lastModified());

        //      archive.putNextEntry(ent);
        if (!temp.isDirectory()) {
          archive.putNextEntry(ent);
          BufferedInputStream is =
            new BufferedInputStream(new FileInputStream(temp));

          archive.copyEntryContents(is);
          archive.closeEntry();
        }

        //		archive.closeEntry();
      }
    }
  }

  /**
   * y[W폜B
   *
   * @param page Ώۃy[W
   *
   * @throws PageWriteException
   *
   * @see cx.ath.kgslab.wiki.PageManager#deletePage(java.lang.String)
   */
  protected void removePage(String page) throws PageWriteException {
    try {
      File file = getFile(page);

      file.delete();
    } catch (UnsupportedEncodingException e) {
      throw new PageWriteException("URLGR[fBO["
        + config.getPageEncode() + "]gpł܂B", e);
    }
  }

  /**
   * ŋߍXVꂽy[W̃Xg擾B
   *
   * @param count 
   *
   * @return XVy[W̃Xg
   *
   * @throws PageReadException
   *
   * @see cx.ath.kgslab.wiki.PageManager#getModifiedPageList(int)
   */
  public List getModifiedPageList(int count) throws PageReadException {
    List files = this.getAllFiles(wikiPath);

    List result = filesToPages(files);

    Collections.sort(result,
      new Comparator() {
        public int compare(Object o1, Object o2) {
          Page f1 = (Page)o1;
          Page f2 = (Page)o2;
          long result =
            f1.getLastModified().getTime()
            - f2.getLastModified().getTime();

          if (result == 0) {
            return 0;
          } else if (result < 0) {
            return 1;
          } else {
            return -1;
          }
        }
      });

    if (result.size() > count) {
      result = result.subList(0, count);
    }

    return result;
  }

  /**
   * Sy[W̃Xg擾B
   *
   * @return Sy[W̃Xg
   *
   * @throws PageReadException
   *
   * @see cx.ath.kgslab.wiki.PageManager#getPageList()
   */
  public List getPageList() throws PageReadException {
    return filesToPages(getAllFiles(wikiPath));
  }

  /**
   * w肳ꂽpXȉ̃t@CSĎ擾
   *
   * @param path pX
   *
   * @return t@CXg
   */
  private List getAllFiles(File path) {
    return getAllFiles(path, true);
  }

  /**
   * w肳ꂽpXȉ̃t@CSĎ擾
   *
   * @param path pX
   *
   * @return t@CXg
   */
  private List getAllFiles(File path, boolean wiki) {
    ArrayList result = new ArrayList();

    if (path != null) {
      File[] files = path.listFiles();

      for (int i = 0; i < files.length; i++) {
        if (files[i].isDirectory()) {
          if (!".svn".equalsIgnoreCase(files[i].getName())
              && !"CVS".equalsIgnoreCase(files[i].getName())) {
            result.addAll(getAllFiles(files[i], wiki));
          }
        } else {
          if ((!wiki)
              || files[i].getName().endsWith(config.getWikiPageExt())) {
            result.add(files[i]);
          }
        }
      }
    }

    return result;
  }

  /**
   * XgWikiy[Wt@Cy[WIuWFNgɕϊ
   *
   * @param files t@C̃Xg
   *
   * @return y[W̃Xg
   *
   * @throws PageReadException
   */
  private List filesToPages(List files) throws PageReadException {
    List result = new ArrayList(files.size());

    Iterator iterator = files.iterator();

    while (iterator.hasNext()) {
      File file = (File)iterator.next();

      if (file.getName().endsWith(WIKI_DATA_EXT)) {
        Page page = readPage(file);

        result.add(page);
      }
    }

    return result;
  }

  /**
   * @param path
   * @param name
   * @return
   * @see cx.ath.kgslab.wiki.PageManager#readPage(java.lang.String, java.lang.String)
   */
  protected Page readPage(String path, String name)
        throws PageReadException {
    return readPage(concatPath(path, name));
  }
}
