/*
 * $Id: HibernatePageManager.java,v 1.1 2004/06/23 06:36:14 mashu Exp $
 */
package cx.ath.kgslab.wiki.pageman.hibernate;

import java.io.File;

import java.sql.SQLException;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

import cx.ath.kgslab.wiki.AbstractPageManager;
import cx.ath.kgslab.wiki.exception.PageReadException;
import cx.ath.kgslab.wiki.exception.PageWriteException;
import cx.ath.kgslab.wiki.pageman.FilePageManager;
import cx.ath.kgslab.wiki.pages.Page;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;


/**
 * y[WǗNX DB.
 * <br>
 * y[WDBǗꍇɎgpB HibernategpB
 *
 * @author VM
 * @version 1.0 
 *
 * @since JaJaWiki 3.0
 */
public class HibernatePageManager extends AbstractPageManager {
  //  /** HibernatẽRtBO */
  //  Configuration hibConfig = null;

  /** ZbVt@Ng */
  SessionFactory sessionFactory = null;

  /** [gfBNgL */
  static final String ROOT = ".";

  /**
   * y[WDBǂݍށB
   *
   * @param path y[W̃tpX
   *
   * @return Page y[W
   *
   * @throws PageReadException DOCUMENT ME!
   *
   * @see cx.ath.kgslab.wiki.PageManager#getPage(java.lang.String)
   */
  protected Page readPage(String path) throws PageReadException {
    Page info = new Page();

    AbstractPageManager.parsePagePath(path, info);

    return readPage(info.getPath(), info.getTitle());
  }

  /**
   * y[WDBǂݍށB
   *
   * @param path y[WpX
   * @param name y[W
   *
   * @return Page y[W
   *
   * @throws PageReadException DOCUMENT ME!
   *
   * @see cx.ath.kgslab.wiki.PageManager#getPage(java.lang.String)
   */
  private Page readPage(String path, String name)
        throws PageReadException {
    //    context.log("readPage : " + name);
    Page result = null;
    Session session = null;

    if ((path == null) || (path.length() <= 0)) {
      path = ROOT;
    }

    try {
      session = openSession();
      Iterator ite =
        session.iterate("from Page as page where title='" + name
          + "' and path='" + path + "'");

      if (ite.hasNext()) {
        result = (Page)ite.next();
				if (ROOT.equals(result.getPath())) {
					result.setPath("");
				}
      }

      session.flush();
      session.connection().commit();
      session.close();
    } catch (SQLException ex) {
      //context.log("readPage : SQLException", ex);
      throw new PageReadException("readPage : SQLException", ex);
    } catch (HibernateException ex) {
      //context.log("readPage : HibernateException", ex);
      throw new PageReadException("readPage : HibernateException", ex);
    }

    //    context.log("readPage > " + result.toString());
    return result;
  }

  /**
   * y[WDBɏo͂B
   *
   * @param page y[W
   *
   * @throws PageWriteException
   *
   * @see cx.ath.kgslab.wiki.PageManager#putPage(cx.ath.kgslab.wiki.pages.Page)
   */
  protected void writePage(Page page) throws PageWriteException {
    //    context.log("writePage : " + page.toString());
    try {
      String path = page.getPath();

      if ((path == null) || (path.length() <= 0)) {
        page.setPath(ROOT);
      }

      if (page.getChild() == null) {
        page.setChild(new HashSet());
      }

      page.setLastModified(new Date());
      Session session = openSession();

      session.save(page);
      session.flush();
      session.connection().commit();
      session.close();
      page.setPath(path);
    } catch (SQLException ex) {
      //context.log("writePage : SQLException", ex);
      throw new PageWriteException("writePage : SQLException", ex);
    } catch (HibernateException ex) {
      //context.log("writePage : HibernateException", ex);
      throw new PageWriteException("writePage : HibernateException",
        ex);
    }
  }

  /**
   * y[W݂̑mFB
   *
   * @param path y[WpX
   * @param name y[W
   *
   * @return true:Yy[W false:Yy[WȂ
   *
   * @throws PageReadException
   *
   * @see cx.ath.kgslab.wiki.PageManager#existsPage(java.lang.String,
   *      java.lang.String)
   */
  private boolean existsPage_(String path, String name)
        throws PageReadException {
    //    context.log("existsPage : " + path + " / " + name);
    boolean result = false;

    try {
      if ((path == null) || (path.length() <= 0)) {
        path = ROOT;
      }

      Session session = openSession();
      Iterator ite =
        session.iterate("select count(*) from Page where title='"
          + name + "' and path='" + path + "'");

      if (ite.hasNext()) {
        Integer value = (Integer)ite.next();

        if (value.intValue() > 0) {
          result = true;
        }
      }

      session.flush();
      session.connection().commit();
      session.close();
    } catch (SQLException ex) {
      //context.log("existsPage : SQLException", ex);
      throw new PageReadException("existsPage : SQLException", ex);
    } catch (HibernateException ex) {
      //context.log("existsPage : HibernateException", ex);
      throw new PageReadException("existsPage : HibernateException",
        ex);
    }

    //    context.log("existsPage > " + result);
    return result;
  }

  /**
   * y[W݂̑mFB
   *
   * @param page Ώۃy[WpX/y[W
   *
   * @return true:Yy[W false:Yy[WȂ
   *
   * @throws PageReadException
   *
   * @see cx.ath.kgslab.wiki.PageManager#existPage(java.lang.String)
   */
  public boolean existsPage(String page) throws PageReadException {
    //    context.log("existsPath : " + page);
    Page info = new Page();

    AbstractPageManager.parsePagePath(page, info);

    return existsPage_(info.getPath(), info.getTitle());
  }

  /**
   * Wikiy[WobNAbvB
   *
   * @see cx.ath.kgslab.wiki.PageManager#backupPages(java.io.File)
   */
  public void backupPages(File path)
        throws PageReadException, PageWriteException {
    try {
      Session session = openSession();
      Iterator ite = session.iterate("from Page");
      FilePageManager fpm = new FilePageManager();

      fpm.setConfig(config);
      fpm.setApplicationContext(context);
      fpm.init();

      while (ite.hasNext()) {
        Page value = (Page)ite.next();

        fpm.writePage(value);
      }

      fpm.backupPages(path);

      session.flush();
      session.connection().commit();
      session.close();
    } catch (SQLException ex) {
      //context.log("backupPages : SQLException", ex);
      throw new PageReadException("backupPages : SQLException", ex);
    } catch (HibernateException ex) {
      //context.log("backupPages : HibernateException", ex);
      throw new PageReadException("backupPages : HibernateException",
        ex);
    }
  }

  /**
   * y[W폜B
   *
   * @param name Ώۃy[W
   *
   * @throws PageWriteException
   *
   * @see cx.ath.kgslab.wiki.PageManager#deletePage(java.lang.String)
   */
  protected void removePage(String name) throws PageWriteException {
    //    context.log("removePage : " + name);
    try {
      Session session = openSession();

      session.delete("delete Page where title= '" + name
        + "' and path='" + ROOT + "'");
      session.flush();
      session.connection().commit();
      session.close();
    } catch (SQLException ex) {
      //context.log("removePage : SQLException", ex);
      throw new PageWriteException("removePage : SQLException", ex);
    } catch (HibernateException ex) {
      //context.log("removePage : HibernateException", ex);
      throw new PageWriteException("removePage : HibernateException",
        ex);
    }
  }

  /**
   * ŋߍXVꂽy[W̃Xg擾B
   *
   * @param count 
   *
   * @return XVy[W̃Xg
   *
   * @throws PageReadException
   *
   * @see cx.ath.kgslab.wiki.PageManager#getModifiedPageList(int)
   */
  public List getModifiedPageList(int count) throws PageReadException {
    //    context.log("getModifiedPageList : " + count);
    List result = null;

    try {
      Session session = openSession();
      Iterator ite =
        session.iterate(
          "from Page as page order by page.lastModified desc");
      int cnt = 0;

      result = new ArrayList(count);
      while (ite.hasNext() && (count < cnt)) {
        Page value = (Page)ite.next();

        result.add(value);
      }

      session.flush();
      session.connection().commit();
      session.close();
    } catch (SQLException ex) {
      //context.log("getModifiedPageList : SQLException", ex);
      throw new PageReadException("getModifiedPageList : SQLException",
        ex);
    } catch (HibernateException ex) {
      //context.log("getModifiedPageList : HibernateException", ex);
      throw new PageReadException("getModifiedPageList : HibernateException",
        ex);
    }

    //    context.log("getModifiedPageList > " + result);
    return result;
  }

  /**
   * Sy[W̃Xg擾B
   *
   * @return Sy[W̃Xg
   *
   * @throws PageReadException
   *
   * @see cx.ath.kgslab.wiki.PageManager#getPageList()
   */
  public List getPageList() throws PageReadException {
    //    context.log("getPageList");
    List result = null;

    try {
      Session session = openSession();

      //System.out.println("session : " + session);
      Query query = session.createQuery("from Page");

      //System.out.println("query : " + query);
      result = query.list();
      session.flush();
      session.connection().commit();
      session.close();
    } catch (SQLException ex) {
      //context.log("getPageList : SQLException", ex);
      throw new PageReadException("getPageList : SQLException", ex);
    } catch (HibernateException ex) {
      //context.log("getPageList : HibernateException", ex);
      throw new PageReadException("getPageList : HibernateException",
        ex);
    } finally {
      if (result == null) {
        result = new ArrayList(0);
      }
    }

    //    context.log("getPageList > " + result);
    return result;
  }

  /**
   * ZbVJB
   *
   * @return I[vZbVB
   *
   * @throws SQLException ZbVJۂɔOB
   * @throws HibernateException
   */
  private Session openSession()
        throws SQLException, HibernateException {
    return sessionFactory.openSession();
  }

  /**
   * ZbVt@Ng̎擾
   *
   * @return ZbVt@Ng
   */
  public SessionFactory getSessionFactory() {
    return sessionFactory;
  }

  /**
   * ZbVt@Ng̐ݒ
   *
   * @param factory ZbVt@Ng
   */
  public void setSessionFactory(SessionFactory factory) {
    sessionFactory = factory;
  }
}
