/*
 * $Id: Body.java,v 1.1 2004/06/23 06:36:14 mashu Exp $
 */
package cx.ath.kgslab.wiki.parser.element;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;


/**
 * Bodyvf
 *
 * @author VM
 * @version 4.1 
 *
 * @since JaJaWiki 2.5
 */
public class Body extends Block {
  /** oXg */
  protected ArrayList headingList = new ArrayList();

  /** oA */
  int headingId = 0;

  /** x */
  protected int level = -1;

  /** o̍ő僌x */
  private int maxHeaderLevel = 3;

  /**
   * vfǉ
   *
   * @param child qvf
   *
   * @see cx.ath.kgslab.wiki.parser.element.Block#add(cx.ath.kgslab.wiki.parser.element.Element)
   */
  protected void add(Element child) {
    if (child instanceof Heading) {
      Heading head = ((Heading)child);

      head.setId(headingId++);
      headingList.add(child);

      if (maxHeaderLevel > head.getLevel()) {
        maxHeaderLevel = head.getLevel();
      }
    }

    super.add(child);
  }

  /**
   * CX^X
   * 
   * Body͑dȂ̂ŁAnullԂB
   *
   * @param line
   *
   * @return null
   *
   * @see cx.ath.kgslab.wiki.parser.element.Block#create(java.lang.String)
   */
  protected Block create(String line) {
    return null;
  }

  /**
   * qvfƂł邩`FbN
   * 
   * SĂ̎ނ̎qvfƂł̂ŁAtrueԂB
   *
   * @param elm qvf
   *
   * @return true
   *
   * @see cx.ath.kgslab.wiki.parser.element.Block#canContain(cx.ath.kgslab.wiki.parser.element.Block)
   */
  public boolean canContain(Block elm) {
    return true;
  }

  /**
   * y[Wڎ𐶐B
   *
   * @return y[W̖ڎ
   */
  public String createTOC() {
    return createTOC(headingList);
  }

  /**
   * y[Wڎ𐶐B
   *
   * @param list wb_Xg
   *
   * @return y[W̖ڎ
   */
  private String createTOC(List list) {
    StringBuffer result = new StringBuffer();
    ListIterator iterator = list.listIterator();
    
		createTOCListElement(iterator, result, 1);
		return result.toString();
  }
  
  private void createTOCListElement(ListIterator iterator, StringBuffer buf, int level) {
		buf.append("<ul class=\"list").append(level).append("\">\n");
		boolean first = true;
		while (iterator.hasNext()) {
			Heading item = (Heading)iterator.next();
			if (level < item.getLevel()) {
				iterator.previous();
				createTOCListElement(iterator, buf, level+1);
			} else if (level > item.getLevel()){
				iterator.previous();
				break;
			} else {
				if (!first) {
					buf.append("</li>\n");
				}
				
				buf.append("<li>");
				wrap(buf, item.getText(), "a",
					"href=\"#header" + item.getId() + "\"");
				
			}
			first = false;
		}
		buf.append("</li>\n</ul>\n");
  }
}
