/*
 * $Id: Amazon.java,v 1.1 2004/06/23 06:36:13 mashu Exp $
 */
package cx.ath.kgslab.wiki.plugin;

import java.io.IOException;

import java.net.MalformedURLException;
import java.net.URL;

import java.text.MessageFormat;

import java.util.Iterator;
import java.util.List;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import cx.ath.kgslab.wiki.plugin.amazon.AmazonHandler;
import cx.ath.kgslab.wiki.plugin.amazon.ProductionInfo;
import cx.ath.kgslab.wiki.plugin.exception.PluginException;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;


/**
 * AmazonvOC
 * <br/>
 * Amazon̏ЁADVD̏\Aiy[WփNB
 *
 * @author VM
 */
public class Amazon extends PluginBase {
  /** Amazon WebService Deveroper Token(؂蕨) */
  protected static final String DEV_TOKEN = "GTYDRES564THU";

  /** 摜TCY: */
  protected static final String SIZE_SMALL = "small";

  /** 摜TCY: */
  protected static final String SIZE_MIDIUM = "midium";

  /** 摜TCY: */
  protected static final String SIZE_LARGE = "large";

  /** 摜TCY:ftHg */
  protected static final String SIZE_DEFAULT = SIZE_MIDIUM;

  /** 肱:Ȃ */
  protected static final String FLT_NONE = "none";

  /** 肱:̉EɃC[W */
  protected static final String FLT_RIGHT = "right";

  /** 肱:̉EɃC[W */
  protected static final String FLT_LEFT = "left";

  /** 肱݁FftHg */
  protected static final String FLT_DEFAULT = FLT_NONE;

  /** R}h:C[W\ */
  protected static final String CMD_IMAGE = "image";

  /** R}h:^Cg\ */
  protected static final String CMD_PRODNAME = "prodname";

  /** R}h:/A[eBXg\ */
  protected static final String CMD_AUTHOR = "author";

  /** R}h:oŎ/R[hЕ\ */
  protected static final String CMD_MANUFACTURER = "manufacturer";

  /** \ */
  protected static final String CMD_RELEASE = "release";

  /** R}h:ftHg */
  protected static final String CMD_DEFAULT = CMD_IMAGE;

  /** Amazon WebService URL(XML[h) */
  protected MessageFormat AMAZON_URL_FORMAT =
    new MessageFormat(
      "http://xml.amazon.co.jp/onca/xml3?t={0}&dev-t=" + DEV_TOKEN
      + "&type=lite&page=1&f=xml&locale=jp&AsinSearch={1}");

  /** Amazon Associate ID */
  protected String associateId = "kgslab-22";

  /**
   *
   * @see cx.ath.kgslab.wiki.plugin.Plugin#toHTML()
   */
  public String toHTML() throws PluginException {
    String[] params = getParams();

    if ((params == null) || (params.length <= 0)) {
      throw new PluginException("͕K{łBISBNR[hASINR[h͂ĂB");
    }

    String asin = params[0];
    String imageSize = SIZE_DEFAULT;
    String floating = FLT_DEFAULT;
    String command = CMD_DEFAULT;

    if (params.length >= 2) {
      if ((params[1] != null) && (params[1].length() > 0)) {
        imageSize = params[1];
      }

      if (params.length >= 3) {
        if ((params[2] != null) && (params[2].length() > 0)) {
          floating = params[2];
        }

        if (params.length >= 4) {
          if ((params[3] != null) && (params[3].length() > 0)) {
            command = params[3];
          }
        }
      }
    }

    String urlString =
      AMAZON_URL_FORMAT.format(new Object[] {
          associateId,
          asin
        });

    try {
      return parseAmazonInfo(imageSize, floating, command, urlString);
    } catch (MalformedURLException e) {
      throw new PluginException(e);
    } catch (IOException e) {
      throw new PluginException(e);
    } catch (ParserConfigurationException e) {
      throw new PluginException(e);
    } catch (SAXException e) {
      throw new PluginException(e);
    }
  }

  /**
   * DOCUMENT ME!
   *
   * @param imageSize DOCUMENT ME!
   * @param command DOCUMENT ME!
   * @param urlString DOCUMENT ME!
   *
   * @return DOCUMENT ME!
   *
   * @throws MalformedURLException DOCUMENT ME!
   * @throws IOException DOCUMENT ME!
   * @throws ParserConfigurationException DOCUMENT ME!
   * @throws SAXException DOCUMENT ME!
   */
  protected String parseAmazonInfo(String imageSize, String floating,
    String command, String urlString)
        throws MalformedURLException, IOException, 
          ParserConfigurationException, SAXException {
    List infos = getAmazonInfos(urlString);
    Iterator ite = infos.iterator();
    StringBuffer buf = new StringBuffer();

    while (ite.hasNext()) {
      ProductionInfo info = (ProductionInfo)ite.next();

      //      if (!FLT_NONE.equals(floating)) {
      //      	buf.append("<div style=\"float:").append(floating).append("\">");
      //      }
      buf.append(parseAmazonInfo(imageSize, floating, command, info));

      //			if (!FLT_NONE.equals(floating)) {
      //				buf.append("</div>");
      //			}
    }

    return buf.toString();
  }

  /**
   * DOCUMENT ME!
   *
   * @param imageSize DOCUMENT ME!
   * @param command DOCUMENT ME!
   * @param info DOCUMENT ME!
   *
   * @return DOCUMENT ME!
   */
  protected String parseAmazonInfo(String imageSize, String floating,
    String command, ProductionInfo info) {
    StringBuffer buf = new StringBuffer();

    buf.append("<a href=\"").append(info.getUrl()).append("\">");

    if (command.indexOf(CMD_IMAGE) >= 0) {
      parseImage(imageSize, floating, info, buf);
    }

    if (command.indexOf(CMD_PRODNAME) >= 0) {
      buf.append(info.getProductName()).append("\n");
    }

    buf.append("</a>");

    if (command.indexOf(CMD_AUTHOR) >= 0) {
      appendList(buf, info.getArtists());
      appendList(buf, info.getAuthors());
    }

    if (command.indexOf(CMD_MANUFACTURER) >= 0) {
      buf.append(info.getManufacturer()).append("\n");
    }

    if (command.indexOf(CMD_RELEASE) >= 0) {
      buf.append(info.getReleaseDate()).append("\n");
    }

    return buf.toString();
  }

  /**
   * DOCUMENT ME!
   *
   * @param imageSize DOCUMENT ME!
   * @param info DOCUMENT ME!
   * @param buf DOCUMENT ME!
   */
  protected void parseImage(String imageSize, String floating,
    ProductionInfo info, StringBuffer buf) {
    buf.append("<img ");

    if (!FLT_NONE.equals(floating)) {
      buf.append("style=\"float:").append(floating).append("\" ");
    }

    buf.append("src=\"");
    if (SIZE_SMALL.equalsIgnoreCase(imageSize)) {
      buf.append(info.getImageUrlSmall());
    } else if (SIZE_MIDIUM.equalsIgnoreCase(imageSize)) {
      buf.append(info.getImageUrlMedium());
    } else if (SIZE_LARGE.equalsIgnoreCase(imageSize)) {
      buf.append(info.getImageUrlLarge());
    }

    buf.append("\" alt=\"").append(info.getProductName()).append("\"/>\n");
  }

  /**
   * DOCUMENT ME!
   *
   * @param buf DOCUMENT ME!
   * @param list DOCUMENT ME!
   */
  private void appendList(StringBuffer buf, List list) {
    if (list != null) {
      Iterator ite = list.iterator();

      while (ite.hasNext()) {
        String element = (String)ite.next();

        buf.append(element).append("\n");
      }
    }
  }

  /**
   * DOCUMENT ME!
   *
   * @param urlString DOCUMENT ME!
   *
   * @return DOCUMENT ME!
   *
   * @throws MalformedURLException DOCUMENT ME!
   * @throws IOException DOCUMENT ME!
   * @throws ParserConfigurationException DOCUMENT ME!
   * @throws SAXException DOCUMENT ME!
   */
  protected List getAmazonInfos(String urlString)
        throws MalformedURLException, IOException, 
          ParserConfigurationException, SAXException {
    URL url = new URL(urlString);
    InputSource is = new InputSource(url.openStream());
    SAXParserFactory factory = SAXParserFactory.newInstance();

    factory.setNamespaceAware(false);
    factory.setValidating(false);
    SAXParser parser = factory.newSAXParser();
    AmazonHandler handler = new AmazonHandler();

    parser.parse(is, handler);
    List infos = handler.getInfos();

    return infos;
  }

  /**
   * @see cx.ath.kgslab.wiki.plugin.Plugin#getPluginHelp()
   */
  public String getPluginHelp() {
    return "***{0}:AmazonvOC \n" + " &amp;{0}(ASINR[h);\n"
    + "s&#38;{0}LqƁA\n"
    + "w肳ꂽASIN(Amazon Standard Item Number)R[h܂ISBNR[hɑΉAmazon̏i摜ƁA\n"
    + "iЉTCgւ̃N\t邱Ƃł܂B\n"
    + "&#38;{0}ɂ́AJ}ŋ؂ĉL̃p^wł܂B\n"
    + "p^ȗꍇ̓ftHglƂȂ܂B\n"
    + " &amp;{0}(ASINR[h, 摜TCY, 肱, R}h);\n" + ":摜TCY|摜TCÝA"
    + SIZE_SMALL + "A" + SIZE_MIDIUM + "A" + SIZE_LARGE + "3ނłB"
    + "ftHg'" + SIZE_DEFAULT + "'ł\n"
    + ":肱|͂ɑ΂摜̉肱݂wł܂BftHg" + FLT_DEFAULT + "łB\n"
    + "::" + FLT_NONE + "|肱ݎw薳B\n" + "::" + FLT_RIGHT
    + "|͂̉Eɉ摜荞݂܂B\n" + "::" + FLT_LEFT + "|͂̍ɉ摜荞݂܂\n"
    + ":R}h|\wł܂Bȉ̃R}h'|'ŘAĎw肵܂BftHg"
    + CMD_DEFAULT + "łB\n" + "::" + CMD_IMAGE + "|ỉ摜\܂B\n"
    + "::" + CMD_PRODNAME + "|i\܂B\n" + "::" + CMD_AUTHOR
    + "|ҖAA[eBXg\܂B\n" + "::" + CMD_MANUFACTURER
    + "|oŎЖA[xAA̔Ж\܂B\n" + "::" + CMD_RELEASE
    + "|\܂B\n" + "-AmazonvOĆACCvfƂĈׂłB\n"
    + "-AmazonvOĆA̗vf̎qvfɂȂ邱Ƃł܂B\n"
    + "-AmazonvOĆA̗vfqvfɂ邱Ƃ͂ł܂B\n"
    + "AmazonvOĆAAmazon.co.jp̃T[rXgpĂ܂BAmazon.com/uk/dẽT[rXɂ͑Ή܂B";
  }

  /**
   * Amazon Associate ID̎擾
   * @return Amazon Associate ID
   */
  public String getAssociateId() {
    return associateId;
  }

  /**
   * Amazon Associate ID̐ݒ
   * @param string Amazon Associate ID
   */
  public void setAssociateId(String string) {
    associateId = string;
  }
}
