/*
 * $Id: Color.java,v 1.1 2004/06/23 06:36:13 mashu Exp $
 */
package cx.ath.kgslab.wiki.plugin;

import cx.ath.kgslab.wiki.plugin.exception.PluginException;

import org.apache.commons.validator.GenericValidator;


/**
 * FwvOC
 * <br/>
 * &amp;color([Fw]){[Ώە]};
 * <br/>
 * 
 * <br/>
 * &lt;span style="color:[Fw]"&gt;[Ώە]&lt;/span&gt;
 * <br/>
 * ɕϊB
 *
 * @author VM
 * @version 1.0 
 */
public class Color extends PluginBase {
  /**
   * ɕϊ
   *
   * @see cx.ath.kgslab.wiki.inline.InlineElementPlugin#toString()
   */
  public String toHTML() throws PluginException {
    if (GenericValidator.matchRegexp(params,
          "^([a-zA-Z]+|#[a-fA-F0-9]{1,6})$")) {
      return "<span style=\"color:" + params + ";\">" + text
      + "</span>";
    } else {
      throw new PluginException("p[^słB(" + params + ")");
    }
  }

  /**
   * ̃vOC̎gp@
   * @see cx.ath.kgslab.wiki.plugin.Plugin#getPluginHelp()
   */
  public String getPluginHelp() {
    return "***{0}:F\n" + " &amp;{0}(F)'{CCvf}';\n"
    + "s&#38;{0}ƃCCvf&{0}(crimson)'{F}';w肷邱Ƃł܂B\n"
    + "-F̎ẃÂꂩ̌`ōsȂ܂B\n" + "--[[FL[[h>ColorKeywords]]\n"
    + "--#16i6\n" + "--#16i3\n"
    + "-FvOĆÃCCvf̎qvfɂȂ邱Ƃ͂ł܂B\n"
    + "-FvOĆÃCCvfqvfɂ邱Ƃł܂B";
  }
}
