/*
 * $Id: Comment.java,v 1.1 2004/06/23 06:36:13 mashu Exp $
 */
package cx.ath.kgslab.wiki.plugin;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;

import java.net.URLEncoder;

import java.text.MessageFormat;

import java.util.Date;

import cx.ath.kgslab.wiki.AbstractPageManager;
import cx.ath.kgslab.wiki.exception.PageReadException;
import cx.ath.kgslab.wiki.pages.Page;
import cx.ath.kgslab.wiki.plugin.exception.PluginException;
import cx.ath.kgslab.wiki.struts.form.PluginForm;


/**
 * sRg̓vOC
 *
 * @author VM
 * @version 2.0 
 *
 * @since JaJaWiki 1.0
 */
public class Comment extends PluginBase {
  /** Rg^Cg */
  public static final String COMMENT_TITLE = "Rg";

  /** ftHgő\ */
  private static final int MAX = 10;

  /** Py[WɃRgꍇ */
  private static final MessageFormat FORM_FORMAT =
    new MessageFormat("<form method=\"post\" action=\"{3}\"><div>\n"
      + " <input type=\"hidden\" name=\"page\" value=\"{0}\" />\n"
      + " <input type=\"hidden\" name=\"plugin\" value=\"{5}\" />\n"
      + " <input type=\"hidden\" name=\"id\" value=\"{1}\" />\n"
      + " O\n"
      + " <input type=\"text\" name=\"options\" size=\"15\" /> : \n"
      + " <input type=\"text\" name=\"options\" size=\"45\"/>\n"
      + " <input type=\"submit\" value=\"\" /><br />\n"
      + " <a href=\"{4}\""
      + " class=\"small\">ŐV{2}̂ݕ\Ă܂...</a>\n"
      + "</div></form>");

  /** Py[WɃRgЂƂ̏ꍇ */
  private static final MessageFormat FORM_FORMAT2 =
    new MessageFormat("<form method=\"post\" action=\"{2}\"><div>\n"
      + " <input type=\"hidden\" name=\"page\" value=\"{0}\" />\n"
      + " <input type=\"hidden\" name=\"plugin\" value=\"{4}\" />\n"
      + " O\n"
      + " <input type=\"text\" name=\"options\" size=\"15\" /> : \n"
      + " <input type=\"text\" name=\"options\" size=\"45\"/>\n"
      + " <input type=\"submit\" value=\"\" /><br />\n"
      + " <a href=\"{3}\""
      + " class=\"small\">ŐV{1}̂ݕ\Ă܂...</a>\n"
      + "</div></form>");

  /** bZ[W̃tH[}bg */
  private static final MessageFormat FORMAT =
    new MessageFormat("-{0} : [[{1}]] {2,date,yyyy-MM-dd HH:mm:ss}");

  /** ő\ */
  private int max = MAX;

  /** ID */
  private String id = "";

  /**
   * p[^ݒ <br/> p[^ĂꍇA Rgy[WɃp[^ǉB
   *
   * @see cx.ath.kgslab.wiki.inline.InlineElementPlugin#setParams(java.lang.String)
   */
  public void setParams(String param) {
    if (param != null) {
      int idx = param.indexOf(",");

      if (idx < 0) {
        max = Integer.parseInt(param);
        id = null;
      } else {
        max = Integer.parseInt(param.substring(0, idx));
        id = param.substring(idx + 1);
      }
    } else {
      id = null;
      max = MAX;
    }
  }

  /**
   * ϊ <br/> ۂ̃Rǧڂ鏈B
   *
   * @see java.lang.Object#toString()
   */
  public String toHTML() throws PluginException {
    try {
      String path = this.page;

      String title =
        (((id == null) || (id.trim().length() <= 0)) ? COMMENT_TITLE
                                                     : id);
      String result = "";

      if (pageManager.existsPage(path, title)) {
        Page info =
          pageManager.getPage(AbstractPageManager.concatPath(path,
              title));
        LineNumberReader reader =
          new LineNumberReader(new StringReader(info.getContent()));
        String[] lineBuf = new String[max];
        int idx = 0;
        String line = "";

        //sڂ͓ǂݎ̂Ă
        reader.readLine();

        while ((line = reader.readLine()) != null) {
          lineBuf[idx] = line;
          idx++;

          if (idx >= max) {
            idx = 0;
          }
        }

        if ((idx < MAX) && (lineBuf[idx] == null)) {
          idx = 0;
        }

        StringBuffer buf = new StringBuffer();

        //System.out.println("comment toString>");
        for (int i = 0; (i < MAX) && (lineBuf[idx] != null); i++) {
          //System.out.println("comment toString>>" + idx + ">" + lineBuf[idx]);
          buf.append(lineBuf[idx]).append("\n");

          idx++;

          if (idx >= MAX) {
            idx = 0;
          }
        }

        //System.out.println("comment toString>");
        if (converter != null) {
          result = converter.convert(buf.toString());
        } else {
          result = buf.toString();
        }
      }

      //      String temp = URLEncoder.encode(path, JaJaWikiConst.URL_ENC);
      //String parentPath = PageManager.concatPath(path, title);
      String actionUrl = this.contextPath + "/plugin.do";
      String linkUrl = this.contextPath + "/view.do?page=";

      if ((id != null) && (id.trim().length() > 0)) {
        result += FORM_FORMAT.format(new Object[] {
            this.page,
            id,
            new Integer(max),
            actionUrl,
            this.encodeURL(linkUrl
              + URLEncoder.encode(AbstractPageManager.concatPath(
                  path, id), config.getUrlEncode())),
            this.pluginName,
          });
      } else {
        result += FORM_FORMAT2.format(new Object[] {
            this.page,
            new Integer(max),
            actionUrl,
            this.encodeURL(linkUrl
              + URLEncoder.encode(AbstractPageManager.concatPath(
                  path, COMMENT_TITLE), config.getUrlEncode())),
            this.pluginName,
          });
      }

      //System.out.println("comment toString : " + result);
      return result;
    } catch (PageReadException e) {
      throw new PluginException(e.getMessage(), e);
    } catch (UnsupportedEncodingException e) {
      throw new PluginException(e.getMessage(), e);
    } catch (IOException e) {
      throw new PluginException(e.getMessage(), e);
    }
  }

  /**
   * ANV
   *
   * @param form
   *
   * @throws PluginException
   *
   * @see cx.ath.kgslab.wiki.inline.ActionPlugin#action(cx.ath.kgslab.wiki.struts.form.PluginForm)
   */
  public void action(PluginForm form) throws PluginException {
    String page = form.getPage();
    String id = form.getId();
    Object[] options = form.getOptions();
    String name = (String)options[0];
    String message = (String)options[1];

    if ((id == null) || (id.trim().length() <= 0)) {
      id = COMMENT_TITLE;
    }

    // Rg̒ǉB
    try {
      addComment(page, id, name, message);
    } catch (Exception ex) {
      throw new PluginException(ex);
    }
  }

  /**
   * Rg̒ǉB
   *
   * @param page RgΏۃy[W
   * @param id RgID
   * @param name ͎Җ
   * @param message bZ[W
   *
   * @throws Exception
   */
  protected void addComment(String page, String id, String name,
    String message) throws Exception {
    String commentPage = id;

    Page info = pageManager.getPage(page);

    if (!info.containChild(id)) {
      info.addChild(id);
      pageManager.putPage(info, false);
    }

    info =
      pageManager.getPage(AbstractPageManager.concatPath(page,
          commentPage));

    StringBuffer buf = null;

    if (info == null) {
      info = new Page();
      info.setPath(page);
      info.setTitle(id);
      buf = new StringBuffer("*RgO\n");
    } else {
      buf = new StringBuffer(info.getContent());
    }

    buf.append(FORMAT.format(
        new Object[] {
          message,
          name,
          new Date()
        })).append("\n");

    info.setContent(buf.toString());
    info.setConvertedPage("");
    pageManager.putPage(info);
  }

  /**
   * @see cx.ath.kgslab.wiki.plugin.Plugin#getPluginHelp()
   */
  public String getPluginHelp() {
    return "***{0}:Rg\n" + " &amp;{0};\n"
    + "&#38;{0}LqƁARg}邽߂̃tH[ߍ܂܂B\n"
    + "ŐV10݂݂̏̂\AׂẴRg͕ʃy[WɋL^܂B\n"
    + "Rg̃y[ẂAtH[\ty[W̔zɍ܂B\n" + "\n"
    + " &amp;{0}(ő\);\n" + "\鏑݂̐10ȊOɂꍇ́A\n"
    + "Ƃčő\^B\n" + "\n" + " &amp;{0}(ő\, y[W);\n"
    + "̃y[Wɕ̃Rg̓tH[͂ꍇɂ́A\n"
    + "ɃRgۑy[Wǉ邱ƂŁA\n" + "ʁX̃y[WɃRgL^܂B\n"
    + "-Rg̓vOĆAubNvfƂĈׂłB\n"
    + "-Rg̓vOĆA̗vf̎qvfɂȂ邱Ƃ͂ł܂B\n"
    + "-Rg̓vOĆA̗vfqvfɂ邱Ƃ͂ł܂B";
  }
}
