/*
 * $Id: DiaryEdit.java,v 1.1 2004/06/23 06:36:13 mashu Exp $
 */
package cx.ath.kgslab.wiki.plugin;

import java.io.UnsupportedEncodingException;

import java.text.MessageFormat;

import java.util.Calendar;

import cx.ath.kgslab.wiki.AbstractPageManager;
import cx.ath.kgslab.wiki.exception.PageReadException;
import cx.ath.kgslab.wiki.pages.Page;


/**
 * LҏW^O/vOC
 *
 * @author VM
 * @version 3.0 
 * @since JaJaWiki 1.0
 */
public class DiaryEdit extends Diary {
  /**  */
  private String methodID = "";

  /**
   * ɂ̓t̕ҏWʂJ悤ɃI[oChB
   *
   * @param date
   *
   * @return
   *
   * @see cx.ath.kgslab.wiki.taglib.DiaryTag#createDateLink(int,
   *      java.lang.String)
   */
  protected String createDateLink(String path, Calendar date)
        throws UnsupportedEncodingException, PageReadException {
    int day = date.get(Calendar.DATE);
    MessageFormat PAGE_TITLE = new MessageFormat(title + "({0})");
    String page =
      PAGE_TITLE.format(new Object[] {
          PAGENAME_DATE_FORMAT.format(date.getTime())
        });
    StringBuffer result = new StringBuffer();

    result.append("<a href=\"javascript:moveEditPage").append(methodID)
          .append("('")
          .append(AbstractPageManager.concatPath(path, page))
          .append("', '")
          .append(pageManager.existsPage(path, page) ? "false" : "true")
          .append("')\">");
    result.append(day);
    result.append("</a>");

    return result.toString();
  }

  /**
   * tb^ɂ͉\Ȃ悤ɃI[oChB
   *
   * @param root
   * @param params
   * @param page
   *
   * @return ""
   */
  protected String createFooter(Page root, Object[] params,
    String path, String page) {
    return "";
  }

  /**
   * {fB𐶐B
   *
   * @param params p[^
   * @param page y[W
   *
   * @return
   */
  protected String createBody(Object[] params, String path,
    String page)
        throws UnsupportedEncodingException, PageReadException {
    StringBuffer result = new StringBuffer();
    String basePath = AbstractPageManager.concatPath(path, page);

    methodID = (String)params[2];
    result.append(" <tbody>\n");
    result.append("  <script type=\"text/javascript\">\n");
    result.append("<!--\n");
    result.append("  function moveEditPage").append(methodID).append("(page, takeContent) {\n");
    result.append("    document.forms['create_diary").append(methodID)
          .append("'].page.value = page;\n");
    result.append("    if (takeContent == 'true') {\n");
    result.append("      document.forms['create_diary")
          .append(methodID).append("'].contents.value = \"\\n\\n[[߂>")
          .append(basePath).append("]]\";\n");
    result.append("      document.forms['create_diary")
          .append(methodID).append("'].command.value = \"takeContent\"\n");
    result.append("    }\n");
    result.append("    document.forms['create_diary").append(methodID)
          .append("'].submit();\n");
    result.append("  }\n");
    result.append("//-->\n");
    result.append("  </script>\n");
    result.append("  <form action=\"")
          .append(this.encodeURL(this.contextPath + "/edit.do"))
          .append("\" method=\"post\" id=\"create_diary")
          .append(methodID).append("\">");
    result.append(
      "<input type=\"hidden\" name=\"page\" value=\"page\"/>");
    result.append(
      "<input type=\"hidden\" name=\"contents\" value=\"\"/>\n");
    result.append(
      "<input type=\"hidden\" name=\"command\" value=\"\"/>\n");
    result.append("  </form>\n");
    result.append(createCalendarTable(path, page));
    result.append(" </tbody>\n");

    return result.toString();
  }

  /**
   * @see cx.ath.kgslab.wiki.plugin.Plugin#getPluginHelp()
   */
  public String getPluginHelp() {
    return "";
  }
}
