/*
 * $Id: Navi.java,v 1.1 2004/06/23 06:36:13 mashu Exp $
 */
package cx.ath.kgslab.wiki.plugin;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;

import java.text.MessageFormat;

import cx.ath.kgslab.wiki.AbstractPageManager;
import cx.ath.kgslab.wiki.exception.PageReadException;
import cx.ath.kgslab.wiki.pages.Page;
import cx.ath.kgslab.wiki.plugin.exception.PluginException;

import org.apache.commons.collections.SequencedHashMap;

import org.apache.oro.text.perl.MalformedPerl5PatternException;
import org.apache.oro.text.perl.Perl5Util;


/**
 * DocBookirQ[Vo[ vOC
 *
 * @author VM
 * @version 1.0 
 *
 * @since JaJaWiki 3.0
 */
public class Navi extends PluginBase {
  /** CfbNXƂėLȍs̐K\p^[ */
  static final String LINE_PATTERN = "/^(-|\\+)(?!-|\\+).*$/";

  /** y[WƂėLȃCfbNX̐K\p^[ */
  static final String LINK_PATTERN =
    "/(?:\\[\\[(?:([^\\]]+)>)?([^\\]]+)\\]\\])" // uPbgl[ N
    + "|((?:[A-Z][a-z]+){2,})/"; // Wikil[ N

  /** irQ[Vo[̃tH[}bg */
  static final MessageFormat NAVI_FORMAT =
    new MessageFormat("<ul class=\"navi\">\n"
      + " <li class=\"navi_left\">{0}</li>\n"
      + " <li class=\"navi_right\">{1}</li>\n"
      + " <li class=\"navi_none\">{2}</li>\n" + "</ul>");

  /**
   * HTML̎擾
   *
   * @return
   *
   * @throws PluginException
   *
   * @see cx.ath.kgslab.wiki.plugin.Plugin#toHTML()
   */
  public String toHTML() throws PluginException {
    String[] params = getParams();
    boolean head = true;
    String indexPage = "";
    String frontPage = config.getFrontPageName();

    if ((params.length <= 0) || (params[0].trim().length() <= 0)) {
      throw new PluginException("1(ڎy[W)͕K{łB");
    } else {
      indexPage = params[0].trim();
    }

    if ((params.length > 1) && (params[1].trim().length() > 0)) {
      if ("head".equalsIgnoreCase(params[1].trim())) {
        head = true;
      } else if ("foot".equalsIgnoreCase(params[1].trim())) {
        head = false;
      } else {
        throw new PluginException(
          "2ɂ́A\"head\"\"foot\"w肵ĂB");
      }
    }

    if ((params.length > 2) && (params[2].trim().length() > 0)) {
      frontPage = params[2].trim();
    }

    try {
      indexPage = AbstractPageManager.parsePath(indexPage, this.page);
      Page page = pageManager.getPage(indexPage);
      String content = page.getContent();
      SequencedHashMap index = createIndexMap(indexPage, content);

      String result = "";

      if (index.containsKey(this.page)) {
        result = createLink(head, indexPage, frontPage, index);
      }

      return result;
    } catch (PageReadException e) {
      throw new PluginException("ڎy[W̓ǂݍ݂Ɏs܂B", e);
    } catch (IOException e) {
      throw new PluginException("ڎy[W̓ǂݍ݂Ɏs܂B", e);
    }
  }

  /**
   * ڎy[W̓eACfbNX𐶐
   *
   * @param indexPage ڎy[W
   * @param content ڎy[W̓e
   *
   * @return CfbNX
   *
   * @throws IOException
   * @throws MalformedPerl5PatternException
   */
  private SequencedHashMap createIndexMap(String indexPage,
    String content)
        throws IOException, MalformedPerl5PatternException {
    LineNumberReader reader =
      new LineNumberReader(new StringReader(content));
    Perl5Util match = new Perl5Util();
    String line = null;
    SequencedHashMap result = new SequencedHashMap();

    while ((line = reader.readLine()) != null) {
      if (match.match(LINE_PATTERN, line)) {
        line = match.group(0);
        if (match.match(LINK_PATTERN, line)) {
          String alias = match.group(1);
          String bname = match.group(2);
          String wname = match.group(3);

          if ((bname != null) && (bname.length() > 0)) {
            bname = AbstractPageManager.parsePath(bname, indexPage);
            if ((alias == null) || (alias.length() <= 0)) {
              alias = bname;
            }

            result.put(bname, alias);
          } else if ((wname != null) && (wname.length() > 0)) {
            result.put(wname, wname);
          }
        }
      }
    }

    return result;
  }

  /**
   * CfbNXɃirQ[Vo[𐶐
   *
   * @param head wb_ǂ
   * @param indexPage CfbNXy[W
   * @param frontPage z[y[W
   * @param index CfbNX
   *
   * @return irQ[Vo[HTML
   */
  private String createLink(boolean head, String indexPage,
    String frontPage, SequencedHashMap index)
        throws UnsupportedEncodingException {
    String result;
    int idx = index.indexOf(this.page);
    String prev = null;
    String next = null;

    if (idx > 0) {
      prev = (String)index.get(idx - 1);
    }

    if (idx < (index.size() - 1)) {
      next = (String)index.get(idx + 1);
    }

    String prevLink = "";
    String nextLink = "";

    if (prev != null) {
      prevLink = converter.processLinkBraketName("Prev", prev);
    } else {
      prevLink = "&nbsp;";
    }

    if (next != null) {
      nextLink = converter.processLinkBraketName("Next", next);
    } else {
      nextLink = "&nbsp;";
    }

    if (head) {
      result =
        NAVI_FORMAT.format(new Object[] {
            prevLink,
            nextLink,
            converter.processLinkBraketName(indexPage, indexPage)
          }) + "<hr class=\"full_hr\"/>";
    } else {
      if (prev != null) {
        prevLink =
          prevLink + "<br />"
          + converter.processLinkBraketName((String)index.get(prev),
            prev);
      } else {
        prevLink = "&nbsp;<br />&nbsp;";
      }

      if (next != null) {
        nextLink =
          nextLink + "<br />"
          + converter.processLinkBraketName((String)index.get(next),
            next);
      } else {
        nextLink = "&nbsp;<br />&nbsp;";
      }

      result =
        "<hr class=\"full_hr\"/>"
        + NAVI_FORMAT.format(new Object[] {
            prevLink,
            nextLink,
            
          converter.processLinkBraketName("Home", frontPage)
            + "<br />"
            + converter.processLinkBraketName("Up", indexPage),
          });
    }

    return result;
  }

  /**
   * @see cx.ath.kgslab.wiki.plugin.Plugin#getPluginHelp()
   */
  public String getPluginHelp() {
    return "***{0}:DocBookirQ[Vo[\n"
    + " &amp;{0}(ڎy[W[,敪[,Homey[W]]);\n"
    + "&#38;{0}LqƁȀꏊDocBook̃irQ[Vo[}B\n"
    + "PrevANext̃y[W͖ڎy[WɃXgƂďꂽԂɂȂB\n"
    + ":ڎy[W|irQ[VΏۂƂȂy[W̃CfbNXLy[W̖O(K{)\n"
    + ":敪|\o[̎\n" + ":|head:wb_p(ftHg)\n" + ":|foot:tb^p\n"
    + ":Homey[W|HomeɃNy[WBftHgFrontPage\n"
    + "ڎy[ẂAXg(ԍ/ȂƂ)ŝAx1ŁAeWikiNameBracketNamê̂CfbNXƂĈB\n"
    + "ȊO̍śAirQ[V̑ΏۂƂȂȂB\n"
    + "-irQ[Vo[vOĆAubNvfƂĈׂłB\n"
    + "-irQ[Vo[vOĆA̗vf̎qvfɂȂ邱Ƃ͂ł܂B\n"
    + "-irQ[Vo[vOĆA̗vfqvfɂ邱Ƃ͂ł܂B";
  }
}
