/*
 * $Id: PluginBase.java,v 1.1 2004/06/23 06:36:13 mashu Exp $
 */
package cx.ath.kgslab.wiki.plugin;

import java.io.UnsupportedEncodingException;

import java.util.StringTokenizer;

import cx.ath.kgslab.webutil.UserAgentUtil;
import cx.ath.kgslab.wiki.ConvertHtml;
import cx.ath.kgslab.wiki.JaJaWikiConfig;
import cx.ath.kgslab.wiki.PageManager;
import cx.ath.kgslab.wiki.SessionUtil;
import cx.ath.kgslab.wiki.plugin.exception.PluginException;
import cx.ath.kgslab.wiki.struts.form.PluginForm;

import org.apache.commons.validator.GenericValidator;

import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;

import org.springframework.context.ApplicationContext;


/**
 * qT|[gvOC̊{NX
 *
 * @author VM
 * @version 4.0 
 *
 * @since JaJaWiki 1.0
 */
public abstract class PluginBase implements NestPlugin, ActionPlugin,
  InitializingBean, BeanNameAware {
  /** p[^ */
  protected String params = "";

  /** Ώە */
  protected String text = "";

  /** y[W */
  protected String page = "";

  /** Ro[^ */
  protected ConvertHtml converter = null;

  /** AvP[VReLXg */
  protected ApplicationContext context = null;

  /** ReLXgpX */
  protected String contextPath = "";

  /** JaJaWikiݒ */
  protected JaJaWikiConfig config = null;

  /** y[W}l[W */
  protected PageManager pageManager = null;

  /** vOC */
  protected String pluginName = null;

  /** DOCUMENT ME! */
  protected int userAgent = UserAgentUtil.UA_Mozilla;

  /** DOCUMENT ME! */
  protected SessionUtil sessionUtil = null;

  /**
   * BeanNamepluginNameݒ肷B
   * @see org.springframework.beans.factory.BeanNameAware#setBeanName(java.lang.String)
   */
  public void setBeanName(String beanName) {
    pluginName = beanName.substring(Plugin.PREFIX.length());
  }

  /**
   * p[^w肷B
   *
   * @param params p[^
   *
   * @see cx.ath.kgslab.wiki.plugin.Plugin#setParams(java.lang.String)
   */
  public void setParams(String params) {
    this.params = nullToBlank(params);
  }

  /**
   * Ώەw肷B
   *
   * @param text Ώە
   *
   * @see cx.ath.kgslab.wiki.plugin.Plugin#setText(java.lang.String)
   */
  public void setText(String text) {
    this.text = nullToBlank(text);
  }

  /**
   * y[Ww肷B
   *
   * @param page y[W
   *
   * @see cx.ath.kgslab.wiki.plugin.Plugin#setPage(java.lang.String)
   */
  public void setPage(String page) {
    this.page = nullToBlank(page);
  }

  /**
   * null󕶎ɕϊ
   *
   * @param src ϊ
   *
   * @return ϊ
   */
  private String nullToBlank(String src) {
    return (src == null) ? "" : src.trim();
  }

  /**
   * CCvf߂B
   *
   * @param text ϊ
   *
   * @return ϊ
   */
  protected String convert(String text) throws PluginException {
    ConvertHtml converter = (ConvertHtml)context.getBean("converter");

    if ((converter != null) && (text != null)) {
      try {
        converter.setUserAgent(this.userAgent);
        text = converter.convertInline(text.trim());
      } catch (UnsupportedEncodingException e) {
        throw new PluginException(e);
      }
    }

    return text;
  }

  /**
   * HTMLRo[^̐ݒ
   *
   * @param converter
   *
   * @see cx.ath.kgslab.wiki.plugin.NestPlugin#setConverter(cx.ath.kgslab.wiki.ConvertHtml)
   */
  public void setConverter(ConvertHtml converter) {
    this.converter = converter;
  }

  /**
   * vOCANV̎s
   *
   * @param form
   *
   * @throws PluginException vOCŔO
   *
   * @see cx.ath.kgslab.wiki.plugin.Plugin#action(cx.ath.kgslab.wiki.struts.form.PluginForm)
   */
  public void action(PluginForm form) throws PluginException {
    throw new UnsupportedOperationException();
  }

  /**
   * WikiPath̐ݒB
   *
   * @see cx.ath.kgslab.wiki.plugin.ActionPlugin#setWikiPath(java.lang.String)
   */
  public void setWikiPath(String path) {
    // nop
  }

  /**
   * J}؂̃p[^𕪊AzɓĕԂ
   *
   * @return p[^̔z
   */
  public String[] getParams() {
    String[] result = null;

    StringTokenizer tokens = new StringTokenizer(this.params, ",");

    int count = tokens.countTokens();

    if (count > 0) {
      result = new String[count];

      int idx = 0;

      while (tokens.hasMoreTokens()) {
        result[idx] = tokens.nextToken().trim();
        idx++;
      }
    }

    return result;
  }

  /**
   * T[ubgReLXg̐ݒ
   *
   * @param context T[ubgReLXg
   */
  public void setApplicationContext(ApplicationContext context) {
    this.context = context;
  }

  /**
   * vOCp[^̃`FbN(intł邱)
   *
   * @param value `FbNΏۂ̒l
   * @param mess G[bZ[W
   *
   * @throws PluginException G[̏ꍇ́AOԂB
   */
  protected void checkInt(String value, String mess)
        throws PluginException {
    if (!GenericValidator.isInt(value)) {
      throw new PluginException(mess);
    }
  }

  /**
   * ReLXgpX̐ݒ
   *
   * @param path ReLXgpX
   */
  public void setContextPath(String path) {
    contextPath = nullToBlank(path);
  }

  /**
   * vpeBݒ̏
   *
   * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
   */
  public final void afterPropertiesSet() throws Exception {
    pageManager = (PageManager)context.getBean("pageManager");
    config = (JaJaWikiConfig)context.getBean("config");
    init();
  }

  /**
   * .
   * <br>
   * vpeB̐ݒɎsB
   */
  public void init() throws Exception {
  }

  /**
   * @return
   */
  public int getUserAgent() {
    return userAgent;
  }

  /**
   * @param i
   */
  public void setUserAgent(int i) {
    userAgent = i;
  }

  /**
   * @see cx.ath.kgslab.wiki.plugin.Plugin#getSessionUtil()
   */
  public SessionUtil getSessionUtil() {
    return sessionUtil;
  }

  /**
   * @see cx.ath.kgslab.wiki.plugin.Plugin#setSessionUtil(cx.ath.kgslab.wiki.SessionUtil)
   */
  public void setSessionUtil(SessionUtil util) {
    sessionUtil = util;
  }

  /**
   * @param url
   * @return
   */
  public String encodeRedirectURL(String url) {
    if (sessionUtil != null) {
      return sessionUtil.encodeRedirectURL(url);
    } else {
      return url;
    }
  }

  /**
   * @param url
   * @return
   */
  public String encodeURL(String url) {
    if (sessionUtil != null) {
      return sessionUtil.encodeURL(url);
    } else {
      return url;
    }
  }
}
