/*
 * 쐬: 2004/03/08
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
package cx.ath.kgslab.wiki.plugin;

import java.text.MessageFormat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import cx.ath.kgslab.wiki.ConvertHtml;
import cx.ath.kgslab.wiki.plugin.exception.PluginException;

import org.springframework.beans.BeansException;


/**
 * vOCwv\vOC
 *
 * @author VM
 */
public class PluginHelp extends PluginBase {
  /** wvy[W */
  String help = null;

  /**
   * @see cx.ath.kgslab.wiki.plugin.Plugin#toHTML()
   */
  public String toHTML() throws PluginException {
    return help;
  }

  /**
   * wvy[W쐬B
   * evOC̃wvAāA
   * wvy[W쐬B
   *
   * @return wvy[W
   *
   * @throws PluginException DOCUMENT ME!
   */
  private String createPluginHelpPage() throws PluginException {
    StringBuffer result = new StringBuffer();

    try {
      List plugins = getPlugins();
      Iterator ite = plugins.iterator();

      while (ite.hasNext()) {
        String pluginName = (String)ite.next();
        String helpMessage = getPluginHelp(pluginName);

        if ((helpMessage != null) && (helpMessage.length() > 0)) {
          result.append(helpMessage);
          result.append("\n");
        }
      }

      return result.toString();
    } catch (BeansException e) {
      throw new PluginException("PluginXg̎擾Ɏs܂B", e);
    }
  }

  /**
   * vOCwv̎擾B
   * w肵ÕvOCAwv擾B
   *
   * @param pluginName vOC
   *
   * @return wv
   *
   * @throws BeansException DOCUMENT ME!
   */
  private String getPluginHelp(String pluginName)
        throws BeansException {
    Plugin plugin = (Plugin)this.context.getBean(pluginName);

    String helpMessage = plugin.getPluginHelp();

    if ((helpMessage != null) && (helpMessage.length() > 0)) {
      String text = pluginName.substring(Plugin.PREFIX.length());

      helpMessage =
        new MessageFormat(helpMessage).format(new Object[] {
            text
          });
    }

    return helpMessage;
  }

  /**
   * vOC̃Xg擾B
   *
   * @return vOCXg
   *
   * @throws BeansException DOCUMENT ME!
   */
  private List getPlugins() throws BeansException {
    String[] array = this.context.getBeanDefinitionNames();

    Arrays.sort(array);
    List beans = Arrays.asList(array);
    Iterator ite = beans.iterator();
    List plugins = new ArrayList(100);

    while (ite.hasNext()) {
      String beanName = (String)ite.next();

      if (beanName.startsWith(Plugin.PREFIX)) {
        plugins.add(beanName);
      }
    }

    return plugins;
  }

  /**
   * @see cx.ath.kgslab.wiki.plugin.Plugin#getPluginHelp()
   */
  public String getPluginHelp() {
    return "";
  }

  /**
   * @see cx.ath.kgslab.wiki.plugin.PluginBase#init()
   */
  public void init() throws Exception {
    ConvertHtml converter = (ConvertHtml)context.getBean("converter");

    help = converter.convert(createPluginHelpPage());
    converter = null;
  }
}
