/*
 * $Id: WhiteBoard.java,v 1.1 2004/06/23 06:36:13 mashu Exp $
 */
package cx.ath.kgslab.wiki.plugin;

import java.text.MessageFormat;

import cx.ath.kgslab.wiki.plugin.exception.*;


/**
 * G`ăy[WɓYt邱ƂłvOC
 *
 * @author VM
 * @version 1.0 
 *
 * @since JaJaWiki 4.0
 */
public class WhiteBoard extends Applet {
  /** DOCUMENT ME! */
  static final String JAR_FILE = "SVGEditor.jar";

  /**
   * @see java.lang.Object#toString()
   */
  public String toHTML() throws PluginException {
    String[] params = this.getParams();
    String width = "640";
    String height = "480";
    String name = "default";
    String compress = "false";

    if ((this.text == null) || (this.text.length() <= 0)) {
      this.text = "ɂGAvbg\͂ł";
    }

    if (params != null) {
      for (int i = 1; (i < params.length) && (i < 2); i++) {
        if (i == 0) {
          name = params[0];
        }

        if (i == 1) {
          compress = params[1];
        }

        if (i == 2) {
          width = params[2];
        }

        if (i == 3) {
          height = params[3];
        }
      }
    }

    MessageFormat format =
      new MessageFormat(
        "{0},cx.ath.kgslab.svgeditor.MainApplet,false,{1},{2},"
        + "page:{3},name:{4},compress:{5},"
        + "param1:overwrite=true,param2:submit=M");

    this.setParams(format.format(
        new Object[] {
          JAR_FILE,
          width,
          height,
          this.page,
          name,
          compress,
        }));
    try {
      return super.toHTML();
    } catch (JarNotFoundException e) {
      throw new JarNotFoundException(JAR_FILE + "ReLXg̃[gɑ݂܂B",
        e);
    }
  }

  /**
   * @see cx.ath.kgslab.wiki.plugin.Plugin#getPluginHelp()
   */
  public String getPluginHelp() {
    return "***{0}:zCg{[h(SVG}ҏWAvbg\) \n"
    + " &amp;{0}([t@C(gq)][,[ktO][,[][,[]]]]);\n"
    + "Wikiɐ}ҏW@\tvOCłB\n" + "}ҏW@\Java AppletƂĎĂA\n"
    + "vOC̓AvbgWikiɓ\t@\Ă܂B\n"
    + ":t@C|쐬}WikiɓYtۂ̃t@Cw肵܂B"
    + ":|t@Cw肵Ȃ΁A\"default\"t@CɎgp܂B\n"
    + ":|gq͊܂܂ȂłBʏAۑt@C̊gq\".svg\"ɂȂ܂B\n"
    + ":ktO|ktOtruew肷ƁASVGt@CGZIPkĕۑ܂B\n"
    + ":|ۑt@C̊gq\".svgz\"ɂȂ܂B\n"
    + ":A|}̃TCYłȂAAvbg̃TCYɂȂ܂B\n"
    + "-zCg{[hvOĆACCvfƂĈׂłB\n"
    + "-zCg{[hvOĆA̗vf̎qvfɂȂ邱Ƃł܂B\n"
    + "-zCg{[hvOĆA̗vfqvfɂ邱Ƃ͂ł܂B";
  }
}
