/*
 * $Id: AmazonHandler.java,v 1.1 2004/06/23 06:36:14 mashu Exp $
 */
package cx.ath.kgslab.wiki.plugin.amazon;

import java.util.ArrayList;
import java.util.List;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;


/**
 * Amazon WebT[rXgpĎ擾łA
 * iXML(Lite)ǂݎāA
 * ProductionInfoɕϊB
 *
 * @author VM
 */
public class AmazonHandler extends DefaultHandler {
  /** DOCUMENT ME! */
  private ProductionInfo info = null;

  /** DOCUMENT ME! */
  private StringBuffer buf = null;

  /** DOCUMENT ME! */
  private List infos = new ArrayList();

  /**
   * @return
   */
  public List getInfos() {
    return infos;
  }

  /**
   * @see org.xml.sax.ContentHandler#startElement(java.lang.String, java.lang.String, java.lang.String, org.xml.sax.Attributes)
   */
  public void startElement(String uri, String localName,
    String qName, Attributes attributes) throws SAXException {
    if ("Details".equals(qName)) {
      info = new ProductionInfo();
      info.setUrl(attributes.getValue("url"));
      infos.add(info);
    } else if ("Asin".equals(qName) || "ProductName".equals(qName)
        || "Catalog".equals(qName) || "Artist".equals(qName)
        || "Author".equals(qName) || "ReleaseDate".equals(qName)
        || "Manufacturer".equals(qName)
        || "ImageUrlSmall".equals(qName)
        || "ImageUrlMedium".equals(qName)
        || "ImageUrlLarge".equals(qName)) {
      buf = new StringBuffer();
    }
  }

  /**
   * @see org.xml.sax.ContentHandler#characters(char[], int, int)
   */
  public void characters(char[] ch, int start, int length)
        throws SAXException {
    if (buf != null) {
      buf.append(ch, start, length);
    }
  }

  /**
   * @see org.xml.sax.ContentHandler#endElement(java.lang.String, java.lang.String, java.lang.String)
   */
  public void endElement(String uri, String localName, String qName)
        throws SAXException {
    if ("Asin".equals(qName)) {
      info.setAsin(buf.toString());
    } else if ("ProductName".equals(qName)) {
      info.setProductName(buf.toString());
    } else if ("Catalog".equals(qName)) {
      info.setCatalog(buf.toString());
    } else if ("Artist".equals(qName)) {
      info.addArtist(buf.toString());
    } else if ("Author".equals(qName)) {
      info.addAuthor(buf.toString());
    } else if ("ReleaseDate".equals(qName)) {
      info.setReleaseDate(buf.toString());
    } else if ("Manufacturer".equals(qName)) {
      info.setManufacturer(buf.toString());
    } else if ("ImageUrlSmall".equals(qName)) {
      info.setImageUrlSmall(buf.toString());
    } else if ("ImageUrlMedium".equals(qName)) {
      info.setImageUrlMedium(buf.toString());
    } else if ("ImageUrlLarge".equals(qName)) {
      info.setImageUrlLarge(buf.toString());
    }
  }
}
