/*
 * $Id: DeleteAction.java,v 1.1 2004/06/23 06:36:14 mashu Exp $
 */
package cx.ath.kgslab.wiki.struts.action;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cx.ath.kgslab.webutil.struts.LookupDispatchActionSupport;
import cx.ath.kgslab.wiki.AbstractPageManager;
import cx.ath.kgslab.wiki.JaJaWikiConfig;
import cx.ath.kgslab.wiki.PageManager;
import cx.ath.kgslab.wiki.exception.PageLockedException;
import cx.ath.kgslab.wiki.exception.PageReadException;
import cx.ath.kgslab.wiki.pages.Page;
import cx.ath.kgslab.wiki.struts.form.PageForm;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import org.springframework.web.context.WebApplicationContext;


/**
 * JaJaWikĩy[W폜ANV
 *
 * @author VM
 * @version 3.0 
 *
 * @since JaJaWiki 1.0
 */
public class DeleteAction extends LookupDispatchActionSupport {
  /**
   * @see org.apache.struts.actions.LookupDispatchAction#getKeyMethodMap()
   */
  protected Map getKeyMethodMap() {
    Map result = new HashMap();

    result.put("view.yes", "delete");
    result.put("view.no", "cancel");

    return result;
  }

  /**
   * Method execute
   *
   * @param mapping mapping
   * @param form form
   * @param request request
   * @param response response
   *
   * @return ActionForward
   *
   * @throws Exception
   * @throws PageLockedException DOCUMENT ME!
   */
  public ActionForward delete(ActionMapping mapping, ActionForm form,
    HttpServletRequest request, HttpServletResponse response)
        throws Exception {
    PageForm deleteForm = (PageForm)form;
    String page = deleteForm.getPage();

    //String path = deleteForm.getPath();
    ServletContext servletContext = this.servlet.getServletContext();
    WebApplicationContext context = this.getWebApplicationContext();

    PageManager pm = (PageManager)context.getBean("pageManager");
    Page info = null;
    String submit = (String)deleteForm.getCommand();

    boolean exists = false;

    try {
      exists = pm.existsPage(page);
    } catch (PageReadException e) {
    }

    if (exists) {
      info = pm.getPage(page);
			String lockPassword = (String)deleteForm.getLockPassword();
			if (!pm.checkLockPassword(info, lockPassword)) {
				// pX[hԈĂ΁AҏWy[Wɖ߂Ay[WbNĂ邱ƂʒmB
				throw new PageLockedException();
			}
      pm.deletePage(info);
    } else {
      info = new Page();
      AbstractPageManager.parsePagePath(page, info);
    }


    String path = info.getPath();

    if ((path != null) && (path.length() > 0)) {
      deleteForm.setPage(path);
    } else {
			JaJaWikiConfig config = (JaJaWikiConfig)context.getBean("config");
      deleteForm.setPage(config.getFrontPageName());
    }

    return mapping.findForward("reload");
  }

  /**
   * @see org.apache.struts.action.Action#execute(org.apache.struts.action.ActionMapping,
   *      org.apache.struts.action.ActionForm,
   *      javax.servlet.http.HttpServletRequest,
   *      javax.servlet.http.HttpServletResponse)
   */
  public ActionForward cancel(ActionMapping mapping, ActionForm form,
    HttpServletRequest arg2, HttpServletResponse response)
        throws Exception {
    return mapping.findForward("returnEdit");
  }
}
