/*
 * $Id: DispatchAction.java,v 1.1 2004/06/23 06:36:14 mashu Exp $
 */
package cx.ath.kgslab.wiki.struts.action;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cx.ath.kgslab.webutil.struts.LookupDispatchActionSupport;
import cx.ath.kgslab.wiki.AbstractPageManager;
import cx.ath.kgslab.wiki.PageManager;
import cx.ath.kgslab.wiki.exception.FieldEmptyException;
import cx.ath.kgslab.wiki.exception.PageLockedException;
import cx.ath.kgslab.wiki.exception.PageModifiedException;
import cx.ath.kgslab.wiki.exception.PageReadException;
import cx.ath.kgslab.wiki.exception.PageWriteException;
import cx.ath.kgslab.wiki.exception.PathNotFoundException;
import cx.ath.kgslab.wiki.pages.Page;
import cx.ath.kgslab.wiki.struts.form.PageForm;

import org.apache.oro.text.perl.MalformedPerl5PatternException;
import org.apache.oro.text.perl.Perl5Util;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import org.springframework.web.context.WebApplicationContext;


/**
 * ҏWU蕪ANV
 *
 * @author VM
 * @version 1.0 
 *
 * @since JaJaWiki 4.0
 */
public class DispatchAction extends LookupDispatchActionSupport {
  /** tB^ */
  static final String[] FILTER =
    new String[] {
      "s/<([^<>]*)>/&lt;$1&gt;/g",
    };

  /**
   * @see org.apache.struts.actions.LookupDispatchAction#getKeyMethodMap()
   */
  protected Map getKeyMethodMap() {
    Map result = new HashMap();

    result.put("view.commit", "commit");
    result.put("view.preview", "preview");
    result.put("view.rename", "rename");
    result.put("view.delete", "delete");
    result.put("view.showHelp", "showHelp");
    result.put("view.hideHelp", "hideHelp");
    result.put("view.cancel", "cancel");

    return result;
  }

  /**
   * @see org.apache.struts.action.Action#execute(org.apache.struts.action.ActionMapping,
   *      org.apache.struts.action.ActionForm,
   *      javax.servlet.http.HttpServletRequest,
   *      javax.servlet.http.HttpServletResponse)
   */
  public ActionForward commit(ActionMapping mapping, ActionForm form,
    HttpServletRequest request, HttpServletResponse response)
        throws Exception {
    PageForm registForm = (PageForm)form;
    PageManager pm = getPageManager();
    Page info = getPage(registForm, pm);
    String contents = registForm.getContents();

    checkField(mapping, contents);

    checkLastModified(registForm, info);

    // ͒̃^O炵̂&gt;&lt;ɕϊĖɂB
    contents = spoilTag(contents);

    info.setContent(contents);
    info.setConvertedPage("");

    // y[Wۑ
    pm.putPage(info);

    return mapping.findForward("reload");
  }

  /**
   * @see org.apache.struts.action.Action#execute(org.apache.struts.action.ActionMapping,
   *      org.apache.struts.action.ActionForm,
   *      javax.servlet.http.HttpServletRequest,
   *      javax.servlet.http.HttpServletResponse)
   */
  public ActionForward preview(ActionMapping mapping,
    ActionForm form, HttpServletRequest request,
    HttpServletResponse response) throws Exception {
    return mapping.findForward("preview");
  }

  /**
   * @see org.apache.struts.action.Action#execute(org.apache.struts.action.ActionMapping,
   *      org.apache.struts.action.ActionForm,
   *      javax.servlet.http.HttpServletRequest,
   *      javax.servlet.http.HttpServletResponse)
   */
  public ActionForward cancel(ActionMapping mapping, ActionForm form,
    HttpServletRequest arg2, HttpServletResponse response)
        throws Exception {
    return mapping.findForward("returnEdit");
  }

  /**
   * @see org.apache.struts.action.Action#execute(org.apache.struts.action.ActionMapping,
   *      org.apache.struts.action.ActionForm,
   *      javax.servlet.http.HttpServletRequest,
   *      javax.servlet.http.HttpServletResponse)
   */
  public ActionForward rename(ActionMapping mapping, ActionForm form,
    HttpServletRequest request, HttpServletResponse response)
        throws Exception {
    getPage(form, getPageManager());

    return mapping.findForward("rename");
  }

  /**
   * @see org.apache.struts.action.Action#execute(org.apache.struts.action.ActionMapping,
   *      org.apache.struts.action.ActionForm,
   *      javax.servlet.http.HttpServletRequest,
   *      javax.servlet.http.HttpServletResponse)
   */
  public ActionForward delete(ActionMapping mapping, ActionForm form,
    HttpServletRequest request, HttpServletResponse response)
        throws Exception {
    getPage(form, getPageManager());

    return mapping.findForward("delete");
  }

  /**
   * @see org.apache.struts.action.Action#execute(org.apache.struts.action.ActionMapping,
   *      org.apache.struts.action.ActionForm,
   *      javax.servlet.http.HttpServletRequest,
   *      javax.servlet.http.HttpServletResponse)
   */
  public ActionForward showHelp(ActionMapping mapping,
    ActionForm form, HttpServletRequest request,
    HttpServletResponse response) throws Exception {
    PageForm registForm = (PageForm)form;

    registForm.setHelp(true);

    return mapping.findForward("returnEdit");
  }

  /**
   * @see org.apache.struts.action.Action#execute(org.apache.struts.action.ActionMapping,
   *      org.apache.struts.action.ActionForm,
   *      javax.servlet.http.HttpServletRequest,
   *      javax.servlet.http.HttpServletResponse)
   */
  public ActionForward hideHelp(ActionMapping mapping,
    ActionForm form, HttpServletRequest request,
    HttpServletResponse response) throws Exception {
    PageForm registForm = (PageForm)form;

    registForm.setHelp(false);

    return mapping.findForward("returnEdit");
  }

  /**
   * y[W̎擾
   *
   * @param form tH[
   * @param pm y[W}l[W
   *
   * @return y[W
   *
   * @throws PageReadException
   * @throws PageLockedException
   * @throws PathNotFoundException
   * @throws PageWriteException
   */
  private Page getPage(ActionForm form, PageManager pm)
        throws PageReadException, PageLockedException, 
          PathNotFoundException, PageWriteException {
    PageForm registForm = (PageForm)form;

    String contents = registForm.getContents();
    String page = registForm.getPage();

    if (page != null) {
      page = page.trim();
    }

    Page info = null;

    if (pm.existsPage(page)) {
      info = pm.getPage(page);
      checkPageLock(pm, registForm, info);
    } else {
      info = new Page();
      AbstractPageManager.parsePagePath(page, info);
      String path = info.getPath();

      if ((path != null) && (path.length() > 0) && !".".equals(path)) {
        if (pm.existsPage(path)) {
          Page parent = pm.getPage(path);

          parent.addChild(info.getTitle());
          pm.putPage(parent);
        } else {
          // G[@pXȂ
          throw new PathNotFoundException("pX܂B (" + path
            + ")");
        }
      }
    }

    return info;
  }

  /**
   * y[W}l[W̎擾
   *
   * @return y[W}l[W
   */
  private PageManager getPageManager() {
    ServletContext servletContext = this.servlet.getServletContext();
    WebApplicationContext context = this.getWebApplicationContext();

    PageManager pm = (PageManager)context.getBean("pageManager");

    return pm;
  }

  /**
   * y[WbN`FbN
   *
   * @param pm y[W}l[W
   * @param registForm tH[
   * @param info y[W
   *
   * @throws PageLockedException y[WbNO
   */
  private void checkPageLock(PageManager pm, PageForm registForm,
    Page info) throws PageLockedException {
    boolean lock = registForm.isLock();

    //System.out.println("regist lock : " + boTemp);
    String lockPassword = registForm.getLockPassword();

    boolean locked = info.getLocked();

    if (locked) {
      // y[WbNĂꍇ
      if (!pm.checkPassword(info, lockPassword)) {
        // pX[hԈĂ΁AҏWy[Wɖ߂Ay[WbNĂ邱ƂʒmB
        throw new PageLockedException();
      }

      if (!lock) {
        // y[WbN`FbN{bNX`FbNĂȂ΁Ay[WbNB
        info.setLocked(false);
      }
    } else {
      // y[WbNĂȂꍇ
      if (lock) {
        // y[WbN`FbN{bNX`FbNĂ΁Ay[WbNB
        info.setLocked(true);
        info.setPassword(lockPassword);
      }
    }
  }

  /**
   * ͒̃^O炵̂&amp;gt;&amp;lt;ɕϊĖɂB
   *
   * @param contents ϊ
   *
   * @return ϊ
   *
   * @throws MalformedPerl5PatternException
   */
  private String spoilTag(String contents)
        throws MalformedPerl5PatternException {
    Perl5Util util = new Perl5Util();

    for (int i = 0; i < FILTER.length; i++) {
      contents = util.substitute(FILTER[i], contents);
    }

    return contents;
  }

  /**
   * ŏIXV`FbN
   *
   * @param registForm tH[
   * @param info y[W
   *
   * @throws PageModifiedException y[WҏWςݗO
   */
  private void checkLastModified(PageForm registForm, Page info)
        throws PageModifiedException {
    long lastModified = registForm.getLastModified();

    if ((info.getLastModified() != null) && (lastModified > 0)
        && (lastModified != info.getLastModified().getTime())) {
      //      servlet.log("lastModified : "
      //        + pm.getPage(path, page).getLastModified().getTime());
      // t@CAҏWJnύXĂƂA\?
      throw new PageModifiedException();
    }
  }

  /**
   * tB[h`FbN
   *
   * @param mapping ANV}bsO
   * @param contents e
   *
   * @throws FieldEmptyException y[Weœo^悤ƂĂB
   */
  private void checkField(ActionMapping mapping, String contents)
        throws FieldEmptyException {
    ActionForward result = null;

    if ((contents == null) || (contents.trim().length() <= 0)) {
      throw new FieldEmptyException();
    }
  }
}
