/*
 * $Id: EditAction.java,v 1.1 2004/06/23 06:36:14 mashu Exp $
 */
package cx.ath.kgslab.wiki.struts.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cx.ath.kgslab.wiki.AbstractPageManager;
import cx.ath.kgslab.wiki.PageManager;
import cx.ath.kgslab.wiki.pages.Page;
import cx.ath.kgslab.wiki.struts.form.PageForm;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.struts.ActionSupport;


/**
 * JaJaWiki̕ҏW[h\ANV
 *
 * @author VM
 * @version 3.0 
 *
 * @since JaJaWiki 1.0
 */
public class EditAction extends ActionSupport {
  /**
   * Method execute
   *
   * @param mapping mapping
   * @param form form
   * @param request request
   * @param response response
   *
   * @return ActionForward
   *
   * @throws Exception
   */
  public ActionForward execute(ActionMapping mapping,
    ActionForm form, HttpServletRequest request,
    HttpServletResponse response) throws Exception {
    PageForm editForm = (PageForm)form;
    String page = editForm.getPage();

    editForm.setLock(false);

    if (!"takeContent".equals(editForm.getCommand())) {
      editForm.setContents("");
    }

    editForm.setCommand("");

    String path = editForm.getPrevPage();

    if ((page == null) || (page.trim().length() <= 0)) {
      page = path;
    } else if (editForm.isChild()) {
      page = AbstractPageManager.concatPath(path, page);
    }

    editForm.setPrevPage("");
    editForm.setChild(false);

    if ((page != null) && (page.length() > 0)) {
      // y[Ww肳Ă΁Ãy[WҏW
      WebApplicationContext context = this.getWebApplicationContext();

      PageManager pm = (PageManager)context.getBean("pageManager");

      if (pm.existsPage(page)) {
        // y[Wt@C΁A̓eҏW
        Page info = pm.getPage(page);

        editForm.setLock(info.getLocked());
        editForm.setPage(page);
        editForm.setContents(info.getContent());
        editForm.setLastModified(info.getLastModified().getTime());
      } else {
        // y[Wt@CȂ΁AVKɏ
        editForm.setPage(page);
        editForm.setLastModified(-1L);
      }
    } else {
      // y[Ww肳ĂȂ΁AVKy[W쐬ʂ֔
      editForm.setPage("");
      editForm.setLastModified(-1L);

      return mapping.findForward("create");
    }

    // ҏWʂ֔
    return mapping.findForward("success");
  }
}
