/*
 * $Id: RenameAction.java,v 1.1 2004/06/23 06:36:14 mashu Exp $
 */
package cx.ath.kgslab.wiki.struts.action;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cx.ath.kgslab.webutil.struts.LookupDispatchActionSupport;
import cx.ath.kgslab.wiki.AbstractPageManager;
import cx.ath.kgslab.wiki.exception.PageLockedException;
import cx.ath.kgslab.wiki.exception.PageNotFoundException;
import cx.ath.kgslab.wiki.pages.Page;
import cx.ath.kgslab.wiki.struts.form.PageForm;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import org.springframework.web.context.WebApplicationContext;


/**
 * y[WύXANV
 *
 * @author VM
 * @version 3.0 
 *
 * @since JaJaWiki 1.0
 */
public class RenameAction extends LookupDispatchActionSupport {
  /**
   * @see org.apache.struts.actions.LookupDispatchAction#getKeyMethodMap()
   */
  protected Map getKeyMethodMap() {
    Map result = new HashMap();

    result.put("view.rename.submit", "rename");
    result.put("view.cancel", "cancel");

    return result;
  }

  /**
   * Method execute
   *
   * @param mapping mapping
   * @param form form
   * @param request request
   * @param response response
   *
   * @return ActionForward
   *
   * @throws Exception
   * @throws PageNotFoundException
   * @throws PageLockedException
   */
  public ActionForward rename(ActionMapping mapping, ActionForm form,
    HttpServletRequest request, HttpServletResponse response)
        throws Exception {
    PageForm renameForm = (PageForm)form;
    String srcName = renameForm.getPrevPage();
    String dstName = renameForm.getPage();

    ServletContext servletContext = this.servlet.getServletContext();
    WebApplicationContext context = this.getWebApplicationContext();

    AbstractPageManager pm =
      (AbstractPageManager)context.getBean("pageManager");
    Page src = null;

    if (pm.existsPage(srcName)) {
      src = pm.getPage(srcName);
    } else {
      throw new PageNotFoundException();
    }

    String lockPassword = (String)renameForm.getLockPassword();
    boolean locked = src.getLocked();

    if (!pm.checkLockPassword(src, lockPassword)) {
      // pX[hԈĂ΁AҏWy[Wɖ߂Ay[WbNĂ邱ƂʒmB
      throw new PageLockedException();
    }

    pm.renamePage(srcName, dstName);

    return mapping.findForward("reload");
  }

  /**
   * @see org.apache.struts.action.Action#execute(org.apache.struts.action.ActionMapping,
   *      org.apache.struts.action.ActionForm,
   *      javax.servlet.http.HttpServletRequest,
   *      javax.servlet.http.HttpServletResponse)
   */
  public ActionForward cancel(ActionMapping mapping, ActionForm form,
    HttpServletRequest arg2, HttpServletResponse response)
        throws Exception {
    return mapping.findForward("returnEdit");
  }
}
