/*
 * $Id: ChildrenTag.java,v 1.1 2004/06/23 06:36:14 mashu Exp $
 */
package cx.ath.kgslab.wiki.taglib;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.struts.util.RequestUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import cx.ath.kgslab.webutil.ContextPathUtils;
import cx.ath.kgslab.webutil.UserAgentUtil;
import cx.ath.kgslab.wiki.AbstractPageManager;
import cx.ath.kgslab.wiki.ConvertHtml;
import cx.ath.kgslab.wiki.JaJaWikiConfig;
import cx.ath.kgslab.wiki.PageManager;
import cx.ath.kgslab.wiki.SessionUtilImpl;
import cx.ath.kgslab.wiki.exception.PageReadException;
import cx.ath.kgslab.wiki.pages.Page;
import cx.ath.kgslab.wiki.struts.form.PageForm;


/**
 * z̃y[W(qy[W)\B
 *
 * @author VM
 * @version 3.0 
 *
 * @since JaJaWiki 3.0
 */
public class ChildrenTag extends TagSupport {
  /** y[W */
  String page = null;

  /**
   * ^O
   *
   * @return
   *
   * @throws JspException
   *
   * @see javax.servlet.jsp.tagext.Tag#doEndTag()
   */
  public int doEndTag() throws JspException {
    WebApplicationContext context =
      WebApplicationContextUtils.getRequiredWebApplicationContext(this.pageContext
        .getServletContext());
    JaJaWikiConfig config = (JaJaWikiConfig)context.getBean("config");

    HttpServletRequest request =
      (HttpServletRequest)pageContext.getRequest();

    if ((page == null) || (page.length() <= 0)) {
      PageForm form =
        (PageForm)RequestUtils.lookup(pageContext, "form", null);

      if (form != null) {
        page = form.getPage();
      } else {
        page = request.getParameter("page");
      }

      if ((page == null) || (page.length() <= 0)) {
        page = config.getFrontPageName();
      }
    }

    try {
      PageManager pm = (PageManager)context.getBean("pageManager");
      Page info = pm.getPage(page);

      //PrintWriter out = new PrintWriter(this.pageContext.getOut());
      Iterator ite = info.getChild().iterator();

      ConvertHtml conv = (ConvertHtml)context.getBean("converter");
      String ua = request.getHeader("User-Agent");

      conv.setUserAgent(UserAgentUtil.checkUserAgent(ua));

      conv.setLocale(request.getLocale());
      conv.setSessionUtil(new SessionUtilImpl(
          (HttpServletResponse)pageContext.getResponse()));

      conv.setContextPath(ContextPathUtils.getPath(request));
      conv.setPage(page);

      StringBuffer buf = new StringBuffer(1024);
      boolean first = true;

      while (ite.hasNext()) {
        String child = (String)ite.next();

        if (child != null) {
          if (!first) {
            buf.append(", ");
          }

          buf.append(conv.processLinkBraketName(child,
              AbstractPageManager.concatPath(page, child)));
          first = false;
        }
      }

      if (!first) {
				this.pageContext.getOut().println(buf.toString().trim());
      } else {
				this.pageContext.getOut().println("Ȃ");
      }

      page = null;

      return SKIP_BODY;
    } catch (PageReadException e) {
      throw new JspException(e);
    } catch (UnsupportedEncodingException e) {
      throw new JspException(e);
    } catch (IOException e) {
			throw new JspException(e);
    }
  }

  /**
   * y[W̎擾
   *
   * @return
   */
  public String getPage() {
    return page;
  }

  /**
   * y[W̐ݒ
   *
   * @param string
   */
  public void setPage(String string) {
    page = string;
  }
}
