/*
 * $Id: InsertTag.java,v 1.1 2004/06/23 06:36:14 mashu Exp $
 */
package cx.ath.kgslab.wiki.taglib;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.support.WebApplicationContextUtils;

import cx.ath.kgslab.webutil.ContextPathUtils;
import cx.ath.kgslab.webutil.UserAgentUtil;
import cx.ath.kgslab.wiki.AbstractPageManager;
import cx.ath.kgslab.wiki.ConvertHtml;
import cx.ath.kgslab.wiki.JaJaWikiConfig;
import cx.ath.kgslab.wiki.PageManager;
import cx.ath.kgslab.wiki.SessionUtil;
import cx.ath.kgslab.wiki.SessionUtilImpl;
import cx.ath.kgslab.wiki.exception.PageReadException;
import cx.ath.kgslab.wiki.pages.Page;
import cx.ath.kgslab.wiki.plugin.NestPlugin;
import cx.ath.kgslab.wiki.plugin.exception.PluginException;


/**
 * Wikiy[W}^O
 *
 * @author VM
 * @version 3.0
 *
 * @since JaJaWiki 1.0
 */
public class InsertTag extends TagSupport implements NestPlugin,
  ApplicationContextAware, InitializingBean {
  /** y[W */
  protected String page = "";

  /** ̃y[W */
  protected String thisPage = "";

  /** HTMLRo[^ */
  protected ConvertHtml converter = null;

  /** y[W}l[W */
  protected PageManager pageManager = null;

  /** ReLXg */
  protected ApplicationContext context = null;

  /** DOCUMENT ME! */
  protected int userAgent = UserAgentUtil.UA_Mozilla;

  /** DOCUMENT ME! */
  protected SessionUtil sessionUtil = null;

  /**
   * ^Ȍ
   *
   * @see javax.servlet.jsp.tagext.Tag#doStartTag()
   */
  public int doStartTag() throws JspException {
    //PrintWriter out = new PrintWriter(this.pageContext.getOut());
    HttpServletRequest request =
      (HttpServletRequest)pageContext.getRequest();

    context =
      WebApplicationContextUtils.getRequiredWebApplicationContext(this.pageContext
        .getServletContext());
    JaJaWikiConfig config = (JaJaWikiConfig)context.getBean("config");

    init();
    converter = (ConvertHtml)context.getBean("converter");
    String ua = request.getHeader("User-Agent");

    converter.setUserAgent(UserAgentUtil.checkUserAgent(ua));
    converter.setLocale(request.getLocale());

    converter.setContextPath(ContextPathUtils.getPath(request));
    this.setSessionUtil(new SessionUtilImpl(
        (HttpServletResponse)pageContext.getResponse()));
    converter.setSessionUtil(sessionUtil);

    // y[Ww̏ꍇ́AFrontPage\B
    if ((page == null) || ((page = page.trim()).length() <= 0)) {
      page = config.getFrontPageName();
    }

    //    PageForm form =
    //      (PageForm)RequestUtils.lookup(pageContext, "form", null);
    //    if (form != null) {
    //      thisPage = form.getPage();
    //    } else {
    thisPage = request.getParameter("page");

    //    }
    converter.setPage(thisPage);
    try {
      try {
        this.pageContext.getOut().println(this.toHTML());
      } catch (PluginException e) {
        this.pageContext.getOut().println("<span class=\"errormsg\">"
          + e.getMessage() + "</span>");
        this.pageContext.getServletContext().log("InsertTag ̗O", e);
      }
    } catch (IOException e1) {
      throw new JspException(e1);
    }

    return SKIP_BODY;
  }

  /**
   * DOCUMENT ME!
   *
   * @throws BeansException DOCUMENT ME!
   */
  private void init() throws BeansException {
    pageManager = (PageManager)context.getBean("pageManager");
  }

  /**
   * y[W̐ݒB
   *
   * @param page
   */
  public void setPage(String page) {
    this.page = page;
  }

  /**
   * @see cx.ath.kgslab.wiki.inline.InlineElementPluginUseConverter#setConverter(cx.ath.kgslab.wiki.ConvertHtml)
   */
  public void setConverter(ConvertHtml converter) {
    this.converter = converter;
  }

  /**
   * @see cx.ath.kgslab.wiki.inline.InlineElementPlugin#setParams(java.lang.String)
   */
  public void setParams(String params) {
    thisPage = this.page;
    setPage(params);
  }

  /**
   * @see cx.ath.kgslab.wiki.inline.InlineElementPlugin#setText(java.lang.String)
   */
  public void setText(String text) {
  }

  /**
   * ւ̕ϊ
   *
   * @return
   *
   * @throws PluginException
   *
   * @see java.lang.Object#toString()
   */
  public String toHTML() throws PluginException {
    String result;

    try {
      String path =
        AbstractPageManager.parsePath(this.page, thisPage);

      if (pageManager.existsPage(path)) {
        Page info = pageManager.getPage(path);

        result = converter.convert(info);
      } else {
        throw new PluginException("̕ɑ}悤Ƃy[W \'" + this.page
          + "\' ͌܂łB");
      }
    } catch (PageReadException e) {
      throw new PluginException(e.getMessage(), e);
    } catch (IOException e) {
      throw new PluginException(e.getMessage(), e);
    }

    return result;
  }

  /**
   * T[ubgReLXg̐ݒ
   *
   * @param context
   *
   * @see cx.ath.kgslab.wiki.plugin.Plugin#setServletContext(javax.servlet.ServletContext)
   */
  public void setApplicationContext(ApplicationContext context) {
    this.context = context;
  }

  /** ReLXgpX */
  protected String contextPath = "";

  /**
   * ReLXgpX̐ݒ
   *
   * @param path ReLXgpX
   */
  public void setContextPath(String path) {
    contextPath = path;
  }

  /**
   * @see cx.ath.kgslab.wiki.plugin.Plugin#getPluginHelp()
   */
  public String getPluginHelp() {
    return "***{0}:y[W}\n" + " &amp;{0}(y[W);\n"
    + ":y[W|}y[W\n" + "y[WɎw肳ꂽy[W̓eA&#38;{0}ʒuɑ}B\n"
    + "-y[W}vOĆAubNvfƂĈׂłB\n"
    + "-y[W}vOĆA̗vf̎qvfɂȂ邱Ƃ͂ł܂B\n"
    + "-y[W}vOĆA̗vfqvfɂ邱Ƃ͂ł܂B";
  }

  /* ( Javadoc)
   * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
   */
  public void afterPropertiesSet() throws Exception {
    init();
  }

  /**
   * @return
   */
  public int getUserAgent() {
    return userAgent;
  }

  /**
   * @param i
   */
  public void setUserAgent(int i) {
    userAgent = i;
  }

  /* ( Javadoc)
   * @see cx.ath.kgslab.wiki.plugin.Plugin#getSessionUtil()
   */
  public SessionUtil getSessionUtil() {
    return sessionUtil;
  }

  /* ( Javadoc)
   * @see cx.ath.kgslab.wiki.plugin.Plugin#setSessionUtil(cx.ath.kgslab.wiki.SessionUtil)
   */
  public void setSessionUtil(SessionUtil util) {
    sessionUtil = util;
  }
}
