/*
 * $Id: LastModifiedTag.java,v 1.1 2004/06/23 06:36:14 mashu Exp $
 */
package cx.ath.kgslab.wiki.taglib;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import cx.ath.kgslab.util.DateUtils;
import cx.ath.kgslab.wiki.JaJaWikiConfig;
import cx.ath.kgslab.wiki.PageManager;
import cx.ath.kgslab.wiki.exception.PageReadException;
import cx.ath.kgslab.wiki.pages.Page;


/**
 * ŏIXV\^O
 *
 * @author VM
 * @version 3.0 
 *
 * @since JaJaWiki 1.0
 */
public class LastModifiedTag extends TagSupport {
  /**
   * Jn^Ȍ
   *
   * @return
   *
   * @throws JspException
   *
   * @see javax.servlet.jsp.tagext.Tag#doStartTag()
   */
  public int doStartTag() throws JspException {
    HttpServletRequest request =
      (HttpServletRequest)pageContext.getRequest();

    //    PageForm form =
    //      (PageForm)RequestUtils.lookup(pageContext, "form", null);
    WebApplicationContext context =
      WebApplicationContextUtils.getRequiredWebApplicationContext(this.pageContext
        .getServletContext());
    JaJaWikiConfig config = (JaJaWikiConfig)context.getBean("config");

    String page = null;

    //    if (form != null) {
    //      page = form.getPage();
    //    } else {
    page = request.getParameter("page");

    //    }
    if ((page == null) || (page.length() <= 0)) {
      page = config.getFrontPageName();
    }

    try {
      PageManager pageMan =
        (PageManager)context.getBean("pageManager");
      Page info = pageMan.getPage(page);
      //PrintWriter out = new PrintWriter(this.pageContext.getOut());

			this.pageContext.getOut().println(DateUtils.formatISODateTime(info.getLastModified()));
    } catch (PageReadException e) {
      throw new JspException(e);
    } catch (IOException e) {
			throw new JspException(e);
    }

    return SKIP_BODY;
  }
}
