/*
 * $Id: PathTag.java,v 1.1 2004/06/23 06:36:14 mashu Exp $
 */
package cx.ath.kgslab.wiki.taglib;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.struts.util.RequestUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import cx.ath.kgslab.webutil.ContextPathUtils;
import cx.ath.kgslab.webutil.UserAgentUtil;
import cx.ath.kgslab.wiki.AbstractPageManager;
import cx.ath.kgslab.wiki.ConvertHtml;
import cx.ath.kgslab.wiki.JaJaWikiConfig;
import cx.ath.kgslab.wiki.SessionUtilImpl;
import cx.ath.kgslab.wiki.struts.form.PageForm;


/**
 * y[WpX\ <br>
 *
 * @author VM
 * @version 3.0 
 *
 * @since JaJaWiki 1.0
 */
public class PathTag extends TagSupport {
  /** y[W */
  String page = null;

  /**
   * ^Ȍ
   *
   * @return SKIP_BODY
   *
   * @throws JspException
   *
   * @see javax.servlet.jsp.tagext.Tag#doEndTag()
   */
  public int doEndTag() throws JspException {
    WebApplicationContext context =
      WebApplicationContextUtils.getRequiredWebApplicationContext(this.pageContext
        .getServletContext());
    JaJaWikiConfig config = (JaJaWikiConfig)context.getBean("config");

    HttpServletRequest request =
      (HttpServletRequest)pageContext.getRequest();

    if ((page == null) || (page.length() <= 0)) {
      PageForm form =
        (PageForm)RequestUtils.lookup(pageContext, "form", null);

      if (form != null) {
        page = form.getPage();
      } else {
        page = request.getParameter("page");
      }

      if ((page == null) || (page.length() <= 0)) {
        page = config.getFrontPageName();
      }
    }

    //PrintWriter out = new PrintWriter(this.pageContext.getOut());
    StringTokenizer tokens = new StringTokenizer(page, "/");
    StringBuffer buf = new StringBuffer(1024);
    String path = "";
    int count = tokens.countTokens() - 1;

    ConvertHtml conv = (ConvertHtml)context.getBean("converter");
    String ua = request.getHeader("User-Agent");

    conv.setUserAgent(UserAgentUtil.checkUserAgent(ua));

    conv.setLocale(request.getLocale());

    conv.setContextPath(ContextPathUtils.getPath(request));
    conv.setPage(page);
    conv.setSessionUtil(new SessionUtilImpl(
        (HttpServletResponse)pageContext.getResponse()));

    for (int idx = 0; idx < count; idx++) {
      String token = tokens.nextToken();

      path = AbstractPageManager.concatPath(path, token);
      String link = "";

      try {
        link = conv.processLinkBraketName(token, path);
      } catch (UnsupportedEncodingException e) {
        throw new JspException(e);
      }

      buf.append(link);

      buf.append("&gt;");
    }

		try {
      this.pageContext.getOut().println(buf.toString().trim());
    } catch (IOException e) {
    	throw new JspException(e);
    }
    page = null;

    return SKIP_BODY;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public String getPage() {
    return page;
  }

  /**
   * DOCUMENT ME!
   *
   * @param string
   */
  public void setPage(String string) {
    page = string;
  }
}
