/*
 * $Id: Child.java,v 1.1 2004/06/23 07:16:45 mashu Exp $
 */
package cx.ath.kgslab.wiki.relaxer.pages;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

import java.net.URL;

import javax.xml.parsers.*;

import org.w3c.dom.*;

import org.xml.sax.*;
import org.xml.sax.helpers.*;


/**
 * <!-- for programmer
 <element name="child">
 <attribute name="title">
 <data type="string"/>
 </attribute>
 <empty/>
 </element>
 -->
 * <!-- for javadoc -->
 * <b>Child</b> is generated from WikiPages.rng by Relaxer. This
 * class is derived from:
 * <pre> &lt;element name="child"&gt;
 *   &lt;attribute name="title"&gt;
 *     &lt;data type="string"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;empty/&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @author Relaxer 1.0b (http://www.relaxer.org)
 * @version WikiPages.rng (Wed Nov 26 14:58:00 JST 2003)
 */
public class Child implements java.io.Serializable, Cloneable,
  IRNSContainer, IRContentClassHandler, IRNode {
  /** DOCUMENT ME! */
  private RNSContext rNSContext_ =
    new RNSContext(this,
      "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages");

  /** DOCUMENT ME! */
  private String title_;

  /** DOCUMENT ME! */
  private StringBuffer saxBuffer_;

  /** DOCUMENT ME! */
  private IRNode parentRNode_;

  /**
   * Creates a <code>Child</code>.
   */
  public Child() {
    title_ = "";
  }

  /**
   * Creates a <code>Child</code>.
   *
   * @param source
   */
  public Child(Child source) {
    setup(source);
  }

  /**
   * Creates a <code>Child</code> by the Stack <code>stack</code>
   * that contains Elements. This constructor is supposed to be used
   * internally by the Relaxer system.
   *
   * @param stack
   */
  public Child(RStack stack) {
    setup(stack);
  }

  /**
   * Creates a <code>Child</code> by the Document <code>doc</code>.
   *
   * @param doc
   */
  public Child(Document doc) {
    setup(doc.getDocumentElement());
  }

  /**
   * Creates a <code>Child</code> by the Element
   * <code>element</code>.
   *
   * @param element
   */
  public Child(Element element) {
    setup(element);
  }

  /**
   * Creates a <code>Child</code> by the File <code>file</code>.
   *
   * @param file
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Child(File file)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(file);
  }

  /**
   * Creates a <code>Child</code> by the String representation of URI
   * <code>uri</code>.
   *
   * @param uri
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Child(String uri)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(uri);
  }

  /**
   * Creates a <code>Child</code> by the URL <code>url</code>.
   *
   * @param url
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Child(URL url)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(url);
  }

  /**
   * Creates a <code>Child</code> by the InputStream <code>in</code>.
   *
   * @param in
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Child(InputStream in)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(in);
  }

  /**
   * Creates a <code>Child</code> by the InputSource <code>is</code>.
   *
   * @param is
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Child(InputSource is)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(is);
  }

  /**
   * Creates a <code>Child</code> by the Reader <code>reader</code>.
   *
   * @param reader
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Child(Reader reader)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(reader);
  }

  /**
   * Initializes the <code>Child</code> by the Child
   * <code>source</code>.
   *
   * @param source
   */
  public void setup(Child source) {
    int size;

    setTitle(source.getTitle());
  }

  /**
   * Initializes the <code>Child</code> by the Document
   * <code>doc</code>.
   *
   * @param doc
   */
  public void setup(Document doc) {
    setup(doc.getDocumentElement());
  }

  /**
   * Initializes the <code>Child</code> by the Element
   * <code>element</code>.
   *
   * @param element
   */
  public void setup(Element element) {
    init(element);
  }

  /**
   * Initializes the <code>Child</code> by the Stack
   * <code>stack</code> that contains Elements. This constructor is
   * supposed to be used internally by the Relaxer system.
   *
   * @param stack
   */
  public void setup(RStack stack) {
    init(stack.popElement());
  }

  /**
   * DOCUMENT ME!
   *
   * @param element
   */
  private void init(Element element) {
    RStack stack = new RStack(element);

    rNSContext_.declareNamespace(element);
    title_ = URelaxer.getAttributePropertyAsString(element, "title");
  }

  /**
   * DOCUMENT ME!
   *
   * @return Object
   */
  public Object clone() {
    return (new Child(this));
  }

  /**
   * Creates a DOM representation of the object. Result is appended
   * to the Node <code>parent</code>.
   *
   * @param parent
   */
  public void makeElement(Node parent) {
    Document doc;

    if (parent instanceof Document) {
      doc = (Document)parent;
    } else {
      doc = parent.getOwnerDocument();
    }

    Element element =
      doc.createElementNS("http://JaJaWiki.kgslab.ath.cx/schema/WikiPages",
        "child");

    rNSContext_.setupNamespace(element);

    int size;

    if (this.title_ != null) {
      URelaxer.setAttributePropertyByString(element, "title",
        this.title_);
    }

    parent.appendChild(element);
  }

  /**
   * Initializes the <code>Child</code> by the File
   * <code>file</code>.
   *
   * @param file
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(File file)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(file.toURL());
  }

  /**
   * Initializes the <code>Child</code> by the String representation
   * of URI <code>uri</code>.
   *
   * @param uri
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(String uri)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>Child</code> by the URL <code>url</code>.
   *
   * @param url
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(URL url)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>Child</code> by the InputStream
   * <code>in</code>.
   *
   * @param in
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(InputStream in)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>Child</code> by the InputSource
   * <code>is</code>.
   *
   * @param is
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(InputSource is)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>Child</code> by the Reader
   * <code>reader</code>.
   *
   * @param reader
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(Reader reader)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Creates a DOM document representation of the object.
   *
   * @return Document
   *
   * @exception ParserConfigurationException
   */
  public Document makeDocument() throws ParserConfigurationException {
    Document doc = UJAXP.makeDocument();

    makeElement(doc);

    return (doc);
  }

  /**
   * Gets the RNSContext property <b>RNSContext</b>.
   *
   * @return RNSContext
   */
  public final RNSContext rGetRNSContext() {
    return (rNSContext_);
  }

  /**
   * Sets the RNSContext property <b>RNSContext</b>.
   *
   * @param rNSContext
   */
  public final void rSetRNSContext(RNSContext rNSContext) {
    this.rNSContext_ = rNSContext;
  }

  /**
   * Gets the String property <b>title</b>.
   *
   * @return String
   */
  public final String getTitle() {
    return (title_);
  }

  /**
   * Sets the String property <b>title</b>.
   *
   * @param title
   */
  public final void setTitle(String title) {
    this.title_ = title;
  }

  /**
   * Makes an XML text representation.
   *
   * @return String
   */
  public String makeTextDocument() {
    StringBuffer buffer = new StringBuffer();

    makeTextElement(buffer);

    return (new String(buffer));
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextElement(StringBuffer buffer) {
    int size;
    String prefix =
      rNSContext_.getPrefixByUri(
        "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages");

    buffer.append("<");
    URelaxer.makeQName(prefix, "child", buffer);
    rNSContext_.makeNSMappings(buffer);

    if (title_ != null) {
      buffer.append(" ");
      buffer.append("title");
      buffer.append("=\"");
      buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(
            getTitle())));
      buffer.append("\"");
    }

    buffer.append(">");
    buffer.append("</");
    URelaxer.makeQName(prefix, "child", buffer);
    buffer.append(">");
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   *
   * @exception IOException
   */
  public void makeTextElement(Writer buffer) throws IOException {
    int size;
    String prefix =
      rNSContext_.getPrefixByUri(
        "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages");

    buffer.write("<");
    URelaxer.makeQName(prefix, "child", buffer);
    rNSContext_.makeNSMappings(buffer);

    if (title_ != null) {
      buffer.write(" ");
      buffer.write("title");
      buffer.write("=\"");
      buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(
            getTitle())));
      buffer.write("\"");
    }

    buffer.write(">");
    buffer.write("</");
    URelaxer.makeQName(prefix, "child", buffer);
    buffer.write(">");
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextElement(PrintWriter buffer) {
    int size;
    String prefix =
      rNSContext_.getPrefixByUri(
        "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages");

    buffer.print("<");
    URelaxer.makeQName(prefix, "child", buffer);
    rNSContext_.makeNSMappings(buffer);

    if (title_ != null) {
      buffer.print(" ");
      buffer.print("title");
      buffer.print("=\"");
      buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(
            getTitle())));
      buffer.print("\"");
    }

    buffer.print(">");
    buffer.print("</");
    URelaxer.makeQName(prefix, "child", buffer);
    buffer.print(">");
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextAttribute(StringBuffer buffer) {
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   *
   * @exception IOException
   */
  public void makeTextAttribute(Writer buffer) throws IOException {
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextAttribute(PrintWriter buffer) {
  }

  /**
   * Gets the property value as String.
   *
   * @return String
   */
  public String getTitleAsString() {
    return (URelaxer.getString(getTitle()));
  }

  /**
   * Sets the property value by String.
   *
   * @param string
   */
  public void setTitleByString(String string) {
    setTitle(string);
  }

  /**
   * Returns a String representation of this object. While this
   * method informs as XML format representaion, it's purpose is
   * just information, not making a rigid XML documentation.
   *
   * @return String
   */
  public String toString() {
    try {
      return (makeTextDocument());
    } catch (Exception e) {
      return (super.toString());
    }
  }

  /**
   * Generates SAX events for ContentHandler.
   *
   * @param handler
   *
   * @exception SAXException
   */
  public void makeDocument(ContentHandler handler)
        throws SAXException {
    handler.startDocument();
    makeElement(handler);
    handler.endDocument();
  }

  /**
   * Generates SAX events for ContentHandler.
   *
   * @param handler
   *
   * @exception SAXException
   */
  public void makeElement(ContentHandler handler) throws SAXException {
    rNSContext_.startNSMappings(handler);

    String prefix =
      rNSContext_.getPrefixByUri(
        "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages");
    int size;
    String string;
    String slotQName;
    AttributesImpl attrs = new AttributesImpl();

    attrs.addAttribute("", "title", "title", "CDATA",
      URelaxer.getString(getTitle()));

    String qName = URelaxer.getQName(prefix, "child");

    handler.startElement("http://JaJaWiki.kgslab.ath.cx/schema/WikiPages",
      "child", qName, attrs);
    handler.endElement("http://JaJaWiki.kgslab.ath.cx/schema/WikiPages",
      "child", qName);
    rNSContext_.endNSMappings(handler);
  }

  /**
   * Generates SAX events for ContentHandler.
   *
   * @param attrs
   *
   * @exception SAXException
   */
  public void makeAttribute(AttributesImpl attrs) throws SAXException {
  }

  /**
   * Event handler for InitElement during object construction.
   *
   * @param attrs
   */
  public void initElement(Attributes attrs) {
    String string;

    string = attrs.getValue("title");
    setTitle(string);
  }

  /**
   * Event handler for declarePrefixMapping during object
   * construction.
   *
   * @param prefix
   * @param uri
   */
  public void declarePrefixMapping(String prefix, String uri) {
    rNSContext_.declareNamespace(prefix, uri);
  }

  /**
   * Event handler for startElement during object construction.
   *
   * @param namespaceURI
   * @param localName
   * @param qName
   * @param attrs
   *
   * @return IRContentClassHandler
   */
  public IRContentClassHandler startElement(String namespaceURI,
    String localName, String qName, Attributes attrs) {
    return (this);
  }

  /**
   * Event handler for endElement during object construction.
   *
   * @param namespaceURI
   * @param localName
   * @param qName
   *
   * @return IRContentClassHandler
   */
  public IRContentClassHandler endElement(String namespaceURI,
    String localName, String qName) {
    String string;

    return ((IRContentClassHandler)rGetParentRNode());
  }

  /**
   * Event handler for characters during object construction.
   *
   * @param ch
   * @param start
   * @param length
   */
  public void characters(char[] ch, int start, int length) {
    if (saxBuffer_ != null) {
      saxBuffer_.append(ch, start, length);
    }
  }

  /**
   * Event handler for processngInstruction during object
   * construction.
   *
   * @param target
   * @param value
   */
  public void processingInstruction(String target, String value) {
  }

  /**
   * Gets the IRNode property <b>parentRNode</b>.
   *
   * @return IRNode
   */
  public final IRNode rGetParentRNode() {
    return (parentRNode_);
  }

  /**
   * Sets the IRNode property <b>parentRNode</b>.
   *
   * @param parentRNode
   */
  public final void rSetParentRNode(IRNode parentRNode) {
    this.parentRNode_ = parentRNode;
  }

  /**
   * Gets child RNodes.
   *
   * @return IRNode[]
   */
  public IRNode[] rGetRNodes() {
    java.util.List classNodes = new java.util.ArrayList();
    IRNode[] nodes = new IRNode[classNodes.size()];

    return ((IRNode[])classNodes.toArray(nodes));
  }

  /**
   * Tests if a Element <code>element</code> is valid for the
   * <code>Child</code>.
   *
   * @param element
   *
   * @return boolean
   */
  public static boolean isMatch(Element element) {
    if (!URelaxer2.isTargetElement(element,
            "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages", "child")) {
      return (false);
    }

    RStack target = new RStack(element);
    boolean $match$ = false;
    Element child;

    if (!URelaxer.hasAttributeHungry(target, "title")) {
      return (false);
    }

    $match$ = true;

    if (!target.isEmptyElement()) {
      return (false);
    }

    return (true);
  }

  /**
   * Tests if elements contained in a Stack <code>stack</code> is
   * valid for the <code>Child</code>. This mehtod is supposed to be
   * used internally by the Relaxer system.
   *
   * @param stack
   *
   * @return boolean
   */
  public static boolean isMatch(RStack stack) {
    Element element = stack.peekElement();

    if (element == null) {
      return (false);
    }

    return (isMatch(element));
  }

  /**
   * Tests if elements contained in a Stack <code>stack</code> is
   * valid for the <code>Child</code>. This method consumes the
   * stack contents during matching operation. This mehtod is
   * supposed to be used internally by the Relaxer system.
   *
   * @param stack
   *
   * @return boolean
   */
  public static boolean isMatchHungry(RStack stack) {
    Element element = stack.peekElement();

    if (element == null) {
      return (false);
    }

    if (isMatch(element)) {
      stack.popElement();

      return (true);
    } else {
      return (false);
    }
  }
}
