/*
 * $Id: PathInfo.java,v 1.1 2004/06/23 07:16:45 mashu Exp $
 */
package cx.ath.kgslab.wiki.relaxer.pages;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

import java.net.URL;

import javax.xml.parsers.*;

import org.w3c.dom.*;

import org.xml.sax.*;
import org.xml.sax.helpers.*;


/**
 * <!-- for programmer
 <element name="pathInfo">
 <group>
 <optional>
 <ref name="path"/>
 </optional>
 <zeroOrMore>
 <ref name="child"/>
 </zeroOrMore>
 </group>
 </element>
 -->
 * <!-- for javadoc -->
 * <b>PathInfo</b> is generated from WikiPages.rng by Relaxer. This
 * class is derived from:
 * <pre> &lt;element name="pathInfo"&gt;
 *   &lt;group&gt;
 *     &lt;optional&gt;
 *       &lt;ref name="path"/&gt;
 *     &lt;/optional&gt;
 *     &lt;zeroOrMore&gt;
 *       &lt;ref name="child"/&gt;
 *     &lt;/zeroOrMore&gt;
 *   &lt;/group&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @author Relaxer 1.0b (http://www.relaxer.org)
 * @version WikiPages.rng (Wed Nov 26 14:58:00 JST 2003)
 */
public class PathInfo implements java.io.Serializable, Cloneable,
  IRNSContainer, IRContentClassHandler, IRNode {
  /** DOCUMENT ME! */
  private RNSContext rNSContext_ =
    new RNSContext(this,
      "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages");

  /** DOCUMENT ME! */
  private String path_;

  // List<Child>

  /** DOCUMENT ME! */
  private java.util.List child_ = new java.util.ArrayList();

  /** DOCUMENT ME! */
  private StringBuffer saxBuffer_;

  /** DOCUMENT ME! */
  private IRNode parentRNode_;

  /**
   * Creates a <code>PathInfo</code>.
   */
  public PathInfo() {
    path_ = "";
  }

  /**
   * Creates a <code>PathInfo</code>.
   *
   * @param source
   */
  public PathInfo(PathInfo source) {
    setup(source);
  }

  /**
   * Creates a <code>PathInfo</code> by the Stack <code>stack</code>
   * that contains Elements. This constructor is supposed to be used
   * internally by the Relaxer system.
   *
   * @param stack
   */
  public PathInfo(RStack stack) {
    setup(stack);
  }

  /**
   * Creates a <code>PathInfo</code> by the Document
   * <code>doc</code>.
   *
   * @param doc
   */
  public PathInfo(Document doc) {
    setup(doc.getDocumentElement());
  }

  /**
   * Creates a <code>PathInfo</code> by the Element
   * <code>element</code>.
   *
   * @param element
   */
  public PathInfo(Element element) {
    setup(element);
  }

  /**
   * Creates a <code>PathInfo</code> by the File <code>file</code>.
   *
   * @param file
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public PathInfo(File file)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(file);
  }

  /**
   * Creates a <code>PathInfo</code> by the String representation of
   * URI <code>uri</code>.
   *
   * @param uri
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public PathInfo(String uri)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(uri);
  }

  /**
   * Creates a <code>PathInfo</code> by the URL <code>url</code>.
   *
   * @param url
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public PathInfo(URL url)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(url);
  }

  /**
   * Creates a <code>PathInfo</code> by the InputStream
   * <code>in</code>.
   *
   * @param in
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public PathInfo(InputStream in)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(in);
  }

  /**
   * Creates a <code>PathInfo</code> by the InputSource
   * <code>is</code>.
   *
   * @param is
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public PathInfo(InputSource is)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(is);
  }

  /**
   * Creates a <code>PathInfo</code> by the Reader
   * <code>reader</code>.
   *
   * @param reader
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public PathInfo(Reader reader)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(reader);
  }

  /**
   * Initializes the <code>PathInfo</code> by the PathInfo
   * <code>source</code>.
   *
   * @param source
   */
  public void setup(PathInfo source) {
    int size;

    setPath(source.getPath());
    this.child_.clear();
    size = source.child_.size();

    for (int i = 0; i < size; i++) {
      addChild((Child)source.getChild(i).clone());
    }
  }

  /**
   * Initializes the <code>PathInfo</code> by the Document
   * <code>doc</code>.
   *
   * @param doc
   */
  public void setup(Document doc) {
    setup(doc.getDocumentElement());
  }

  /**
   * Initializes the <code>PathInfo</code> by the Element
   * <code>element</code>.
   *
   * @param element
   */
  public void setup(Element element) {
    init(element);
  }

  /**
   * Initializes the <code>PathInfo</code> by the Stack
   * <code>stack</code> that contains Elements. This constructor is
   * supposed to be used internally by the Relaxer system.
   *
   * @param stack
   */
  public void setup(RStack stack) {
    init(stack.popElement());
  }

  /**
   * DOCUMENT ME!
   *
   * @param element
   */
  private void init(Element element) {
    RStack stack = new RStack(element);

    rNSContext_.declareNamespace(element);
    path_ =
      URelaxer2.getElementPropertyAsStringByStack(stack,
        "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages", "path");
    child_.clear();

    while (true) {
      if (Child.isMatch(stack)) {
        addChild(new Child(stack));
      } else {
        break;
      }
    }
  }

  /**
   * DOCUMENT ME!
   *
   * @return Object
   */
  public Object clone() {
    return (new PathInfo(this));
  }

  /**
   * Creates a DOM representation of the object. Result is appended
   * to the Node <code>parent</code>.
   *
   * @param parent
   */
  public void makeElement(Node parent) {
    Document doc;

    if (parent instanceof Document) {
      doc = (Document)parent;
    } else {
      doc = parent.getOwnerDocument();
    }

    Element element =
      doc.createElementNS("http://JaJaWiki.kgslab.ath.cx/schema/WikiPages",
        "pathInfo");

    rNSContext_.setupNamespace(element);

    int size;

    if (this.path_ != null) {
      URelaxer2.setElementPropertyByString(element,
        "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages", "path",
        this.path_, rNSContext_);
    }

    size = this.child_.size();

    for (int i = 0; i < size; i++) {
      Child value = (Child)this.child_.get(i);

      value.makeElement(element);
    }

    parent.appendChild(element);
  }

  /**
   * Initializes the <code>PathInfo</code> by the File
   * <code>file</code>.
   *
   * @param file
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(File file)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(file.toURL());
  }

  /**
   * Initializes the <code>PathInfo</code> by the String
   * representation of URI <code>uri</code>.
   *
   * @param uri
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(String uri)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>PathInfo</code> by the URL
   * <code>url</code>.
   *
   * @param url
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(URL url)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>PathInfo</code> by the InputStream
   * <code>in</code>.
   *
   * @param in
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(InputStream in)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>PathInfo</code> by the InputSource
   * <code>is</code>.
   *
   * @param is
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(InputSource is)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>PathInfo</code> by the Reader
   * <code>reader</code>.
   *
   * @param reader
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(Reader reader)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Creates a DOM document representation of the object.
   *
   * @return Document
   *
   * @exception ParserConfigurationException
   */
  public Document makeDocument() throws ParserConfigurationException {
    Document doc = UJAXP.makeDocument();

    makeElement(doc);

    return (doc);
  }

  /**
   * Gets the RNSContext property <b>RNSContext</b>.
   *
   * @return RNSContext
   */
  public final RNSContext rGetRNSContext() {
    return (rNSContext_);
  }

  /**
   * Sets the RNSContext property <b>RNSContext</b>.
   *
   * @param rNSContext
   */
  public final void rSetRNSContext(RNSContext rNSContext) {
    this.rNSContext_ = rNSContext;
  }

  /**
   * Gets the String property <b>path</b>.
   *
   * @return String
   */
  public final String getPath() {
    return (path_);
  }

  /**
   * Sets the String property <b>path</b>.
   *
   * @param path
   */
  public final void setPath(String path) {
    this.path_ = path;
  }

  /**
   * Gets the Child property <b>child</b>.
   *
   * @return Child[]
   */
  public final Child[] getChild() {
    Child[] array = new Child[child_.size()];

    return ((Child[])child_.toArray(array));
  }

  /**
   * Sets the Child property <b>child</b>.
   *
   * @param childValue
   */
  public final void setChild(Child[] childValue) {
    this.child_.clear();

    for (int i = 0; i < childValue.length; i++) {
      addChild(childValue[i]);
    }

    for (int i = 0; i < childValue.length; i++) {
      childValue[i].rSetParentRNode(this);
    }
  }

  /**
   * Sets the Child property <b>child</b>.
   *
   * @param childValue
   */
  public final void setChild(Child childValue) {
    this.child_.clear();
    addChild(childValue);

    if (childValue != null) {
      childValue.rSetParentRNode(this);
    }
  }

  /**
   * Adds the Child property <b>child</b>.
   *
   * @param childValue
   */
  public final void addChild(Child childValue) {
    this.child_.add(childValue);

    if (childValue != null) {
      childValue.rSetParentRNode(this);
    }
  }

  /**
   * Adds the Child property <b>child</b>.
   *
   * @param childValue
   */
  public final void addChild(Child[] childValue) {
    for (int i = 0; i < childValue.length; i++) {
      addChild(childValue[i]);
    }

    for (int i = 0; i < childValue.length; i++) {
      childValue[i].rSetParentRNode(this);
    }
  }

  /**
   * Gets number of the Child property <b>child</b>.
   *
   * @return int
   */
  public final int sizeChild() {
    return (child_.size());
  }

  /**
   * Gets the Child property <b>child</b> by index.
   *
   * @param index
   *
   * @return Child
   */
  public final Child getChild(int index) {
    return ((Child)child_.get(index));
  }

  /**
   * Sets the Child property <b>child</b> by index.
   *
   * @param index
   * @param childValue
   */
  public final void setChild(int index, Child childValue) {
    this.child_.set(index, childValue);

    if (childValue != null) {
      childValue.rSetParentRNode(this);
    }
  }

  /**
   * Adds the Child property <b>child</b> by index.
   *
   * @param index
   * @param childValue
   */
  public final void addChild(int index, Child childValue) {
    this.child_.add(index, childValue);

    if (childValue != null) {
      childValue.rSetParentRNode(this);
    }
  }

  /**
   * Remove the Child property <b>child</b> by index.
   *
   * @param index
   */
  public final void removeChild(int index) {
    this.child_.remove(index);
  }

  /**
   * Remove the Child property <b>child</b> by object.
   *
   * @param childValue
   */
  public final void removeChild(Child childValue) {
    this.child_.remove(childValue);
  }

  /**
   * Clear the Child property <b>child</b>.
   */
  public final void clearChild() {
    this.child_.clear();
  }

  /**
   * Makes an XML text representation.
   *
   * @return String
   */
  public String makeTextDocument() {
    StringBuffer buffer = new StringBuffer();

    makeTextElement(buffer);

    return (new String(buffer));
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextElement(StringBuffer buffer) {
    int size;
    String prefix =
      rNSContext_.getPrefixByUri(
        "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages");

    buffer.append("<");
    URelaxer.makeQName(prefix, "pathInfo", buffer);
    rNSContext_.makeNSMappings(buffer);
    buffer.append(">");

    if (path_ != null) {
      buffer.append("<");
      URelaxer.makeQName(prefix, "path", buffer);
      buffer.append(">");
      buffer.append(URelaxer.escapeCharData(URelaxer.getString(
            getPath())));
      buffer.append("</");
      URelaxer.makeQName(prefix, "path", buffer);
      buffer.append(">");
    }

    size = this.child_.size();

    for (int i = 0; i < size; i++) {
      Child value = (Child)this.child_.get(i);

      value.makeTextElement(buffer);
    }

    buffer.append("</");
    URelaxer.makeQName(prefix, "pathInfo", buffer);
    buffer.append(">");
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   *
   * @exception IOException
   */
  public void makeTextElement(Writer buffer) throws IOException {
    int size;
    String prefix =
      rNSContext_.getPrefixByUri(
        "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages");

    buffer.write("<");
    URelaxer.makeQName(prefix, "pathInfo", buffer);
    rNSContext_.makeNSMappings(buffer);
    buffer.write(">");

    if (path_ != null) {
      buffer.write("<");
      URelaxer.makeQName(prefix, "path", buffer);
      buffer.write(">");
      buffer.write(URelaxer.escapeCharData(URelaxer.getString(
            getPath())));
      buffer.write("</");
      URelaxer.makeQName(prefix, "path", buffer);
      buffer.write(">");
    }

    size = this.child_.size();

    for (int i = 0; i < size; i++) {
      Child value = (Child)this.child_.get(i);

      value.makeTextElement(buffer);
    }

    buffer.write("</");
    URelaxer.makeQName(prefix, "pathInfo", buffer);
    buffer.write(">");
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextElement(PrintWriter buffer) {
    int size;
    String prefix =
      rNSContext_.getPrefixByUri(
        "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages");

    buffer.print("<");
    URelaxer.makeQName(prefix, "pathInfo", buffer);
    rNSContext_.makeNSMappings(buffer);
    buffer.print(">");

    if (path_ != null) {
      buffer.print("<");
      URelaxer.makeQName(prefix, "path", buffer);
      buffer.print(">");
      buffer.print(URelaxer.escapeCharData(URelaxer.getString(
            getPath())));
      buffer.print("</");
      URelaxer.makeQName(prefix, "path", buffer);
      buffer.print(">");
    }

    size = this.child_.size();

    for (int i = 0; i < size; i++) {
      Child value = (Child)this.child_.get(i);

      value.makeTextElement(buffer);
    }

    buffer.print("</");
    URelaxer.makeQName(prefix, "pathInfo", buffer);
    buffer.print(">");
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextAttribute(StringBuffer buffer) {
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   *
   * @exception IOException
   */
  public void makeTextAttribute(Writer buffer) throws IOException {
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextAttribute(PrintWriter buffer) {
  }

  /**
   * Gets the property value as String.
   *
   * @return String
   */
  public String getPathAsString() {
    return (URelaxer.getString(getPath()));
  }

  /**
   * Sets the property value by String.
   *
   * @param string
   */
  public void setPathByString(String string) {
    setPath(string);
  }

  /**
   * Returns a String representation of this object. While this
   * method informs as XML format representaion, it's purpose is
   * just information, not making a rigid XML documentation.
   *
   * @return String
   */
  public String toString() {
    try {
      return (makeTextDocument());
    } catch (Exception e) {
      return (super.toString());
    }
  }

  /**
   * Generates SAX events for ContentHandler.
   *
   * @param handler
   *
   * @exception SAXException
   */
  public void makeDocument(ContentHandler handler)
        throws SAXException {
    handler.startDocument();
    makeElement(handler);
    handler.endDocument();
  }

  /**
   * Generates SAX events for ContentHandler.
   *
   * @param handler
   *
   * @exception SAXException
   */
  public void makeElement(ContentHandler handler) throws SAXException {
    rNSContext_.startNSMappings(handler);

    String prefix =
      rNSContext_.getPrefixByUri(
        "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages");
    int size;
    String string;
    String slotQName;
    AttributesImpl nullAttrs = new AttributesImpl();
    AttributesImpl attrs = nullAttrs;
    String qName = URelaxer.getQName(prefix, "pathInfo");

    handler.startElement("http://JaJaWiki.kgslab.ath.cx/schema/WikiPages",
      "pathInfo", qName, attrs);

    if (path_ != null) {
      slotQName = URelaxer.getQName(prefix, "path");
      handler.startElement("http://JaJaWiki.kgslab.ath.cx/schema/WikiPages",
        "path", slotQName, nullAttrs);
      string = URelaxer.getString(getPath());
      handler.characters(string.toCharArray(), 0, string.length());
      handler.endElement("http://JaJaWiki.kgslab.ath.cx/schema/WikiPages",
        "path", slotQName);
    }

    size = this.child_.size();

    for (int i = 0; i < size; i++) {
      Child value = (Child)this.child_.get(i);

      value.makeElement(handler);
    }

    handler.endElement("http://JaJaWiki.kgslab.ath.cx/schema/WikiPages",
      "pathInfo", qName);
    rNSContext_.endNSMappings(handler);
  }

  /**
   * Generates SAX events for ContentHandler.
   *
   * @param attrs
   *
   * @exception SAXException
   */
  public void makeAttribute(AttributesImpl attrs) throws SAXException {
  }

  /**
   * Event handler for InitElement during object construction.
   *
   * @param attrs
   */
  public void initElement(Attributes attrs) {
    String string;
  }

  /**
   * Event handler for declarePrefixMapping during object
   * construction.
   *
   * @param prefix
   * @param uri
   */
  public void declarePrefixMapping(String prefix, String uri) {
    rNSContext_.declareNamespace(prefix, uri);
  }

  /**
   * Event handler for startElement during object construction.
   *
   * @param namespaceURI
   * @param localName
   * @param qName
   * @param attrs
   *
   * @return IRContentClassHandler
   */
  public IRContentClassHandler startElement(String namespaceURI,
    String localName, String qName, Attributes attrs) {
    if ("path".equals(localName)
          && "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages".equals(
            namespaceURI)) {
      saxBuffer_ = new StringBuffer();

      return (this);
    }

    if ("child".equals(localName)
          && "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages".equals(
            namespaceURI)) {
      Child ref = new Child();

      ref.initElement(attrs);
      addChild(ref);

      return (ref);
    }

    return (this);
  }

  /**
   * Event handler for endElement during object construction.
   *
   * @param namespaceURI
   * @param localName
   * @param qName
   *
   * @return IRContentClassHandler
   */
  public IRContentClassHandler endElement(String namespaceURI,
    String localName, String qName) {
    String string;

    if ("path".equals(localName)
          && "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages".equals(
            namespaceURI)) {
      string = new String(saxBuffer_);
      setPath(string);

      return (this);
    }

    return ((IRContentClassHandler)rGetParentRNode());
  }

  /**
   * Event handler for characters during object construction.
   *
   * @param ch
   * @param start
   * @param length
   */
  public void characters(char[] ch, int start, int length) {
    if (saxBuffer_ != null) {
      saxBuffer_.append(ch, start, length);
    }
  }

  /**
   * Event handler for processngInstruction during object
   * construction.
   *
   * @param target
   * @param value
   */
  public void processingInstruction(String target, String value) {
  }

  /**
   * Gets the IRNode property <b>parentRNode</b>.
   *
   * @return IRNode
   */
  public final IRNode rGetParentRNode() {
    return (parentRNode_);
  }

  /**
   * Sets the IRNode property <b>parentRNode</b>.
   *
   * @param parentRNode
   */
  public final void rSetParentRNode(IRNode parentRNode) {
    this.parentRNode_ = parentRNode;
  }

  /**
   * Gets child RNodes.
   *
   * @return IRNode[]
   */
  public IRNode[] rGetRNodes() {
    java.util.List classNodes = new java.util.ArrayList();

    classNodes.addAll(child_);

    IRNode[] nodes = new IRNode[classNodes.size()];

    return ((IRNode[])classNodes.toArray(nodes));
  }

  /**
   * Tests if a Element <code>element</code> is valid for the
   * <code>PathInfo</code>.
   *
   * @param element
   *
   * @return boolean
   */
  public static boolean isMatch(Element element) {
    if (!URelaxer2.isTargetElement(element,
            "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages",
            "pathInfo")) {
      return (false);
    }

    RStack target = new RStack(element);
    boolean $match$ = false;
    Element child;

    child = target.peekElement();

    if (child != null) {
      if (URelaxer2.isTargetElement(child,
              "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages", "path")) {
        target.popElement();
      }
    }

    $match$ = true;

    while (true) {
      if (!Child.isMatchHungry(target)) {
        break;
      }

      $match$ = true;
    }

    if (!target.isEmptyElement()) {
      return (false);
    }

    return (true);
  }

  /**
   * Tests if elements contained in a Stack <code>stack</code> is
   * valid for the <code>PathInfo</code>. This mehtod is supposed to
   * be used internally by the Relaxer system.
   *
   * @param stack
   *
   * @return boolean
   */
  public static boolean isMatch(RStack stack) {
    Element element = stack.peekElement();

    if (element == null) {
      return (false);
    }

    return (isMatch(element));
  }

  /**
   * Tests if elements contained in a Stack <code>stack</code> is
   * valid for the <code>PathInfo</code>. This method consumes the
   * stack contents during matching operation. This mehtod is
   * supposed to be used internally by the Relaxer system.
   *
   * @param stack
   *
   * @return boolean
   */
  public static boolean isMatchHungry(RStack stack) {
    Element element = stack.peekElement();

    if (element == null) {
      return (false);
    }

    if (isMatch(element)) {
      stack.popElement();

      return (true);
    } else {
      return (false);
    }
  }
}
