/*
 * $Id: PageConverter2.java,v 1.1 2004/06/23 07:16:45 mashu Exp $
 */
package cx.ath.kgslab.wiki.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

import java.net.URLEncoder;

import java.nio.channels.FileLock;

import java.util.Date;
import java.util.StringTokenizer;

import cx.ath.kgslab.wiki.pages.Count;
import cx.ath.kgslab.wiki.pages.Page;

import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;


/**
 * 2.0`Wikiy[W3.0`ɕϊB
 *
 * @author VM
 * @version 1.0
 */
public class PageConverter2 {
  /** xml */
  static final String XML = ".xml";
  static File path = new File(".");

  /** GR[h */
  String enc = "UTF-8";

  /**
   * RXgN^
   *
   * @param enc GR[h
   */
  public PageConverter2(String enc) {
    this.enc = enc;
    File[] files = path.listFiles();

    for (int i = 0; i < files.length; i++) {
      File file = files[i];
      String name = file.getName();

      try {
        if (name.endsWith(XML)) {
          cx.ath.kgslab.wiki.relaxer.pages.Page oldPage =
            new cx.ath.kgslab.wiki.relaxer.pages.Page(file);
          Page newPage = new Page();

          newPage.setTitle(oldPage.getTitle());
          newPage.setContent(oldPage.getContent());
          newPage.setLastModified(oldPage.getLastModified().getTime());
          newPage.setLocked(oldPage.getLocked());
          newPage.setPassword(oldPage.getPassword());
          cx.ath.kgslab.wiki.relaxer.pages.Count oldCount =
            oldPage.getCount();

          if (oldCount != null) {
            Count newCount = new Count();

            newCount.setLastcount(oldCount.getLastcount().getTime());
            newCount.setToday(oldCount.getToday().longValue());
            newCount.setTotal(oldCount.getTotal().longValue());
            newCount.setYesterday(oldCount.getYesterday().longValue());
            newPage.setCount(newCount);
          }

          file.renameTo(new File(file.getPath(), name + ".old"));
          writePage(newPage);
        }
      } catch (Exception ex) {
        ex.printStackTrace();
      }
    }
  }

  /**
   * DOCUMENT ME!
   *
   * @param args DOCUMENT ME!
   */
  public static void main(String[] args) {
    if (args.length > 0) {
      path = new File(args[0]);
    }

    String enc = "UTF-8";

    if (args.length > 1) {
      enc = args[1];
    }

    new PageConverter2(enc);
  }

  /**
   * DOCUMENT ME!
   *
   * @param name
   *
   * @return
   *
   * @throws RuntimeException DOCUMENT ME!
   */
  protected File getFile(String name) {
    try {
      String converted = URLEncoder.encode(name, enc);
      StringTokenizer tokens = new StringTokenizer(converted, "%");
      StringBuffer buf =
        new StringBuffer(converted.length() + XML.length());

      while (tokens.hasMoreTokens()) {
        buf.append(tokens.nextToken());
      }

      buf.append(XML);

      File file = new File(path, buf.toString());

      return file;
    } catch (UnsupportedEncodingException uex) {
      throw new RuntimeException("URLGR[fBO[" + enc + "]gpł܂B",
        uex);
    }
  }

  /**
   * DOCUMENT ME!
   *
   * @param page
   *
   * @throws RuntimeException DOCUMENT ME!
   *
   * @see cx.ath.kgslab.wiki.PageManager#putPage(cx.ath.kgslab.wiki.pages.Page)
   */
  public void writePage(Page page) {
    String name = page.getTitle();
    String path = page.getPath();

    if ((path != null) && (path.length() > 0)) {
      path = path + "/" + name;
    } else {
      path = name;
    }

    File file = getFile(path);
    FileOutputStream fos = null;
    Writer writer = null;
    FileLock fileLock = null;

    try {
      page.setLastModified(new Date());
      fos = new FileOutputStream(file);
      fileLock = fos.getChannel().lock();
      writer = new OutputStreamWriter(fos, enc);
      Marshaller m = new Marshaller(writer);

      m.setEncoding(enc);
      m.marshal(page);
    } catch (FileNotFoundException e) {
      throw new RuntimeException(e);
    } catch (MarshalException e) {
      throw new RuntimeException(e);
    } catch (ValidationException e) {
      throw new RuntimeException(e);
    } catch (IOException e) {
      throw new RuntimeException(e);
    } finally {
      try {
        if (writer != null) {
          writer.close();
        }

        if (fileLock != null) {
          fileLock.release();
        }
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }
  }
}
