/*
 * $Id: WikiService.java,v 1.3 2004/07/02 00:53:17 mashu Exp $
 */
package cx.ath.kgslab.wiki.service;

import cx.ath.kgslab.util.DateUtils;
import cx.ath.kgslab.wiki.JaJaWikiConfig;
import cx.ath.kgslab.wiki.PageManager;
import cx.ath.kgslab.wiki.pages.Page;

import org.springframework.remoting.jaxrpc.ServletEndpointSupport;

import java.rmi.RemoteException;

import java.util.Date;


/**
 * Wiki WebT[rX̎NX PageManagerDelegatesĂB
 *
 * @author VM
 * @version 4.0
 *
 * @since JaJaWiki 2.1
 */
public class WikiService extends ServletEndpointSupport implements Wiki {
  /** y[W}l[W */
  PageManager pageManager = null;

  /** JaJaWikiݒ */
  JaJaWikiConfig config = null;

  /**
   * RXgN^
   */
  public WikiService() {
  }

  /**
   * 
   * @see org.springframework.remoting.jaxrpc.ServletEndpointSupport#onInit()
   */
  protected void onInit() {
    this.config = (JaJaWikiConfig) getWebApplicationContext().getBean("config");
    this.pageManager = (PageManager) getWebApplicationContext().getBean("pageManager");
  }

  /**
   * w肵y[W폜B y[WĂɉȂB
   *
   * @param name y[W
   *
   * @throws RemoteException
   * @throws PageWriteException
   */
  public void deletePage(String name) throws RemoteException {
    try {
      pageManager.deletePage(name);
    } catch (cx.ath.kgslab.wiki.exception.PageWriteException e) {
      throw new PageWriteException("y[W̍폜Ɏs܂", e);
    }
  }

  /**
   * w肵y[W̏擾B
   *
   * @param name y[W
   *
   * @return y[We
   *
   * @throws RemoteException
   * @throws PageReadException
   */
  public PageContent getPage(String name) throws RemoteException {
    try {
      Page page = pageManager.getPage(name);

      if (page == null) {
        throw new PageNotFoundException(name);
      }

      PageContent result = new PageContent();

      result.setContent(page.getContent());
      result.setTitle(page.getTitle());

      result.setLastModified(DateUtils.formatISODateTime(page.getLastModified()));

      return result;
    } catch (cx.ath.kgslab.wiki.exception.PageReadException e) {
      throw new PageReadException("y[W̓ǂݍ݂Ɏs܂", e);
    }
  }

  /**
   * y[WXVB
   *
   * @param name y[W
   * @param content y[We
   * @param lastmodified ŏIXV
   *
   * @throws RemoteException
   * @throws PageReadException
   * @throws PageWriteException
   */
  public void putPage(String name, String content, String lastmodified)
    throws RemoteException {
    try {
      //y[WXV
      Page page = pageManager.getPage(name);

      if (page != null) {
        Date origTime = page.getLastModified();

        if (origTime != null) {
          long orig = origTime.getTime();
          long time = DateUtils.parseISODateTime(lastmodified).getTimeInMillis();

          if (orig != time) {
            throw new PageModifiedException(page.getTitle());
          }
        }

        if (page.getLocked()) {
          throw new PageLockedException();
        }

        page.setContent(content);
      } else {
        page = new Page();
        page.setTitle(name);
        page.setContent(content);
      }

      page.setLastModified(new Date());
      pageManager.putPage(page);
    } catch (cx.ath.kgslab.wiki.exception.PageReadException e) {
      throw new PageReadException("y[W̓ǂݍ݂Ɏs܂", e);
    } catch (cx.ath.kgslab.wiki.exception.PageWriteException e) {
      throw new PageWriteException("y[W݂̏Ɏs܂", e);
    }
  }

  /**
   * y[W̖Ƀy[WeǉB
   *
   * @param name y[W
   * @param content y[We
   *
   * @throws RemoteException
   * @throws PageReadException
   * @throws PageWriteException
   */
  public void appendPage(String name, String content) throws RemoteException {
    try {
      //y[WXV
      Page page = pageManager.getPage(name);

      if (page != null) {
        if (page.getLocked()) {
          throw new PageLockedException();
        }

        page.setContent(page.getContent() + "\n" + content);
      } else {
        page = new Page();
        page.setTitle(name);
        page.setContent(content);
      }

      page.setLastModified(new Date());
      pageManager.putPage(page);
    } catch (cx.ath.kgslab.wiki.exception.PageReadException e) {
      throw new PageReadException("y[W̓ǂݍ݂Ɏs܂", e);
    } catch (cx.ath.kgslab.wiki.exception.PageWriteException e) {
      throw new PageWriteException("y[W݂̏Ɏs܂", e);
    }
  }

  /**
   * y[W̃pX[h`FbNB
   *
   * @param name y[W
   * @param password
   *
   * @return true: pX[hOK false: pX[hNG
   *
   * @throws RemoteException
   * @throws PageReadException
   */
  public boolean checkPassword(String name, String password)
    throws RemoteException {
    try {
      return pageManager.checkPassword(name, password);
    } catch (cx.ath.kgslab.wiki.exception.PageReadException e) {
      throw new PageReadException("y[W̓ǂݍ݂Ɏs܂", e);
    }
  }

  /**
   * w肵y[W邩ǂ`FbNB
   *
   * @param name y[W
   *
   * @return true: y[W݂ false:y[W݂Ȃ
   *
   * @throws RemoteException
   * @throws PageReadException
   */
  public boolean existsPage(String name) throws RemoteException {
    try {
      return pageManager.existsPage(name);
    } catch (cx.ath.kgslab.wiki.exception.PageReadException e) {
      throw new PageReadException("y[W̓ǂݍ݂Ɏs܂", e);
    }
  }

  /**
   * Ytt@C̃Abv[htH_擾B
   *
   * @return tH_Path
   */
  public String getUploadPath() {
    return config.getUploadPath().toString();
  }
}
