package cx.ath.kgslab.webutil.axis.server;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.server.ServletEndpointContext;

import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.ser.BaseDeserializerFactory;
import org.apache.axis.encoding.ser.BaseSerializerFactory;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.fromJava.Namespaces;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;


/**
 * Spring Bean Handler.
 * SpringBeanEFuT[rXƂČJB
 * JWSHandler̎x[XɁAS2AxisS2Handler̎Qlɍ쐬B
 * @author NAGASAWA Takahiro
 * @see org.apache.axis.handlers.JWSHandler
 * @see org.seasar.axis.server.S2Handler
 */
public class SpringBeanHandler extends BasicHandler {
  private final Map soapServices = new HashMap();

  //  private ServletEndpointContext servletEndpointContext = null;
  private WebApplicationContext webApplicationContext = null;

  /**
   * @param msgContext bZ[WReLXg
   * @throws AxisFault
   * @see org.apache.axis.Handler#invoke(org.apache.axis.MessageContext)
   */
  public void invoke(final MessageContext msgContext)
    throws AxisFault {
    try {
      setupService(msgContext);
    } catch (final Exception e) {
      log.error(Messages.getMessage("exception00"), e);
      throw AxisFault.makeFault(e);
    }
  }

  /**
   *
   * @param msgContext bZ[WReLXg
   * @throws Exception
   */
  protected void setupService(final MessageContext msgContext)
    throws Exception {
    if (webApplicationContext == null) {
      ServletEndpointContext servletEndpointContext =
        (ServletEndpointContext) msgContext.getProperty(
          "servletEndpointContext");

      ServletContext servletContext =
        servletEndpointContext.getServletContext();
      webApplicationContext =
        WebApplicationContextUtils
        .getRequiredWebApplicationContext(servletContext);
    }

    final String componentName = getComponentName(msgContext);

    if (componentName == null) {
      return;
    }

    msgContext.setService(getService(msgContext, componentName));
  }

  /**
   * pX͂āAR|[lg擾.
   * <br/>
   * pXR|[lgɕϊƂɂ́A
   * 擪'/''@'ɒuǍ'/''.'ɒuB
   * @param msgContext bZ[WReLXg
   * @return R|[lg
   */
  protected String getComponentName(
    final MessageContext msgContext) {
    final String pathInfo =
      (String) msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETPATHINFO);

    if ((pathInfo == null) || (pathInfo.length() == 0)) {
      return null;
    }

    return "@" + pathInfo.substring(1).replace('/', '.');
  }

  /**
   *
   * @param msgContext bZ[WReLXg
   * @param componentName R|[lg
   * @return
   * @throws AxisFault
   */
  protected SOAPService getService(
    final MessageContext msgContext, final String componentName)
    throws AxisFault {
    SOAPService soapService =
      (SOAPService) soapServices.get(componentName);

    if (soapService == null) {
      soapService = createService(msgContext, componentName);
      soapServices.put(componentName, soapService);
    }

    soapService.setEngine(msgContext.getAxisEngine());
    soapService.init(); // ??

    return soapService;
  }

  /**
   * T[rX̐
   * @param msgContext bZ[WReLXg
   * @param componentName R|[lg
   * @return T[rX
   * @throws AxisFault
   */
  protected SOAPService createService(
    final MessageContext msgContext, final String componentName)
    throws AxisFault {
    final SOAPService soapService =
      new SOAPService(new SpringRPCProvider());
    final Object bean =
      webApplicationContext.getBean(componentName);

    if (bean instanceof AxisExporter) {
      final AxisExporter exporter = (AxisExporter) bean;
      final Class beanClass = exporter.getBean().getClass();
      final String componentClassName = beanClass.getName();
      soapService.setName(componentClassName);
      soapService.setOption(SpringRPCProvider.OPTION_CLASSNAME,
        componentClassName);
      soapService.setOption(SpringRPCProvider.OPTION_APPLICATION_CONTEXT,
        webApplicationContext);
      soapService.setOption(SpringRPCProvider.OPTION_COMPONENT_NAME,
        componentName);
      soapService.getInitializedServiceDesc(msgContext);

      final TypeMappingRegistry regs =
        msgContext.getTypeMappingRegistry();
      final SerializerSetting[] settings =
        exporter.getSerializerSettings();

      for (int i = 0; i < settings.length; i++) {
        registerTypeMapping(settings[i], regs);
      }

    }

    return soapService;
  }

  /**
   * @param clazz
   * @param regs
   */
  private void registerTypeMapping(
    final SerializerSetting setting,
    TypeMappingRegistry regs) {
    final Class clazz = setting.getBeanClass();
    final String namespace = getNamespaceFromClass(clazz);
    TypeMapping mapping =
      (TypeMapping) regs.getTypeMapping(namespace);

    if (mapping == null) {
      mapping = (TypeMapping) regs.createTypeMapping();
      regs.register(namespace, mapping);
    }

    final QName qname = getQNameFromClass(clazz);

    if (!mapping.isRegistered(clazz, qname)) {
      Class serializer = setting.getSeralizerClass();
      if (serializer == null) {
        serializer = BeanSerializerFactory.class;
      }
      Class deserializer = setting.getDeserializerClass();
      if (deserializer == null) {
        deserializer = BeanDeserializerFactory.class;
      }
      mapping.register(clazz, qname,
        BaseSerializerFactory.createFactory(serializer, clazz,
          qname),
        BaseDeserializerFactory.createFactory(deserializer,
          clazz, qname));
    }
  }

  private String getNamespaceFromClass(Class type) {
    return Namespaces.makeNamespace(type.getName());
  }

  private QName getQNameFromClass(Class type) {
    String name = type.getName();

    return new QName(getNamespaceFromClass(type),
      name.substring(name.lastIndexOf('.') + 1));
  }

  /**
   * WSDL̐.
   * @param msgContext bZ[WReLXg
   */
  public void generateWSDL(MessageContext msgContext)
    throws AxisFault {
    try {
      setupService(msgContext);
    } catch (Exception e) {
      log.error(Messages.getMessage("exception00"), e);
      throw AxisFault.makeFault(e);
    }
  }
}
