/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.core;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Constants;
import org.springframework.jms.JmsException;
import org.springframework.jms.connection.ConnectionHolder;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.core.MessagePostProcessor;
import org.springframework.jms.core.ProducerCallback;
import org.springframework.jms.core.SessionCallback;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.SimpleMessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jms.support.destination.DynamicDestinationResolver;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class JmsTemplate
implements JmsOperations,
InitializingBean {
    public static final long DEFAULT_RECEIVE_TIMEOUT = -1L;
    private static final Constants constants = new Constants(class$javax$jms$Session == null ? (class$javax$jms$Session = JmsTemplate.class$("javax.jms.Session")) : class$javax$jms$Session);
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ConnectionFactory connectionFactory;
    private boolean pubSubDomain = false;
    private boolean sessionTransacted = false;
    private int sessionAcknowledgeMode = 1;
    private Destination defaultDestination;
    private DestinationResolver destinationResolver;
    private MessageConverter messageConverter;
    private long receiveTimeout = -1L;
    private boolean explicitQosEnabled;
    private int deliveryMode;
    private int priority;
    private long timeToLive;
    static /* synthetic */ Class class$javax$jms$Session;

    public JmsTemplate() {
        this.initDefaultStrategies();
    }

    public JmsTemplate(ConnectionFactory connectionFactory) {
        this();
        this.setConnectionFactory(connectionFactory);
        this.afterPropertiesSet();
    }

    protected void initDefaultStrategies() {
        this.setDestinationResolver(new DynamicDestinationResolver());
        this.setMessageConverter(new SimpleMessageConverter());
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setPubSubDomain(boolean pubSubDomain) {
        this.pubSubDomain = pubSubDomain;
    }

    public boolean isPubSubDomain() {
        return this.pubSubDomain;
    }

    public void setSessionTransacted(boolean sessionTransacted) {
        this.sessionTransacted = sessionTransacted;
    }

    public boolean isSessionTransacted() {
        return this.sessionTransacted;
    }

    public void setSessionAcknowledgeModeName(String constantName) {
        this.setSessionAcknowledgeMode(constants.asNumber(constantName).intValue());
    }

    public void setSessionAcknowledgeMode(int sessionAcknowledgeMode) {
        this.sessionAcknowledgeMode = sessionAcknowledgeMode;
    }

    public int getSessionAcknowledgeMode() {
        return this.sessionAcknowledgeMode;
    }

    public void setDefaultDestination(Destination destination) {
        this.defaultDestination = destination;
    }

    public Destination getDefaultDestination() {
        return this.defaultDestination;
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    public DestinationResolver getDestinationResolver() {
        return this.destinationResolver;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setExplicitQosEnabled(boolean explicitQosEnabled) {
        this.explicitQosEnabled = explicitQosEnabled;
    }

    public boolean isExplicitQosEnabled() {
        return this.explicitQosEnabled;
    }

    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void afterPropertiesSet() {
        if (this.connectionFactory == null) {
            throw new IllegalArgumentException("connectionFactory is required");
        }
    }

    protected Connection createConnection() throws JMSException {
        return this.getConnectionFactory().createConnection();
    }

    protected Session createSession(Connection con) throws JMSException {
        return con.createSession(this.isSessionTransacted(), this.getSessionAcknowledgeMode());
    }

    protected MessageProducer createProducer(Session session, Destination destination) throws JMSException {
        return session.createProducer(destination);
    }

    protected MessageConsumer createConsumer(Session session, Destination destination) throws JMSException {
        return session.createConsumer(destination);
    }

    protected Destination resolveDestinationName(Session session, String destinationName) throws JMSException {
        return this.getDestinationResolver().resolveDestinationName(session, destinationName, this.isPubSubDomain());
    }

    protected JmsException convertJmsAccessException(JMSException ex) {
        return JmsUtils.convertJmsAccessException(ex);
    }

    public Object execute(SessionCallback action, boolean startConnection) throws JmsException {
        Object object;
        Connection con = null;
        Session session = null;
        try {
            Connection conToUse = null;
            Session sessionToUse = null;
            ConnectionHolder conHolder = (ConnectionHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.getConnectionFactory()));
            if (conHolder != null) {
                conToUse = conHolder.getConnection();
                if (startConnection) {
                    conToUse.start();
                }
                sessionToUse = conHolder.getSession();
            } else {
                con = this.createConnection();
                if (startConnection) {
                    con.start();
                }
                session = this.createSession(con);
                conToUse = con;
                sessionToUse = session;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Executing callback on JMS session [" + sessionToUse + "] from connection [" + conToUse + "]"));
            }
            object = action.doInJms(sessionToUse);
        }
        catch (JMSException ex) {
            try {
                throw this.convertJmsAccessException(ex);
            }
            catch (Throwable throwable) {
                JmsUtils.closeSession(session);
                JmsUtils.closeConnection(con);
                throw throwable;
            }
        }
        JmsUtils.closeSession(session);
        JmsUtils.closeConnection(con);
        return object;
    }

    public Object execute(SessionCallback action) throws JmsException {
        return this.execute(action, false);
    }

    public Object execute(final ProducerCallback action) throws JmsException {
        return this.execute(new SessionCallback(){

            public Object doInJms(Session session) throws JMSException {
                MessageProducer producer = JmsTemplate.this.createProducer(session, null);
                return action.doInJms(session, producer);
            }
        });
    }

    public void send(MessageCreator messageCreator) throws JmsException {
        if (this.getDefaultDestination() == null) {
            throw new IllegalStateException("No defaultDestination specified. Check configuration of JmsTemplate.");
        }
        this.send(this.getDefaultDestination(), messageCreator);
    }

    public void send(final Destination destination, final MessageCreator messageCreator) throws JmsException {
        this.execute(new SessionCallback(){

            public Object doInJms(Session session) throws JMSException {
                JmsTemplate.this.doSend(session, destination, messageCreator);
                return null;
            }
        });
    }

    public void send(final String destinationName, final MessageCreator messageCreator) throws JmsException {
        this.execute(new SessionCallback(){

            public Object doInJms(Session session) throws JMSException {
                Destination destination = JmsTemplate.this.resolveDestinationName(session, destinationName);
                JmsTemplate.this.doSend(session, destination, messageCreator);
                return null;
            }
        });
    }

    protected void doSend(Session session, Destination destination, MessageCreator messageCreator) throws JMSException {
        MessageProducer producer = this.createProducer(session, destination);
        Message message = messageCreator.createMessage(session);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Sending created message [" + message + "]"));
        }
        this.doSend(producer, message);
        if (session.getTransacted() && !TransactionSynchronizationManager.hasResource((Object)this.getConnectionFactory())) {
            session.commit();
        }
    }

    protected void doSend(MessageProducer producer, Message message) throws JMSException {
        if (this.isExplicitQosEnabled()) {
            producer.send(message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
        } else {
            producer.send(message);
        }
    }

    public void convertAndSend(Object message) throws JmsException {
        if (this.getDefaultDestination() == null) {
            throw new IllegalStateException("No defaultDestination specified. Check configuration of JmsTemplate.");
        }
        this.convertAndSend(this.getDefaultDestination(), message);
    }

    public void convertAndSend(Destination destination, final Object message) throws JmsException {
        if (this.getMessageConverter() == null) {
            throw new IllegalStateException("No MessageConverter registered. Check configuration of JmsTemplate.");
        }
        this.send(destination, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                return JmsTemplate.this.getMessageConverter().toMessage(message, session);
            }
        });
    }

    public void convertAndSend(String destinationName, final Object message) throws JmsException {
        if (this.getMessageConverter() == null) {
            throw new IllegalStateException("No MessageConverter registered. Check configuration of JmsTemplate.");
        }
        this.send(destinationName, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                return JmsTemplate.this.getMessageConverter().toMessage(message, session);
            }
        });
    }

    public void convertAndSend(Object message, MessagePostProcessor postProcessor) throws JmsException {
        if (this.getDefaultDestination() == null) {
            throw new IllegalStateException("No defaultDestination specified. Check configuration of JmsTemplate.");
        }
        this.convertAndSend(this.getDefaultDestination(), message, postProcessor);
    }

    public void convertAndSend(Destination destination, final Object message, final MessagePostProcessor postProcessor) throws JmsException {
        if (this.getMessageConverter() == null) {
            throw new IllegalStateException("No MessageConverter registered. Check configuration of JmsTemplate.");
        }
        this.send(destination, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                Message m = JmsTemplate.this.getMessageConverter().toMessage(message, session);
                return postProcessor.postProcessMessage(m);
            }
        });
    }

    public void convertAndSend(String destinationName, final Object message, final MessagePostProcessor postProcessor) throws JmsException {
        if (this.getMessageConverter() == null) {
            throw new IllegalStateException("No MessageConverter registered. Check configuration of JmsTemplate.");
        }
        this.send(destinationName, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                Message m = JmsTemplate.this.getMessageConverter().toMessage(message, session);
                return postProcessor.postProcessMessage(m);
            }
        });
    }

    public Message receive() throws JmsException {
        if (this.getDefaultDestination() == null) {
            throw new IllegalStateException("No defaultDestination specified. Check configuration of JmsTemplate.");
        }
        return this.receive(this.getDefaultDestination());
    }

    public Message receive(final Destination destination) throws JmsException {
        return (Message)this.execute(new SessionCallback(){

            public Object doInJms(Session session) throws JMSException {
                return JmsTemplate.this.doReceive(session, destination);
            }
        }, true);
    }

    public Message receive(final String destinationName) throws JmsException {
        return (Message)this.execute(new SessionCallback(){

            public Object doInJms(Session session) throws JMSException {
                Destination destination = JmsTemplate.this.resolveDestinationName(session, destinationName);
                return JmsTemplate.this.doReceive(session, destination);
            }
        }, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message doReceive(Session session, Destination destination) throws JMSException {
        MessageConsumer consumer = this.createConsumer(session, destination);
        try {
            Message message;
            long timeout = this.getReceiveTimeout();
            ConnectionHolder conHolder = (ConnectionHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.getConnectionFactory()));
            if (conHolder != null && conHolder.hasTimeout()) {
                timeout = conHolder.getTimeToLiveInMillis();
            }
            Message message2 = message = timeout >= 0L ? consumer.receive(timeout) : consumer.receive();
            if (session.getTransacted()) {
                if (conHolder == null) {
                    session.commit();
                }
            } else if (message != null && this.isClientAcknowledge(session)) {
                message.acknowledge();
            }
            Message message3 = message;
            return message3;
        }
        finally {
            JmsUtils.closeMessageConsumer(consumer);
        }
    }

    protected boolean isClientAcknowledge(Session session) throws JMSException {
        return session.getAcknowledgeMode() == 2;
    }

    public Object receiveAndConvert() throws JmsException {
        if (this.getMessageConverter() == null) {
            throw new IllegalStateException("No MessageConverter registered. Check configuration of JmsTemplate.");
        }
        return this.doConvertFromMessage(this.receive());
    }

    public Object receiveAndConvert(Destination destination) throws JmsException {
        if (this.getMessageConverter() == null) {
            throw new IllegalStateException("No MessageConverter registered. Check configuration of JmsTemplate.");
        }
        return this.doConvertFromMessage(this.receive(destination));
    }

    public Object receiveAndConvert(String destinationName) throws JmsException {
        if (this.getMessageConverter() == null) {
            throw new IllegalStateException("No MessageConverter registered. Check configuration of JmsTemplate.");
        }
        return this.doConvertFromMessage(this.receive(destinationName));
    }

    protected Object doConvertFromMessage(Message message) {
        try {
            return this.getMessageConverter().fromMessage(message);
        }
        catch (JMSException ex) {
            throw this.convertJmsAccessException(ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

