/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.CglibSubclassingInstantiationStrategy;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.CollectionFactory;

public abstract class AbstractAutowireCapableBeanFactory
extends AbstractBeanFactory
implements AutowireCapableBeanFactory {
    private InstantiationStrategy instantiationStrategy = new CglibSubclassingInstantiationStrategy();
    private final Map disposableInnerBeans = Collections.synchronizedMap(new HashMap());
    private final Map dependentBeanMap = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$org$springframework$beans$factory$DisposableBean;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$DestructionAwareBeanPostProcessor;

    public AbstractAutowireCapableBeanFactory() {
    }

    public AbstractAutowireCapableBeanFactory(BeanFactory parentBeanFactory) {
        super(parentBeanFactory);
    }

    protected void setInstantiationStrategy(InstantiationStrategy instantiationStrategy) {
        this.instantiationStrategy = instantiationStrategy;
    }

    public Object autowire(Class beanClass, int autowireMode, boolean dependencyCheck) throws BeansException {
        RootBeanDefinition bd = new RootBeanDefinition(beanClass, autowireMode, dependencyCheck);
        if (bd.getResolvedAutowireMode() == 3) {
            return this.autowireConstructor(beanClass.getName(), bd).getWrappedInstance();
        }
        Object bean = this.instantiationStrategy.instantiate(bd, null, this);
        this.populateBean(bean.getClass().getName(), bd, new BeanWrapperImpl(bean));
        return bean;
    }

    public void autowireBeanProperties(Object existingBean, int autowireMode, boolean dependencyCheck) throws BeansException {
        if (autowireMode != 1 && autowireMode != 2) {
            throw new IllegalArgumentException("Just constants AUTOWIRE_BY_NAME and AUTOWIRE_BY_TYPE allowed");
        }
        RootBeanDefinition bd = new RootBeanDefinition(existingBean.getClass(), autowireMode, dependencyCheck);
        this.populateBean(existingBean.getClass().getName(), bd, new BeanWrapperImpl(existingBean));
    }

    public void applyBeanPropertyValues(Object existingBean, String name) throws BeansException {
        RootBeanDefinition bd = this.getMergedBeanDefinition(name, true);
        this.applyPropertyValues(name, bd, new BeanWrapperImpl(existingBean), bd.getPropertyValues());
    }

    public Object applyBeanPostProcessorsBeforeInitialization(Object bean, String name) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking BeanPostProcessors before initialization of bean '" + name + "'"));
        }
        Object result = bean;
        Iterator it = this.getBeanPostProcessors().iterator();
        while (it.hasNext()) {
            BeanPostProcessor beanProcessor = (BeanPostProcessor)it.next();
            result = beanProcessor.postProcessBeforeInitialization(result, name);
            if (result != null) continue;
            throw new BeanCreationException("postProcessBeforeInitialization method of BeanPostProcessor [" + beanProcessor + "] returned null for bean [" + result + "] with name [" + name + "]");
        }
        return result;
    }

    public Object applyBeanPostProcessorsAfterInitialization(Object bean, String name) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking BeanPostProcessors after initialization of bean '" + name + "'"));
        }
        Object result = bean;
        Iterator it = this.getBeanPostProcessors().iterator();
        while (it.hasNext()) {
            BeanPostProcessor beanProcessor = (BeanPostProcessor)it.next();
            result = beanProcessor.postProcessAfterInitialization(result, name);
            if (result != null) continue;
            throw new BeanCreationException("postProcessAfterInitialization method of BeanPostProcessor [" + beanProcessor + "] returned null for bean [" + result + "] with name [" + name + "]");
        }
        return result;
    }

    protected Object createBean(String beanName, RootBeanDefinition mergedBeanDefinition, Object[] args) throws BeansException {
        return this.createBean(beanName, mergedBeanDefinition, args, true);
    }

    protected Object createBean(String beanName, RootBeanDefinition mergedBeanDefinition, Object[] args, boolean allowEagerCaching) throws BeansException {
        String[] dependsOn;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating instance of bean '" + beanName + "' with merged definition [" + mergedBeanDefinition + "]"));
        }
        if (mergedBeanDefinition.getDependsOn() != null) {
            for (int i = 0; i < mergedBeanDefinition.getDependsOn().length; ++i) {
                this.getBean(mergedBeanDefinition.getDependsOn()[i]);
            }
        }
        BeanWrapper instanceWrapper = null;
        Object bean = null;
        String errorMessage = null;
        boolean eagerlyCached = false;
        try {
            errorMessage = "Instantiation of bean failed";
            if (mergedBeanDefinition.getFactoryMethodName() != null) {
                instanceWrapper = this.instantiateUsingFactoryMethod(beanName, mergedBeanDefinition, args);
            } else if (mergedBeanDefinition.getResolvedAutowireMode() == 3 || mergedBeanDefinition.hasConstructorArgumentValues()) {
                instanceWrapper = this.autowireConstructor(beanName, mergedBeanDefinition);
            } else {
                Object beanInstance = this.instantiationStrategy.instantiate(mergedBeanDefinition, beanName, this);
                instanceWrapper = new BeanWrapperImpl(beanInstance);
                this.initBeanWrapper(instanceWrapper);
            }
            bean = instanceWrapper.getWrappedInstance();
            if (allowEagerCaching && mergedBeanDefinition.isSingleton()) {
                this.addSingleton(beanName, bean);
                eagerlyCached = true;
            }
            errorMessage = "Initialization of bean failed";
            this.populateBean(beanName, mergedBeanDefinition, instanceWrapper);
            if (bean instanceof BeanNameAware) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Invoking setBeanName on BeanNameAware bean '" + beanName + "'"));
                }
                ((BeanNameAware)bean).setBeanName(beanName);
            }
            if (bean instanceof BeanFactoryAware) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Invoking setBeanFactory on BeanFactoryAware bean '" + beanName + "'"));
                }
                ((BeanFactoryAware)bean).setBeanFactory(this);
            }
            bean = this.applyBeanPostProcessorsBeforeInitialization(bean, beanName);
            this.invokeInitMethods(beanName, mergedBeanDefinition, bean);
            bean = this.applyBeanPostProcessorsAfterInitialization(bean, beanName);
        }
        catch (BeanCreationException ex) {
            if (eagerlyCached) {
                this.removeSingleton(beanName);
            }
            throw ex;
        }
        catch (Throwable ex) {
            if (eagerlyCached) {
                this.removeSingleton(beanName);
            }
            throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, errorMessage, ex);
        }
        if (mergedBeanDefinition.isSingleton() && (dependsOn = mergedBeanDefinition.getDependsOn()) != null) {
            for (int i = 0; i < dependsOn.length; ++i) {
                this.registerDependentBean(dependsOn[i], beanName);
            }
        }
        return bean;
    }

    protected BeanWrapper instantiateUsingFactoryMethod(String beanName, RootBeanDefinition mergedBeanDefinition, Object[] args) throws BeansException {
        ConstructorArgumentValues cargs = mergedBeanDefinition.getConstructorArgumentValues();
        ConstructorArgumentValues resolvedValues = new ConstructorArgumentValues();
        int expectedArgCount = 0;
        if (args == null) {
            expectedArgCount = cargs.getArgumentCount();
            this.resolveConstructorArguments(beanName, mergedBeanDefinition, cargs, resolvedValues);
        } else {
            expectedArgCount = args.length;
        }
        BeanWrapperImpl bw = new BeanWrapperImpl();
        this.initBeanWrapper(bw);
        boolean isStatic = true;
        Class<?> factoryClass = null;
        if (mergedBeanDefinition.getFactoryBeanName() != null) {
            factoryClass = this.getBean(mergedBeanDefinition.getFactoryBeanName()).getClass();
            isStatic = false;
        } else {
            factoryClass = mergedBeanDefinition.getBeanClass();
        }
        for (int i = 0; i < factoryClass.getMethods().length; ++i) {
            Method factoryMethod;
            block8: {
                factoryMethod = factoryClass.getMethods()[i];
                if (Modifier.isStatic(factoryMethod.getModifiers()) != isStatic || !factoryMethod.getName().equals(mergedBeanDefinition.getFactoryMethodName()) || factoryMethod.getParameterTypes().length != expectedArgCount) continue;
                Class[] argTypes = factoryMethod.getParameterTypes();
                try {
                    if (args != null) break block8;
                    args = this.createArgumentArray(beanName, mergedBeanDefinition, resolvedValues, bw, argTypes);
                }
                catch (Exception ex) {
                    continue;
                }
            }
            Object beanInstance = this.instantiationStrategy.instantiate(mergedBeanDefinition, beanName, (BeanFactory)this, factoryMethod, args);
            bw.setWrappedInstance(beanInstance);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Bean '" + beanName + "' instantiated via factory method [" + factoryMethod + "]"));
            }
            return bw;
        }
        throw new BeanDefinitionStoreException("Cannot find matching factory method '" + mergedBeanDefinition.getFactoryMethodName() + "' on class " + factoryClass);
    }

    protected BeanWrapper autowireConstructor(String beanName, RootBeanDefinition mergedBeanDefinition) throws BeansException {
        ConstructorArgumentValues cargs = mergedBeanDefinition.getConstructorArgumentValues();
        ConstructorArgumentValues resolvedValues = new ConstructorArgumentValues();
        BeanWrapperImpl bw = new BeanWrapperImpl();
        this.initBeanWrapper(bw);
        int minNrOfArgs = 0;
        if (cargs != null) {
            minNrOfArgs = this.resolveConstructorArguments(beanName, mergedBeanDefinition, cargs, resolvedValues);
        }
        Constructor<?>[] constructors = mergedBeanDefinition.getBeanClass().getDeclaredConstructors();
        Arrays.sort(constructors, new Comparator(){

            public int compare(Object o1, Object o2) {
                boolean p2;
                Constructor c1 = (Constructor)o1;
                Constructor c2 = (Constructor)o2;
                boolean p1 = Modifier.isPublic(c1.getModifiers());
                if (p1 != (p2 = Modifier.isPublic(c2.getModifiers()))) {
                    return p1 ? -1 : 1;
                }
                int c1pl = c1.getParameterTypes().length;
                int c2pl = c2.getParameterTypes().length;
                return new Integer(c1pl).compareTo(new Integer(c2pl)) * -1;
            }
        });
        Constructor<?> constructorToUse = null;
        Object[] argsToUse = null;
        int minTypeDiffWeight = Integer.MAX_VALUE;
        for (int i = 0; i < constructors.length; ++i) {
            try {
                Object[] args;
                Constructor<?> constructor = constructors[i];
                if (constructor.getParameterTypes().length < minNrOfArgs) {
                    throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, minNrOfArgs + " constructor arguments specified but no matching constructor found in bean '" + beanName + "' (hint: specify index arguments for simple parameters to avoid type ambiguities)");
                }
                Class[] argTypes = constructor.getParameterTypes();
                int typeDiffWeight = this.getTypeDifferenceWeight(argTypes, args = this.createArgumentArray(beanName, mergedBeanDefinition, resolvedValues, bw, argTypes));
                if (typeDiffWeight >= minTypeDiffWeight) continue;
                constructorToUse = constructor;
                argsToUse = args;
                minTypeDiffWeight = typeDiffWeight;
                continue;
            }
            catch (BeansException ex) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Ignoring constructor [" + constructors[i] + "] of bean '" + beanName + "': could not satisfy dependencies. Detail: " + ex.getMessage()));
                }
                if (i != constructors.length - 1 || constructorToUse != null) continue;
                throw ex;
            }
        }
        if (constructorToUse == null) {
            throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, "Could not resolve matching constructor");
        }
        Object beanInstance = this.instantiationStrategy.instantiate(mergedBeanDefinition, beanName, (BeanFactory)this, constructorToUse, argsToUse);
        bw.setWrappedInstance(beanInstance);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Bean '" + beanName + "' instantiated via constructor [" + constructorToUse + "]"));
        }
        return bw;
    }

    private int resolveConstructorArguments(String beanName, RootBeanDefinition mergedBeanDefinition, ConstructorArgumentValues cargs, ConstructorArgumentValues resolvedValues) {
        int minNrOfArgs = cargs.getArgumentCount();
        Iterator it = cargs.getIndexedArgumentValues().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            int index = (Integer)entry.getKey();
            if (index < 0) {
                throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, "Invalid constructor argument index: " + index);
            }
            if (index > minNrOfArgs) {
                minNrOfArgs = index + 1;
            }
            String argName = "constructor argument with index " + index;
            ConstructorArgumentValues.ValueHolder valueHolder = (ConstructorArgumentValues.ValueHolder)entry.getValue();
            Object resolvedValue = this.resolveValueIfNecessary(beanName, mergedBeanDefinition, argName, valueHolder.getValue());
            resolvedValues.addIndexedArgumentValue(index, resolvedValue, valueHolder.getType());
        }
        it = cargs.getGenericArgumentValues().iterator();
        while (it.hasNext()) {
            ConstructorArgumentValues.ValueHolder valueHolder = (ConstructorArgumentValues.ValueHolder)((Object)it.next());
            String argName = "constructor argument";
            Object resolvedValue = this.resolveValueIfNecessary(beanName, mergedBeanDefinition, argName, valueHolder.getValue());
            resolvedValues.addGenericArgumentValue(resolvedValue, valueHolder.getType());
        }
        return minNrOfArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] createArgumentArray(String beanName, RootBeanDefinition mergedBeanDefinition, ConstructorArgumentValues resolvedValues, BeanWrapperImpl bw, Class[] argTypes) {
        Object[] args = new Object[argTypes.length];
        HashSet<ConstructorArgumentValues.ValueHolder> usedValueHolders = new HashSet<ConstructorArgumentValues.ValueHolder>(argTypes.length);
        for (int j = 0; j < argTypes.length; ++j) {
            ConstructorArgumentValues.ValueHolder valueHolder = resolvedValues.getArgumentValue(j, argTypes[j]);
            if (valueHolder != null && !usedValueHolders.contains(valueHolder)) {
                usedValueHolders.add(valueHolder);
                if (!this.getCustomEditors().isEmpty()) {
                    Map map = this.getCustomEditors();
                    synchronized (map) {
                        args[j] = bw.doTypeConversionIfNecessary(valueHolder.getValue(), argTypes[j]);
                        continue;
                    }
                }
                args[j] = bw.doTypeConversionIfNecessary(valueHolder.getValue(), argTypes[j]);
                continue;
            }
            if (mergedBeanDefinition.getResolvedAutowireMode() != 3) {
                throw new UnsatisfiedDependencyException(mergedBeanDefinition.getResourceDescription(), beanName, j, argTypes[j], "Did you specify the correct bean references as generic constructor arguments?");
            }
            Map matchingBeans = this.findMatchingBeans(argTypes[j]);
            if (matchingBeans == null || matchingBeans.size() != 1) {
                throw new UnsatisfiedDependencyException(mergedBeanDefinition.getResourceDescription(), beanName, j, argTypes[j], "There are " + matchingBeans.size() + " beans of type [" + argTypes[j] + "] for autowiring constructor. There should have been 1 to be able to " + "autowire constructor of bean '" + beanName + "'.");
            }
            String autowiredBeanName = (String)matchingBeans.keySet().iterator().next();
            Object autowiredBean = matchingBeans.values().iterator().next();
            args[j] = autowiredBean;
            if (mergedBeanDefinition.isSingleton()) {
                this.registerDependentBean(autowiredBeanName, beanName);
            }
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info((Object)("Autowiring by type from bean name '" + beanName + "' via constructor to bean named '" + matchingBeans.keySet().iterator().next() + "'"));
        }
        return args;
    }

    private int getTypeDifferenceWeight(Class[] argTypes, Object[] args) {
        int result = 0;
        for (int i = 0; i < argTypes.length; ++i) {
            if (!BeanUtils.isAssignable(argTypes[i], args[i])) {
                return Integer.MAX_VALUE;
            }
            if (args[i] == null) continue;
            Class<?> superClass = args[i].getClass().getSuperclass();
            while (superClass != null) {
                if (argTypes[i].isAssignableFrom(superClass)) {
                    ++result;
                    superClass = superClass.getSuperclass();
                    continue;
                }
                superClass = null;
            }
        }
        return result;
    }

    protected void populateBean(String beanName, RootBeanDefinition mergedBeanDefinition, BeanWrapper bw) throws BeansException {
        MutablePropertyValues pvs = mergedBeanDefinition.getPropertyValues();
        if (mergedBeanDefinition.getResolvedAutowireMode() == 1 || mergedBeanDefinition.getResolvedAutowireMode() == 2) {
            MutablePropertyValues mpvs = new MutablePropertyValues(pvs);
            if (mergedBeanDefinition.getResolvedAutowireMode() == 1) {
                this.autowireByName(beanName, mergedBeanDefinition, bw, mpvs);
            }
            if (mergedBeanDefinition.getResolvedAutowireMode() == 2) {
                this.autowireByType(beanName, mergedBeanDefinition, bw, mpvs);
            }
            pvs = mpvs;
        }
        this.dependencyCheck(beanName, mergedBeanDefinition, bw, pvs);
        this.applyPropertyValues(beanName, mergedBeanDefinition, bw, pvs);
    }

    protected void autowireByName(String beanName, RootBeanDefinition mergedBeanDefinition, BeanWrapper bw, MutablePropertyValues pvs) throws BeansException {
        String[] propertyNames = this.unsatisfiedObjectProperties(mergedBeanDefinition, bw);
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            if (this.containsBean(propertyName)) {
                Object bean = this.getBean(propertyName);
                pvs.addPropertyValue(propertyName, bean);
                if (mergedBeanDefinition.isSingleton()) {
                    this.registerDependentBean(propertyName, beanName);
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Added autowiring by name from bean name '" + beanName + "' via property '" + propertyName + "' to bean named '" + propertyName + "'"));
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Not autowiring property '" + propertyName + "' of bean '" + beanName + "' by name: no matching bean found"));
        }
    }

    protected void autowireByType(String beanName, RootBeanDefinition mergedBeanDefinition, BeanWrapper bw, MutablePropertyValues pvs) throws BeansException {
        String[] propertyNames = this.unsatisfiedObjectProperties(mergedBeanDefinition, bw);
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            Class<?> requiredType = bw.getPropertyDescriptor(propertyName).getPropertyType();
            Map matchingBeans = this.findMatchingBeans(requiredType);
            if (matchingBeans != null && matchingBeans.size() == 1) {
                String autowiredBeanName = (String)matchingBeans.keySet().iterator().next();
                Object autowiredBean = matchingBeans.values().iterator().next();
                pvs.addPropertyValue(propertyName, autowiredBean);
                if (mergedBeanDefinition.isSingleton()) {
                    this.registerDependentBean(autowiredBeanName, beanName);
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Autowiring by type from bean name '" + beanName + "' via property '" + propertyName + "' to bean named '" + matchingBeans.keySet().iterator().next() + "'"));
                continue;
            }
            if (matchingBeans != null && matchingBeans.size() > 1) {
                throw new UnsatisfiedDependencyException(mergedBeanDefinition.getResourceDescription(), beanName, propertyName, "There are " + matchingBeans.size() + " beans of type [" + requiredType + "] for autowire by type. There should have been 1 to be able to autowire property '" + propertyName + "' of bean '" + beanName + "'.");
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Not autowiring property '" + propertyName + "' of bean '" + beanName + "' by type: no matching bean found"));
        }
    }

    protected void dependencyCheck(String beanName, RootBeanDefinition mergedBeanDefinition, BeanWrapper bw, PropertyValues pvs) throws UnsatisfiedDependencyException {
        int dependencyCheck = mergedBeanDefinition.getDependencyCheck();
        if (dependencyCheck == 0) {
            return;
        }
        Set ignoreTypes = this.getIgnoredDependencyTypes();
        PropertyDescriptor[] pds = bw.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            boolean unsatisfied;
            if (pds[i].getWriteMethod() == null || ignoreTypes.contains(pds[i].getPropertyType()) || pvs.getPropertyValue(pds[i].getName()) != null) continue;
            boolean isSimple = BeanUtils.isSimpleProperty(pds[i].getPropertyType());
            boolean bl = unsatisfied = dependencyCheck == 3 || isSimple && dependencyCheck == 2 || !isSimple && dependencyCheck == 1;
            if (!unsatisfied) continue;
            throw new UnsatisfiedDependencyException(mergedBeanDefinition.getResourceDescription(), beanName, pds[i].getName(), "Set this property value or disable dependency checking for this bean.");
        }
    }

    protected String[] unsatisfiedObjectProperties(RootBeanDefinition mergedBeanDefinition, BeanWrapper bw) {
        TreeSet<String> result = new TreeSet<String>();
        Set ignoreTypes = this.getIgnoredDependencyTypes();
        PropertyDescriptor[] pds = bw.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            String name = pds[i].getName();
            if (pds[i].getWriteMethod() == null || BeanUtils.isSimpleProperty(pds[i].getPropertyType()) || ignoreTypes.contains(pds[i].getPropertyType()) || mergedBeanDefinition.getPropertyValues().getPropertyValue(name) != null) continue;
            result.add(name);
        }
        return result.toArray(new String[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyPropertyValues(String beanName, RootBeanDefinition mergedBeanDefinition, BeanWrapper bw, PropertyValues pvs) throws BeansException {
        block8: {
            if (pvs == null) {
                return;
            }
            MutablePropertyValues deepCopy = new MutablePropertyValues(pvs);
            PropertyValue[] pvals = deepCopy.getPropertyValues();
            for (int i = 0; i < pvals.length; ++i) {
                Object value = this.resolveValueIfNecessary(beanName, mergedBeanDefinition, pvals[i].getName(), pvals[i].getValue());
                PropertyValue pv = new PropertyValue(pvals[i].getName(), value);
                deepCopy.setPropertyValueAt(pv, i);
            }
            try {
                if (!this.getCustomEditors().isEmpty()) {
                    AbstractAutowireCapableBeanFactory i = this;
                    synchronized (i) {
                        bw.setPropertyValues(deepCopy);
                        break block8;
                    }
                }
                bw.setPropertyValues(deepCopy);
            }
            catch (BeansException ex) {
                throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, "Error setting property values", ex);
            }
        }
    }

    protected Object resolveValueIfNecessary(String beanName, RootBeanDefinition mergedBeanDefinition, String argName, Object value) throws BeansException {
        if (value instanceof BeanDefinitionHolder) {
            BeanDefinitionHolder bdHolder = (BeanDefinitionHolder)value;
            return this.resolveInnerBeanDefinition(beanName, bdHolder.getBeanName(), bdHolder.getBeanDefinition());
        }
        if (value instanceof BeanDefinition) {
            BeanDefinition bd = (BeanDefinition)value;
            return this.resolveInnerBeanDefinition(beanName, "(inner bean of type " + bd.getBeanClass().getName() + ")", bd);
        }
        if (value instanceof RuntimeBeanReference) {
            RuntimeBeanReference ref = (RuntimeBeanReference)value;
            return this.resolveReference(beanName, mergedBeanDefinition, argName, ref);
        }
        if (value instanceof ManagedList) {
            return this.resolveManagedList(beanName, mergedBeanDefinition, argName, (List)value);
        }
        if (value instanceof ManagedSet) {
            return this.resolveManagedSet(beanName, mergedBeanDefinition, argName, (Set)value);
        }
        if (value instanceof ManagedMap) {
            return this.resolveManagedMap(beanName, mergedBeanDefinition, argName, (Map)value);
        }
        return value;
    }

    protected Object resolveInnerBeanDefinition(String beanName, String innerBeanName, BeanDefinition innerBd) throws BeansException {
        RootBeanDefinition mergedInnerBd = this.getMergedBeanDefinition(innerBeanName, innerBd);
        Object innerBean = this.createBean(innerBeanName, mergedInnerBd, null, false);
        if (mergedInnerBd.isSingleton() && innerBean instanceof DisposableBean) {
            this.registerDependentBean(innerBeanName, beanName);
            this.disposableInnerBeans.put(innerBeanName, innerBean);
        }
        return this.getObjectForSharedInstance(innerBeanName, innerBean);
    }

    protected Object resolveReference(String beanName, RootBeanDefinition mergedBeanDefinition, String argName, RuntimeBeanReference ref) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Resolving reference from property '" + argName + "' in bean '" + beanName + "' to bean '" + ref.getBeanName() + "'"));
        }
        try {
            if (ref.isToParent()) {
                if (this.getParentBeanFactory() == null) {
                    throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, "Can't resolve reference to bean '" + ref.getBeanName() + "' in parent factory: no parent factory available");
                }
                return this.getParentBeanFactory().getBean(ref.getBeanName());
            }
            if (mergedBeanDefinition.isSingleton()) {
                this.registerDependentBean(ref.getBeanName(), beanName);
            }
            return this.getBean(ref.getBeanName());
        }
        catch (BeansException ex) {
            throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, "Can't resolve reference to bean '" + ref.getBeanName() + "' while setting property '" + argName + "'", ex);
        }
    }

    protected List resolveManagedList(String beanName, RootBeanDefinition mergedBeanDefinition, String argName, List ml) throws BeansException {
        ArrayList<Object> resolved = new ArrayList<Object>(ml.size());
        for (int i = 0; i < ml.size(); ++i) {
            resolved.add(this.resolveValueIfNecessary(beanName, mergedBeanDefinition, argName + "[" + i + "]", ml.get(i)));
        }
        return resolved;
    }

    protected Set resolveManagedSet(String beanName, RootBeanDefinition mergedBeanDefinition, String argName, Set ms) throws BeansException {
        HashSet<Object> resolved = new HashSet<Object>(ms.size());
        int i = 0;
        Iterator it = ms.iterator();
        while (it.hasNext()) {
            resolved.add(this.resolveValueIfNecessary(beanName, mergedBeanDefinition, argName + "[" + i + "]", it.next()));
            ++i;
        }
        return resolved;
    }

    protected Map resolveManagedMap(String beanName, RootBeanDefinition mergedBeanDefinition, String argName, Map mm) throws BeansException {
        Map resolved = CollectionFactory.createLinkedMapIfPossible(mm.size());
        Iterator keys = mm.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            resolved.put(key, this.resolveValueIfNecessary(beanName, mergedBeanDefinition, argName + "[" + key + "]", mm.get(key)));
        }
        return resolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void registerDependentBean(String beanName, String dependentBeanName) {
        Map map = this.dependentBeanMap;
        synchronized (map) {
            LinkedList<String> dependencies = (LinkedList<String>)this.dependentBeanMap.get(beanName);
            if (dependencies == null) {
                dependencies = new LinkedList<String>();
                this.dependentBeanMap.put(beanName, dependencies);
            }
            dependencies.add(dependentBeanName);
        }
    }

    protected void invokeInitMethods(String beanName, RootBeanDefinition mergedBeanDefinition, Object bean) throws Throwable {
        if (bean instanceof InitializingBean) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Invoking afterPropertiesSet() on bean with beanName '" + beanName + "'"));
            }
            ((InitializingBean)bean).afterPropertiesSet();
        }
        if (mergedBeanDefinition.getInitMethodName() != null) {
            this.invokeCustomInitMethod(beanName, bean, mergedBeanDefinition.getInitMethodName(), mergedBeanDefinition.getResourceDescription());
        }
    }

    protected void invokeCustomInitMethod(String beanName, Object bean, String initMethodName, String resourceDescription) throws Throwable {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking custom init method '" + initMethodName + "' on bean with beanName '" + beanName + "'"));
        }
        try {
            Method initMethod = BeanUtils.findMethod(bean.getClass(), initMethodName, null);
            if (initMethod == null) {
                throw new NoSuchMethodException("Couldn't find an init method named '" + initMethodName + "' on bean with name '" + beanName + "'");
            }
            if (!Modifier.isPublic(initMethod.getModifiers())) {
                initMethod.setAccessible(true);
            }
            initMethod.invoke(bean, null);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySingletons() {
        super.destroySingletons();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Destroying inner beans in factory {" + this + "}"));
        }
        Map map = this.disposableInnerBeans;
        synchronized (map) {
            Iterator it = new HashSet(this.disposableInnerBeans.keySet()).iterator();
            while (it.hasNext()) {
                this.destroyDisposableInnerBean((String)it.next());
            }
        }
    }

    protected void destroyBean(String beanName, Object bean) {
        List dependencies;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Retrieving dependent beans for bean '" + beanName + "'"));
        }
        if ((dependencies = (List)this.dependentBeanMap.remove(beanName)) != null) {
            Iterator it = dependencies.iterator();
            while (it.hasNext()) {
                String dependentBeanName = (String)it.next();
                if (this.containsBean(dependentBeanName)) {
                    this.destroySingleton(dependentBeanName);
                    continue;
                }
                this.destroyDisposableInnerBean(dependentBeanName);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Applying DestructionAwareBeanPostProcessors to bean with name '" + beanName + "'"));
        }
        for (int i = this.getBeanPostProcessors().size() - 1; i >= 0; --i) {
            Object beanProcessor = this.getBeanPostProcessors().get(i);
            if (!(beanProcessor instanceof DestructionAwareBeanPostProcessor)) continue;
            ((DestructionAwareBeanPostProcessor)beanProcessor).postProcessBeforeDestruction(bean, beanName);
        }
        if (bean instanceof DisposableBean) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Invoking destroy() on bean with name '" + beanName + "'"));
            }
            try {
                ((DisposableBean)bean).destroy();
            }
            catch (Throwable ex) {
                this.logger.error((Object)("destroy() on bean with name '" + beanName + "' threw an exception"), ex);
            }
        }
        try {
            RootBeanDefinition bd = this.getMergedBeanDefinition(beanName, false);
            if (bd.getDestroyMethodName() != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Invoking custom destroy method '" + bd.getDestroyMethodName() + "' on bean with name '" + beanName + "'"));
                }
                this.invokeCustomDestroyMethod(beanName, bean, bd.getDestroyMethodName());
            }
        }
        catch (NoSuchBeanDefinitionException ex) {
            // empty catch block
        }
    }

    private void destroyDisposableInnerBean(String innerBeanName) {
        Object innerBeanInstance = this.disposableInnerBeans.remove(innerBeanName);
        if (innerBeanInstance != null) {
            this.destroyBean(innerBeanName, innerBeanInstance);
        }
    }

    protected void invokeCustomDestroyMethod(String beanName, Object bean, String destroyMethodName) {
        Method destroyMethod = BeanUtils.findDeclaredMethodWithMinimalParameters(bean.getClass(), destroyMethodName);
        if (destroyMethod == null) {
            this.logger.error((Object)("Couldn't find a destroy method named '" + destroyMethodName + "' on bean with name '" + beanName + "'"));
        } else {
            Class<?>[] paramTypes = destroyMethod.getParameterTypes();
            if (paramTypes.length > 1) {
                this.logger.error((Object)("Method '" + destroyMethodName + "' of bean '" + beanName + "' has more than one parameter - not supported as destroy method"));
            } else if (paramTypes.length == 1 && !paramTypes[0].equals(Boolean.TYPE)) {
                this.logger.error((Object)("Method '" + destroyMethodName + "' of bean '" + beanName + "' has a non-boolean parameter - not supported as destroy method"));
            } else {
                Object[] args = new Object[paramTypes.length];
                if (paramTypes.length == 1) {
                    args[0] = Boolean.TRUE;
                }
                if (!Modifier.isPublic(destroyMethod.getModifiers())) {
                    destroyMethod.setAccessible(true);
                }
                try {
                    destroyMethod.invoke(bean, args);
                }
                catch (InvocationTargetException ex) {
                    this.logger.error((Object)("Couldn't invoke destroy method '" + destroyMethodName + "' of bean with name '" + beanName + "'"), ex.getTargetException());
                }
                catch (Throwable ex) {
                    this.logger.error((Object)("Couldn't invoke destroy method '" + destroyMethodName + "' of bean with name '" + beanName + "'"), ex);
                }
            }
        }
    }

    protected abstract Map findMatchingBeans(Class var1) throws BeansException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        (class$org$springframework$beans$factory$DisposableBean == null ? (class$org$springframework$beans$factory$DisposableBean = AbstractAutowireCapableBeanFactory.class$("org.springframework.beans.factory.DisposableBean")) : class$org$springframework$beans$factory$DisposableBean).getName();
        (class$org$springframework$beans$factory$config$DestructionAwareBeanPostProcessor == null ? (class$org$springframework$beans$factory$config$DestructionAwareBeanPostProcessor = AbstractAutowireCapableBeanFactory.class$("org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor")) : class$org$springframework$beans$factory$config$DestructionAwareBeanPostProcessor).getName();
    }
}

