/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.kgslab.spring.axis.client;

import cx.ath.kgslab.spring.axis.TypeMappingDefinition;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.springframework.beans.factory.InitializingBean;

public class AxisInvocationInterceptor
implements MethodInterceptor,
InitializingBean {
    private Service service = null;
    private String url = null;
    private Object[] typeMappings = null;

    public void setService(Service service) {
        this.service = service;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        Call call = this.service.createCall();
        call.setTargetEndpointAddress(this.url);
        call.setOperationName(new QName("http://soapinterop.org/", method.getName()));
        return call.invoke(invocation.getArguments());
    }

    public void afterPropertiesSet() throws Exception {
        if (this.service != null) {
            if (this.typeMappings != null && this.typeMappings.length > 0) {
                TypeMappingRegistry regs = (TypeMappingRegistry)this.service.getTypeMappingRegistry();
                int i = 0;
                while (i < this.typeMappings.length) {
                    TypeMappingDefinition.registerTypeMapping(regs, this.typeMappings[i]);
                    ++i;
                }
            }
        } else {
            throw new IllegalArgumentException("AxisInvocationInterceptor needs to set a service property.");
        }
    }

    public void setTypeMappings(Object[] typeMappings) {
        this.typeMappings = typeMappings;
    }
}

