/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.beans.PropertyEditorSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

public class ResourceEditor
extends PropertyEditorSupport {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$core$io$ResourceEditor == null ? (class$org$springframework$core$io$ResourceEditor = ResourceEditor.class$("org.springframework.core.io.ResourceEditor")) : class$org$springframework$core$io$ResourceEditor));
    public static final String PLACEHOLDER_PREFIX = "${";
    public static final String PLACEHOLDER_SUFFIX = "}";
    private final ResourceLoader resourceLoader;
    static /* synthetic */ Class class$org$springframework$core$io$ResourceEditor;

    public ResourceEditor() {
        this.resourceLoader = new DefaultResourceLoader();
    }

    public ResourceEditor(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setAsText(String text) {
        String locationToUse = this.resolvePath(text).trim();
        this.setValue(this.resourceLoader.getResource(locationToUse));
    }

    protected String resolvePath(String path) {
        int endIndex;
        int startIndex = path.indexOf(PLACEHOLDER_PREFIX);
        if (startIndex != -1 && (endIndex = path.indexOf(PLACEHOLDER_SUFFIX, startIndex + PLACEHOLDER_PREFIX.length())) != -1) {
            String placeholder = path.substring(startIndex + PLACEHOLDER_PREFIX.length(), endIndex);
            String propVal = System.getProperty(placeholder);
            if (propVal != null) {
                return path.substring(0, startIndex) + propVal + path.substring(endIndex + 1);
            }
            logger.warn((Object)("Could not resolve placeholder '" + placeholder + "' in resource path [" + path + "] as system property"));
        }
        return path;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

