/*
 * $Id$
 */
package cx.ath.kgslab.spring.axis;

import javax.xml.namespace.QName;

import org.apache.axis.Constants;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.ser.BaseDeserializerFactory;
import org.apache.axis.encoding.ser.BaseSerializerFactory;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.wsdl.fromJava.Namespaces;


/**
 * ^Cv}bsO`.
 * @author NAGASAWA Takahiro
 * @version $Revision$
 */
public class TypeMappingDefinition {
  private Class type = null;
  private String localName = null;
  private String namespace = null;
  private Class seralizerClass = null;
  private Class deserializerClass = null;
  private String encodingStyle = null;

  /**
   * @return Returns the encodingStyle.
   */
  public String getEncodingStyle() {
    return encodingStyle;
  }

  /**
   * SOAPGR[fBOX^CURIݒ肷.
   * @param encodingStyle The encodingStyle to set.
   */
  public void setEncodingStyle(String encodingStyle) {
    this.encodingStyle = encodingStyle;
  }

  /**
   * @return Returns the type.
   */
  public Class getType() {
    return type;
  }

  /**
   * ^Cv}bsOKvȃNXݒ肷.
   * @param type The type to set.
   */
  public void setType(Class beanClass) {
    this.type = beanClass;
  }

  /**
   * @return Returns the namespace.
   */
  public String getNamespace() {
    return namespace;
  }

  /**
   * ^Cv̖OԂݒ肷.
   * @param namespace The namespace to set.
   */
  public void setNamespace(String namespace) {
    this.namespace = namespace;
  }

  /**
   * @return Returns the localName.
   */
  public String getLocalName() {
    return localName;
  }

  /**
   * ^CvLocal Nameݒ肷.
   * @param localName The localName to set.
   */
  public void setLocalName(String qname) {
    this.localName = qname;
  }

  /**
   * @return Returns the deserializerClass.
   */
  public Class getDeserializerClass() {
    return deserializerClass;
  }

  /**
   * ^CṽfVACUNXݒ肷.
   * @param deserializerClass The deserializerClass to set.
   */
  public void setDeserializerClass(Class deserializerClass) {
    this.deserializerClass = deserializerClass;
  }

  /**
   * @return Returns the seralizerClass.
   */
  public Class getSeralizerClass() {
    return seralizerClass;
  }

  /**
   * ^CṽVACUNXݒ肷.
   * @param seralizerClass The seralizerClass to set.
   */
  public void setSeralizerClass(Class seralizerClass) {
    this.seralizerClass = seralizerClass;
  }

  /**
   * ^Cv}bsO̓o^.
   * @param regs o^^Cv}bsOWXg
   */
  public void registerTypeMapping(TypeMappingRegistry regs) {
    final Class type = this.getType();
    QName qname = null;

    final boolean isSetNS =
      ((this.namespace != null) && (this.namespace.length() > 0));
    final boolean isSetLN =
      ((this.localName != null) && (this.localName.length() > 0));

    if (isSetNS && isSetLN) {
      qname = new QName(this.namespace, this.localName);
    } else if (isSetNS) {
      qname =
        new QName(this.namespace, getLocalNameFromClass(type));
    } else if (isSetLN) {
      qname =
        new QName(getNamespaceFromClass(type), this.localName);
    } else {
      qname = TypeMappingDefinition.getQNameFromClass(type);
    }

    String encstyle = null;

    if ((this.encodingStyle != null)
          && (this.encodingStyle.length() > 0)
          && Constants.isSOAP_ENC(this.encodingStyle)) {
      encstyle = this.encodingStyle;
    } else {
      encstyle = Constants.URI_DEFAULT_SOAP_ENC;
    }

    TypeMapping mapping = regs.getOrMakeTypeMapping(encstyle);

    if (!mapping.isRegistered(type, qname)) {
      Class serializer = this.getSeralizerClass();

      if (serializer == null) {
        serializer = BeanSerializerFactory.class;
      }

      Class deserializer = this.getDeserializerClass();

      if (deserializer == null) {
        deserializer = BeanDeserializerFactory.class;
      }

      mapping.register(type, qname,
        BaseSerializerFactory.createFactory(serializer, type,
          qname),
        BaseDeserializerFactory.createFactory(deserializer,
          type, qname));
    }
  }

  private static String getNamespaceFromClass(Class type) {
    return Namespaces.makeNamespace(type.getName());
  }

  private static QName getQNameFromClass(Class type) {
    return new QName(getNamespaceFromClass(type),
      getLocalNameFromClass(type));
  }

  /**
   * @param name
   * @return
   */
  private static String getLocalNameFromClass(Class type) {
    String name = type.getName();

    return name.substring(name.lastIndexOf('.') + 1);
  }

  /**
   * @param regs
   * @param temp
   * @throws ClassNotFoundException
   */
  public static void registerTypeMapping(final TypeMappingRegistry regs, Object temp) throws ClassNotFoundException {
    TypeMappingDefinition typemapping = null;
    if (temp instanceof TypeMappingDefinition) {
      typemapping =
        (TypeMappingDefinition) temp;
    } else if (temp instanceof Class) {
      typemapping = new TypeMappingDefinition();
      typemapping.setType((Class) temp);
    } else if (temp instanceof String) {
      typemapping = new TypeMappingDefinition();
      typemapping.setType(ClassUtils.forName(
          (String) temp));
    } else {
      typemapping = new TypeMappingDefinition();
      typemapping.setType(temp.getClass());
    }
  
    typemapping.registerTypeMapping(regs);
  }
}
