/*
 * $Id: AxisInvocationInterceptor.java,v 1.1 2004/11/29 14:49:40 mashu Exp $
 */
package cx.ath.kgslab.spring.axis.client;

import java.lang.reflect.Method;

import javax.xml.namespace.QName;
import javax.xml.rpc.Call;

import org.apache.axis.client.Service;
import org.apache.axis.encoding.TypeMappingRegistry;

import cx.ath.kgslab.spring.axis.TypeMappingDefinition;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;


/**
 * IďoC^tF[X̃C^[Zv^.
 * S2AxisDynamicInvocationInterceptorQlɎB
 * @author NAGASAWA Takahiro
 * @version $Revision: 1.1 $
 */
public class AxisInvocationInterceptor
  implements MethodInterceptor, InitializingBean,
    BeanFactoryAware {
  private Service service = null;
  private String url = null;
  private Object[] typeMappings = null;
  private BeanFactory beanFactory = null;

  /**
   * RXgN^.
   */
  public AxisInvocationInterceptor() {
  }

  /**
   * IďoɕKvȁAT[rXIuWFNgݒ肷.
   * @param service The service to set.
   */
  public void setService(Service service) {
    this.service = service;
  }

  /**
   * ΏۃEFuT[rXURLݒ肷.
   * @param url The url to set.
   */
  public void setUrl(String url) {
    this.url = url;
  }

  /**
   * \bhďoT[rX̌Ăяoɕϊ.
   * @param invocation \bhďo
   */
  public Object invoke(final MethodInvocation invocation)
    throws Throwable {
    final Method method = invocation.getMethod();
    final Call call = (Call) service.createCall();
    call.setTargetEndpointAddress(url);
    call.setOperationName(new QName("http://soapinterop.org/",
        method.getName()));

    return call.invoke(invocation.getArguments());
  }

  /**
   * .
   * ^Cv}bsO`T[rXIuWFNgɔfB
   * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
   */
  public void afterPropertiesSet() throws Exception {
    if (service == null) {
      Object bean = null;

      if (beanFactory.containsBean("service")
            && (bean = beanFactory.getBean("service")) instanceof Service) {
        service = (Service) bean;
      } else {
        service = new Service();
      }
    }

    if ((typeMappings != null) && (typeMappings.length > 0)) {
      TypeMappingRegistry regs =
        (TypeMappingRegistry) service.getTypeMappingRegistry();

      for (int i = 0; i < typeMappings.length; i++) {
        TypeMappingDefinition.registerTypeMapping(regs,
          typeMappings[i]);
      }
    }
  }

  /**
   * ^Cv}bsO`ݒ肷.
   * @param typeMappings The serializerSettings to set.
   */
  public void setTypeMappings(Object[] typeMappings) {
    this.typeMappings = typeMappings;
  }

  /**
   * @see org.springframework.beans.factory.BeanFactoryAware#setBeanFactory(org.springframework.beans.factory.BeanFactory)
   */
  public void setBeanFactory(BeanFactory beanFactory)
    throws BeansException {
    this.beanFactory = beanFactory;
  }
}
