/*
 * $Id: AxisProxyFactoryBean.java,v 1.2 2004/12/08 10:29:09 mashu Exp $
 */
package cx.ath.kgslab.spring.axis.client;

import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.FactoryBean;


/**
 * EFuT[rXIďovLVt@Ng.
 * ^ꂽURL̃T[rXA
 * ^ꂽC^tF[XŌĂяo߂
 * vLVIuWFNg𐶐B
 * <br>
 * ݒ:
<pre>
 &lt;bean id="test" class="cx.ath.kgslab.spring.axis.client.AxisProxyFactoryBean"&gt;
  &lt;!-- T[rX̃C^[tFCX --&gt;
  &lt;property name="serviceInterface"&gt;
   &lt;value&gt;cx.ath.kgslab.test.TestService&lt;/value&gt;
  &lt;/property&gt;
  &lt;!-- T[rXJĂURL --&gt;
  &lt;property name="url"&gt;
   &lt;value&gt;http://localhost:8080/SpringAxisTest/services/test&lt;/value&gt;
  &lt;/property&gt;
  &lt;!-- RPCIsɕKvServiceNX(ȗ) --&gt;
  &lt;property name="service"&gt;
   &lt;bean class="org.apache.axis.client.Service"/&gt;
  &lt;/property&gt;
  &lt;!-- ^Cv}bsOKvȃNX --&gt;
  &lt;property name="typeMappings"&gt;
   &lt;value&gt;cx.ath.kgslab.test.data.TestData&lt;/value&gt;
  &lt;/property&gt;
 &lt;/bean&gt;
</pre>
 * ̃T[rXJꍇɂ́A
 * servicẽvpeB͒beanݒ肷̂ł͂ȂA
 * ʓrbeanݒ肵āAt@Xݒ肷悤ɂقB
 * <br>
 * typeMappings̃vpeBɂ́A
 * BeanSerializerŏł悤ȒPBeanł΃NXŁA
 * ^Cv}bsOݒ肪IB
 * VACUAfVACUʓrݒ肷Kv΁A
 * TypeMappingDefinitiongpďڍׂȐݒsƂłB
 *
 * @author NAGASAWA Takahiro
 * @version $Revision: 1.2 $
 */
public class AxisProxyFactoryBean
  extends AxisInvocationInterceptor implements FactoryBean {
  private Class serviceInterface = null;

  /**
   * T[rXĂяoC^tF[X.
   * @param serviceInterface The serviceInterface to set.
   */
  public void setServiceInterface(Class serviceInterface) {
    this.serviceInterface = serviceInterface;
  }

  /**
   * @see org.springframework.beans.factory.FactoryBean#getObject()
   */
  public Object getObject() throws Exception {
    return ProxyFactory.getProxy(serviceInterface, this);
  }

  /**
   * @see org.springframework.beans.factory.FactoryBean#getObjectType()
   */
  public Class getObjectType() {
    return serviceInterface;
  }

  /**
   * @see org.springframework.beans.factory.FactoryBean#isSingleton()
   */
  public boolean isSingleton() {
    return true;
  }
}
