/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include <math.h>
#include <stdlib.h>

#include "fish.h"

CFish::CFish(int scx,int scy,int x,int y, PIXMAP *img)
{
	int i;

	CFishInit(scx,scy,x,y,img);

	//init rad table
	for(i=0;i<24;++i) rad_table[i]=3.14*(double)i/12;

	//set parameter 
	randset();
	
	setVisible(true);

}
void CFish::CFishInit(int scx,int scy,int x,int y,PIXMAP *img)
{
	  SCREENH=scy;
	  SCREENW=scx;
	  x_size=x;
	  y_size=y;
      
	  fishBMP = img;

}
CFish::~CFish()
{


}

int CFish::makerad()
{
	return (rand() % 24);
}
//
// set way
//
void CFish::setWay(int i)
{
	way = i;
	rad = rad_table[i];
}
//
// set position of fish
//
void CFish::randset()
{
	setPos(rand() % 500,rand() % 400);
	real_x = (double)(x0 = getPosX());
	real_y = (double)(y0 = getPosY());
	setWay(makerad());
	setVisible(true);
	speed = 6.0;
}

void CFish::draw(PAINTER* painter)
{
	PIXMAP *imgBMP;

	if(!getVisible()) return;

	switch(way){
		case 0:case 1:case 23:
			// right
			imgBMP = &fishBMP[3];
			break;
		case 2:case 3:case 4:
			// slant right down
			imgBMP = &fishBMP[6];
			break;
		case 5:case 6:case 7:
			// down
			imgBMP = &fishBMP[1];
			break;
		case 8:case 9:case 10:
			// slant left down
			imgBMP = &fishBMP[7];
			break;
		case 11:case 12:case 13:
			// left
			imgBMP = &fishBMP[2];
			break;
		case 14:case 15:case 16:
			// slant left up
			imgBMP = &fishBMP[5];
			break;
		case 17:case 18:case 19:
			// up
			imgBMP = &fishBMP[0];
			break;
		default:
			// slant right up
			imgBMP = &fishBMP[4];
			break;
	}

	painter->drawPixmap(m_pos_x,m_pos_y, *imgBMP);


}
//
// If x postion of fish is out of visible area,return false .
//
bool CFish::cheak_x(int x)
{
   if( x < 0 || x > SCREENW - x_size ) return false;
   return true;
}
//
// If y postion of fish is out of visible area,return false . 
//
bool CFish::cheak_y(int y)
{
   if( y < 0 || y > SCREENH - y_size ) return false;
   return true;
}

void CFish::set_real_y_slow()
{
	  real_y += speed * sin(rad);
	  if(!cheak_y((int)real_y)){
		  if(real_y < 0.0) real_y = 0.0; 
		  else real_y = (double)(SCREENH - y_size);
		  setWay(makerad());
//		  speed = (int)((8 - 3 + 1) * rand() + 3);
		  speed = (rand() % 4) + 3;
	  }
	  if((int)((100 - 0 + 1) * rand() + 0) % 15 == 0) setWay(makerad());

}

void CFish::set_real_y()
{
	  real_y += speed * sin(rad);
	  if(!cheak_y((int)real_y)){
		  if(real_y < 0.0) real_y = 0.0; 
		  else real_y = (double)(SCREENH - y_size);
		  setWay(makerad());
//		  speed = (int)((16 - 6 + 1) * rand() + 6);
//		  speed = (rand() % 12) + 6;
		  speed = (rand() % 12) + 4;
	  }
	  if((int)((100 - 0 + 1) * rand() + 0) % 15 == 0) setWay(makerad());

}

void CFish::set_real_x_slow()
{
	  real_x += speed * cos(rad);
	  if(!cheak_x((int)real_x) ){
		  if(real_x < 0.0) real_x = 0.0; 
		  else real_x = (double)(SCREENW - x_size);
		  setWay(makerad());
		  speed = (int)((6 - 3 + 1) * rand() + 3);
	  }

	  if((int)((100 - 0 + 1) * rand() + 0) % 8 == 0) setWay(makerad());
}

void CFish::set_real_x()
{
	  real_x += speed * cos(rad);

	  if(!cheak_x((int)real_x) ){
		  if(real_x < 0.0) real_x = 0.0; 
		  else real_x = (double)(SCREENW - x_size);
		  setWay(makerad());
//		  speed = (int)((12 - 6 + 1) * rand() + 6);
//		  speed = (rand() % 12) + 6;
		  speed = (rand() % 12) + 4;
	  }

	  if((int)((100 - 0 + 1) * rand() + 0) % 8 == 0) setWay( makerad() );
}

void CFish::movefast()
{
	set_real_x();
	set_real_y();
	setPos((int)real_x,(int)real_y);
}

void CFish::moveslow()
{
	set_real_x_slow();
	set_real_y_slow();
	setPos((int)real_x,(int)real_y);
}
