#!/bin/sh

if [ "$1" = "cross" ]; then
    export CROSSCOMPILE=/opt/Embedix/tools
    export QPEDIR=/opt/Qtopia/sharp
    export QTDIR=/opt/Qtopia/sharp
    export PATH=$QTDIR/bin:$QPEDIR/bin:$CROSSCOMPILE/bin:$PATH
    export TMAKEPATH=/opt/Qtopia/tmake/lib/qws/linux-sharp-g++/
    export LD_LIBRARY_PATH=$QTDIR/lib:$LD_LIBRARY_PATH
elif [ "$1" = "native" ]; then
    export CROSSCOMPILE=
    export QPEDIR=/opt/Qtopia
    export QTDIR=/opt/Qtopia
    export PATH=$QTDIR/bin:$QPEDIR/bin:$PATH:/opt/Embedix/tools/bin
    export TMAKEPATH=/opt/Qtopia/tmake/lib/qws/linux-x86-g++/
    export LD_LIBRARY_PATH=$QTDIR/lib:$LD_LIBRARY_PATH
else
    echo "usage: $0 cross | native"
    exit 1
fi

TMPDIR=qfish_1.0.0

make -C tools
make -C images

tmake -o Makefile qfish.pro
make

mkdir ${TMPDIR}
cd ${TMPDIR}
mkdir -p opt/QtPalmtop/apps/Games
mkdir -p opt/QtPalmtop/bin
mkdir -p opt/QtPalmtop/pics
mkdir -p opt/QtPalmtop/help/html
mkdir -p CONTROL
cp ../desktop/qfish.desktop opt/QtPalmtop/apps/Games
cp ../qfish opt/QtPalmtop/bin
cp ../desktop/qfish.png opt/QtPalmtop/pics
cp ../desktop/qfish.html opt/QtPalmtop/help/html
cp ../desktop/qfish.control CONTROL/control
cd ..
ipkg-build ${TMPDIR}
rm -rf ${TMPDIR}

