/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifndef HITAREA_H
#define HITAREA_H

#define AREA_INCLUDED    0
#define AREA_CONFLICT    1
#define AREA_NO_CONFLICT 2

class CHitArea{

 public:
  CHitArea();
  CHitArea(int offset_x, int offset_y, int width, int hegiht);
  void SetPos( int x, int y );
  void SetBasePos( int x, int y );

  int GetWidth();
  int GetHeight();
  int GetPosX();
  int GetPosY();

  int Compare( CHitArea *area );
  CHitArea& operator=(const CHitArea& src);

 protected:
  int m_basepos_x;
  int m_basepos_y;

  int m_offset_x;
  int m_offset_y;

  int m_width;
  int m_height;

  
  
};


#endif


